/*
 * Decompiled with CFR 0.152.
 */
package com.geese.plugin.excel;

import com.geese.plugin.excel.ExcelContext;
import com.geese.plugin.excel.ExcelOperations;
import com.geese.plugin.excel.ExcelOperationsProxyFactory;
import com.geese.plugin.excel.ExcelResult;
import com.geese.plugin.excel.filter.ReadFilter;
import com.geese.plugin.excel.mapping.ClientMapping;
import com.geese.plugin.excel.mapping.ExcelMapping;
import com.geese.plugin.excel.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelReader {
    private ClientMapping clientMapping = new ClientMapping();

    public static ExcelReader newInstance(InputStream excelInput) {
        ExcelReader instance = new ExcelReader();
        instance.clientMapping.setExcelInput(excelInput);
        return instance;
    }

    public ExcelReader select(String query) {
        Assert.notEmpty(query);
        this.clientMapping.getQueries().add(query);
        return this;
    }

    public ExcelReader select(String first, String second, String ... more) {
        Assert.notEmpty(first, second);
        List<String> queries = this.clientMapping.getQueries();
        queries.add(first);
        queries.add(second);
        if (null != more && more.length > 0) {
            queries.addAll(Arrays.asList(more));
        }
        return this;
    }

    public ExcelReader filter(ReadFilter filter) {
        return this.filter(filter, "0");
    }

    public ExcelReader filter(ReadFilter filter, String switchSheet) {
        this.clientMapping.addFilter(filter, switchSheet);
        return this;
    }

    public ExcelReader filters(ReadFilter[] filters) {
        return this.filters(filters, "0");
    }

    public ExcelReader filters(ReadFilter[] filters, String switchSheet) {
        return this.filters(Arrays.asList(filters), switchSheet);
    }

    public ExcelReader filters(Collection<ReadFilter> filters) {
        return this.filters(filters, "0");
    }

    public ExcelReader filters(Collection<ReadFilter> filters, String switchSheet) {
        for (ReadFilter filter : filters) {
            this.clientMapping.addFilter(filter, switchSheet);
        }
        return this;
    }

    public ExcelResult execute() throws IOException, InvalidFormatException {
        ExcelMapping excelMapping = this.clientMapping.parseClientInput();
        Workbook workbook = WorkbookFactory.create((InputStream)this.clientMapping.getExcelInput());
        ExcelOperations proxy = ExcelOperationsProxyFactory.getProxy();
        Map data = (Map)proxy.readExcel(workbook, excelMapping);
        ExcelResult excelResult = new ExcelResult();
        excelResult.setData(data);
        excelResult.setContext(ExcelContext.get());
        return excelResult;
    }
}

