/*
 * Decompiled with CFR 0.152.
 */
package com.geese.plugin.excel;

import com.geese.plugin.excel.ExcelContext;
import com.geese.plugin.excel.ExcelHelper;
import com.geese.plugin.excel.ExcelOperations;
import com.geese.plugin.excel.ExcelOperationsProxyFactory;
import com.geese.plugin.excel.mapping.CellMapping;
import com.geese.plugin.excel.mapping.ExcelMapping;
import com.geese.plugin.excel.mapping.SheetMapping;
import com.geese.plugin.excel.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelTemplate
implements ExcelOperations {
    private static final Logger logger = Logger.getLogger(ExcelTemplate.class.getName());

    @Override
    public Object readExcel(Workbook workbook, ExcelMapping excelMapping) {
        Assert.notNull(workbook, excelMapping);
        Collection<SheetMapping> sheetMappings = excelMapping.getSheetMappings();
        Assert.notEmpty(sheetMappings);
        LinkedHashMap<String, Object> returnValue = new LinkedHashMap<String, Object>();
        Sheet sheet = null;
        for (SheetMapping sheetMapping : sheetMappings) {
            Integer index;
            String name = sheetMapping.getName();
            if (null != name && null == (sheet = workbook.getSheet(name)) && null != (index = sheetMapping.getIndex())) {
                sheet = workbook.getSheetAt(index.intValue());
            }
            Assert.notNull(sheet, "\u6839\u636e\u540d\u79f0:[%s]\u672a\u83b7\u53d6\u5230Sheet", name);
            Object sheetData = ExcelOperationsProxyFactory.getProxy().readSheet(sheet, sheetMapping);
            returnValue.put(sheetMapping.getDataKey(), sheetData);
        }
        return returnValue;
    }

    @Override
    public Object readSheet(Sheet sheet, SheetMapping sheetMapping) {
        List<CellMapping> points;
        Assert.notNull(sheet, sheetMapping);
        LinkedHashMap<String, Cloneable> returnValue = new LinkedHashMap<String, Cloneable>();
        List<CellMapping> tableHeads = sheetMapping.getTableHeads();
        if (null != tableHeads && !tableHeads.isEmpty()) {
            Integer startRow = sheetMapping.getStartRow();
            startRow = null == startRow ? 0 : startRow;
            Integer endRow = sheetMapping.getEndRow();
            int lastRowNum = sheet.getLastRowNum() + 1;
            endRow = null == endRow ? lastRowNum : Math.min(endRow, lastRowNum);
            ArrayList<Object> tableData = new ArrayList<Object>();
            for (int i = startRow.intValue(); i < endRow; ++i) {
                Row row = sheet.getRow(i);
                Object rowData = ExcelOperationsProxyFactory.getProxy().readRow(row, sheetMapping);
                if ("EXCEL_NOT_PASS_FILTERED".equals(rowData)) {
                    returnValue.put("tableData", tableData);
                    return returnValue;
                }
                tableData.add(rowData);
            }
            returnValue.put("tableData", tableData);
        }
        if (null != (points = sheetMapping.getPoints()) && !points.isEmpty()) {
            LinkedHashMap<String, Object> mapPointsData = new LinkedHashMap<String, Object>();
            for (CellMapping point : points) {
                Cell cell;
                Integer rowNumber = point.getRowNumber();
                Integer columnNumber = point.getColumnNumber();
                Row row = sheet.getRow(rowNumber.intValue());
                Object cellData = null;
                if (null != row && null != (cell = row.getCell(columnNumber.intValue()))) {
                    cellData = this.readCell(cell, point);
                }
                mapPointsData.put(point.getDataKey(), cellData);
            }
            returnValue.put("pointData", mapPointsData);
        }
        return returnValue;
    }

    @Override
    public Object readRow(Row row, SheetMapping sheetMapping) {
        if (null == row) {
            return null;
        }
        List<CellMapping> tableHeads = sheetMapping.getTableHeads();
        Assert.notEmpty(tableHeads);
        LinkedHashMap<String, Object> returnValue = new LinkedHashMap<String, Object>();
        for (CellMapping tableHead : tableHeads) {
            Integer columnNumber = tableHead.getColumnNumber();
            Cell cell = row.getCell(columnNumber.intValue());
            Object cellData = this.readCell(cell, tableHead);
            returnValue.put(tableHead.getDataKey(), cellData);
        }
        return returnValue;
    }

    @Override
    public Object readCell(Cell cell, CellMapping cellMapping) {
        return ExcelHelper.getCellValue(cell);
    }

    @Override
    public void writeExcel(Workbook workbook, ExcelMapping excelMapping) {
        Assert.notNull(workbook, excelMapping);
        Collection<SheetMapping> sheetMappings = excelMapping.getSheetMappings();
        Assert.notEmpty(sheetMappings);
        for (SheetMapping sheetMapping : sheetMappings) {
            Sheet sheet = this.getRawSheet(workbook, sheetMapping);
            if (null == sheet) {
                sheet = workbook.createSheet(sheetMapping.getName());
                sheetMapping.setIndex(workbook.getSheetIndex(sheet));
            }
            ExcelOperationsProxyFactory.getProxy().writeSheet(sheet, sheetMapping);
        }
    }

    private Sheet getRawSheet(Workbook workbook, SheetMapping sheetMapping) {
        Sheet sheet;
        Sheet sheet2;
        Assert.notNull(workbook, sheetMapping);
        if (!workbook.iterator().hasNext()) {
            return null;
        }
        String name = sheetMapping.getName();
        if (null != name && null != (sheet2 = workbook.getSheet(name))) {
            sheetMapping.setIndex(workbook.getSheetIndex(sheet2));
            return sheet2;
        }
        Integer index = sheetMapping.getIndex();
        if (null != index && null != (sheet = workbook.getSheetAt(index.intValue()))) {
            sheetMapping.setName(sheet.getSheetName());
            return sheet;
        }
        return null;
    }

    @Override
    public void writeSheet(Sheet sheet, SheetMapping sheetMapping) {
        List<CellMapping> points;
        List tableData = sheetMapping.getTableData();
        if (null != tableData && !tableData.isEmpty()) {
            Integer startRow = sheetMapping.getStartRow();
            startRow = null == startRow ? 0 : startRow;
            Integer rowInterval = sheetMapping.getRowInterval();
            if (null == rowInterval || rowInterval <= 0) {
                rowInterval = 1;
            } else {
                Integer n = rowInterval;
                Integer n2 = rowInterval = Integer.valueOf(rowInterval + 1);
            }
            for (Map rowData : tableData) {
                Row row = ExcelHelper.createRow(sheet, startRow);
                ExcelOperationsProxyFactory.getProxy().writeRow(row, sheetMapping, rowData);
                if (ExcelContext.get().containsKey("EXCEL_NOT_PASS_FILTERED")) {
                    return;
                }
                startRow = startRow + rowInterval;
            }
        }
        if (null != (points = sheetMapping.getPoints()) && !points.isEmpty()) {
            for (CellMapping point : points) {
                Integer rowNumber = point.getRowNumber();
                Integer columnNumber = point.getColumnNumber();
                Row row = ExcelHelper.createRow(sheet, rowNumber);
                Cell cell = ExcelHelper.createCell(row, columnNumber);
                ExcelOperationsProxyFactory.getProxy().writeCell(cell, sheetMapping, point.getData());
            }
        }
    }

    @Override
    public void writeRow(Row row, SheetMapping sheetMapping, Map data) {
        List<CellMapping> tableHeads = sheetMapping.getTableHeads();
        for (CellMapping head : tableHeads) {
            if (data.containsKey(head.getDataKey())) {
                Object cellData = data.get(head.getDataKey());
                Integer columnNumber = head.getColumnNumber();
                Cell cell = ExcelHelper.createCell(row, columnNumber);
                ExcelOperationsProxyFactory.getProxy().writeCell(cell, sheetMapping, cellData);
                continue;
            }
            logger.warning("\u6570\u636e\uff1a" + data + ", \u4e0d\u5305\u542b\u5217\uff1a" + head.getDataKey());
        }
    }

    @Override
    public void writeCell(Cell cell, SheetMapping sheetMapping, Object data) {
        ExcelHelper.setCellValue(cell, data);
    }
}

