/*
 * Decompiled with CFR 0.152.
 */
package com.geese.plugin.excel;

import com.geese.plugin.excel.ExcelHelper;
import java.util.Collection;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class ExcelValidation {
    private Integer firstRow;
    private Integer lastRow;
    private Integer firstCol;
    private Integer lastCol;
    private Integer validationType;
    private Integer operatorType;
    private Collection constraintValues;
    private Boolean suppressDropDownArrow = true;
    private Boolean showErrorBox = true;

    public ExcelValidation() {
    }

    public ExcelValidation(Integer firstRow, Integer lastRow, Integer firstCol, Integer lastCol, Collection constraintValues) {
        this();
        this.firstRow = firstRow;
        this.lastRow = lastRow;
        this.firstCol = firstCol;
        this.lastCol = lastCol;
        this.constraintValues = constraintValues;
    }

    public ExcelValidation(Integer firstRow, Integer lastRow, Integer firstCol, Integer lastCol, Integer validationType, Integer operatorType, Collection constraintValues) {
        this(firstRow, lastRow, firstCol, lastCol, constraintValues);
        this.validationType = validationType;
        this.operatorType = operatorType;
    }

    public Integer getFirstRow() {
        return this.firstRow;
    }

    public void setFirstRow(Integer firstRow) {
        this.firstRow = firstRow;
    }

    public Integer getLastRow() {
        return this.lastRow;
    }

    public void setLastRow(Integer lastRow) {
        this.lastRow = lastRow;
    }

    public Integer getFirstCol() {
        return this.firstCol;
    }

    public void setFirstCol(Integer firstCol) {
        this.firstCol = firstCol;
    }

    public Integer getLastCol() {
        return this.lastCol;
    }

    public void setLastCol(Integer lastCol) {
        this.lastCol = lastCol;
    }

    public Integer getValidationType() {
        return this.validationType;
    }

    public void setValidationType(Integer validationType) {
        this.validationType = validationType;
    }

    public Integer getOperatorType() {
        return this.operatorType;
    }

    public void setOperatorType(Integer operatorType) {
        this.operatorType = operatorType;
    }

    public Collection getConstraintValues() {
        return this.constraintValues;
    }

    public void setConstraintValues(Collection constraintValues) {
        this.constraintValues = constraintValues;
    }

    public Boolean getSuppressDropDownArrow() {
        return this.suppressDropDownArrow;
    }

    public void setSuppressDropDownArrow(Boolean suppressDropDownArrow) {
        this.suppressDropDownArrow = suppressDropDownArrow;
    }

    public Boolean getShowErrorBox() {
        return this.showErrorBox;
    }

    public void setShowErrorBox(Boolean showErrorBox) {
        this.showErrorBox = showErrorBox;
    }

    public void addToSheet(Sheet sheet) {
        CellRangeAddressList addressList = new CellRangeAddressList(this.firstRow.intValue(), this.lastRow.intValue(), this.firstCol.intValue(), this.lastCol.intValue());
        HSSFDataValidation validation = null;
        String[] values = this.constraintValues.toArray(new String[this.constraintValues.size()]);
        boolean isListValidationType = null == this.validationType;
        String listFormula = null;
        if (isListValidationType) {
            String hiddenSheetName;
            Workbook wk = sheet.getWorkbook();
            Sheet hiddenSheet = wk.getSheet(hiddenSheetName = "__Hidden_Sheet__");
            if (null == hiddenSheet) {
                hiddenSheet = wk.createSheet(hiddenSheetName);
                wk.setSheetHidden(wk.getSheetIndex(hiddenSheet), true);
            }
            Row firstRow = ExcelHelper.createRow(hiddenSheet, 0);
            Cell cell = null;
            for (int i = 0; i < 16384; ++i) {
                cell = firstRow.getCell(i);
                if (null != cell) continue;
                cell = firstRow.createCell(i);
                break;
            }
            int columnIndex = cell.getColumnIndex();
            String colAlphabet = CellReference.convertNumToColString((int)columnIndex);
            for (int i = 0; i < values.length; ++i) {
                ExcelHelper.createRow(hiddenSheet, i).createCell(columnIndex).setCellValue(values[i]);
            }
            Name namedCell = wk.createName();
            listFormula = hiddenSheetName + colAlphabet + "1" + colAlphabet + values.length;
            namedCell.setNameName(listFormula);
            namedCell.setRefersToFormula(hiddenSheetName + "!$" + colAlphabet + "$1:$" + colAlphabet + "$" + values.length);
        }
        if (sheet instanceof HSSFSheet) {
            DVConstraint dvConstraint = null;
            if (isListValidationType) {
                dvConstraint = DVConstraint.createFormulaListConstraint(listFormula);
            } else {
                switch (this.validationType) {
                    case 1: 
                    case 2: 
                    case 6: {
                        dvConstraint = DVConstraint.createNumericConstraint((int)this.validationType, (int)this.operatorType, (String)values[0], values.length == 2 ? values[1] : null);
                    }
                }
            }
            validation = new HSSFDataValidation(addressList, (DataValidationConstraint)dvConstraint);
        } else {
            XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper((XSSFSheet)sheet);
            DataValidationConstraint dvConstraint = null;
            if (isListValidationType) {
                dvConstraint = dvHelper.createFormulaListConstraint(listFormula);
            } else {
                switch (this.validationType) {
                    case 1: 
                    case 2: 
                    case 6: {
                        dvConstraint = dvHelper.createNumericConstraint(this.validationType.intValue(), this.operatorType.intValue(), values[0], values.length == 2 ? values[1] : null);
                    }
                }
            }
            validation = dvHelper.createValidation(dvConstraint, addressList);
        }
        validation.setSuppressDropDownArrow(this.suppressDropDownArrow.booleanValue());
        validation.setShowErrorBox(this.showErrorBox.booleanValue());
        sheet.addValidationData((DataValidation)validation);
    }
}

