/*
 * Decompiled with CFR 0.152.
 */
package com.geese.plugin.excel;

import com.geese.plugin.excel.ExcelContext;
import com.geese.plugin.excel.ExcelHelper;
import com.geese.plugin.excel.ExcelOperations;
import com.geese.plugin.excel.ExcelOperationsProxyFactory;
import com.geese.plugin.excel.ExcelResult;
import com.geese.plugin.excel.ExcelValidation;
import com.geese.plugin.excel.filter.WriteFilter;
import com.geese.plugin.excel.mapping.ClientMapping;
import com.geese.plugin.excel.mapping.ExcelMapping;
import com.geese.plugin.excel.util.Assert;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelWriter {
    private ClientMapping clientMapping = new ClientMapping();

    public static ExcelWriter newInstance(OutputStream excelOutput) {
        ExcelWriter instance = new ExcelWriter();
        instance.clientMapping.setExcelOutput(excelOutput);
        return instance;
    }

    public ExcelWriter useXlsxFormat() {
        this.clientMapping.setUseXlsFormat(false);
        return this;
    }

    public ExcelWriter setTemplate(File template) {
        this.clientMapping.setExcelOutputTemplate(template);
        return this;
    }

    public ExcelWriter insert(String insert) {
        Assert.notEmpty(insert);
        this.clientMapping.getInserts().add(insert);
        return this;
    }

    public ExcelWriter insert(String first, String second, String ... more) {
        Assert.notEmpty(first, second);
        List<String> inserts = this.clientMapping.getInserts();
        inserts.add(first);
        inserts.add(second);
        if (null != more && more.length > 0) {
            inserts.addAll(Arrays.asList(more));
        }
        return this;
    }

    public ExcelWriter addData(List<Map> tableData) {
        return this.addData(tableData, "0");
    }

    public ExcelWriter addData(List<Map> tableData, String switchSheet) {
        this.clientMapping.addTableData(tableData, switchSheet);
        return this;
    }

    public ExcelWriter addData(Map pointData) {
        return this.addData(pointData, "0");
    }

    public ExcelWriter addData(Map pointData, String switchSheet) {
        this.clientMapping.addPointData(pointData, switchSheet);
        return this;
    }

    public ExcelWriter addValidation(ExcelValidation validation) {
        return this.addValidation(validation, "0");
    }

    public ExcelWriter addValidations(Collection<ExcelValidation> validations) {
        return this.addValidations(validations, "0");
    }

    public ExcelWriter addValidation(ExcelValidation validation, String switchSheet) {
        this.clientMapping.addValidation(validation, switchSheet);
        return this;
    }

    public ExcelWriter addValidations(Collection<ExcelValidation> validations, String switchSheet) {
        this.clientMapping.addValidations(validations, switchSheet);
        return this;
    }

    public ExcelWriter filter(WriteFilter filter) {
        return this.filter(filter, "0");
    }

    public ExcelWriter filter(WriteFilter filter, String switchSheet) {
        this.clientMapping.addFilter(filter, switchSheet);
        return this;
    }

    public ExcelWriter filters(WriteFilter[] filters) {
        return this.filters(filters, "0");
    }

    public ExcelWriter filters(WriteFilter[] filters, String switchSheet) {
        return this.filters(Arrays.asList(filters), switchSheet);
    }

    public ExcelWriter filters(Collection<WriteFilter> filters) {
        return this.filters(filters, "0");
    }

    public ExcelWriter filters(Collection<WriteFilter> filters, String switchSheet) {
        for (WriteFilter filter : filters) {
            this.clientMapping.addFilter(filter, switchSheet);
        }
        return this;
    }

    public ExcelResult execute() throws IOException, InvalidFormatException {
        Map<String, Collection<ExcelValidation>> sheetAndValidationMap;
        File template = this.clientMapping.getExcelOutputTemplate();
        Workbook workbook = null;
        if (null != template) {
            workbook = WorkbookFactory.create((File)template);
        }
        if (null == workbook) {
            Object object = workbook = this.clientMapping.getUseXlsFormat() != false ? new HSSFWorkbook() : new XSSFWorkbook();
        }
        if (!(sheetAndValidationMap = this.clientMapping.getSheetAndValidationMap()).isEmpty()) {
            for (Map.Entry<String, Collection<ExcelValidation>> entry : sheetAndValidationMap.entrySet()) {
                String key = entry.getKey();
                Sheet sheet = workbook.getSheet(key);
                if (null == sheet && ExcelHelper.isNumber(key)) {
                    sheet = workbook.getSheetAt(Integer.valueOf(key).intValue());
                }
                Collection<ExcelValidation> validations = entry.getValue();
                for (ExcelValidation validation : validations) {
                    validation.addToSheet(sheet);
                }
            }
        }
        if (this.clientMapping.getInserts().isEmpty() && this.clientMapping.getQueries().isEmpty()) {
            workbook.write(this.clientMapping.getExcelOutput());
            return null;
        }
        ExcelMapping excelMapping = this.clientMapping.parseClientInput();
        ExcelOperations proxy = ExcelOperationsProxyFactory.getProxy();
        proxy.writeExcel(workbook, excelMapping);
        workbook.write(this.clientMapping.getExcelOutput());
        ExcelResult excelResult = new ExcelResult();
        excelResult.setContext(ExcelContext.get());
        return excelResult;
    }
}

