/*
 * Decompiled with CFR 0.152.
 */
package com.geese.plugin.excel.filter;

import com.geese.plugin.excel.filter.Filter;
import com.geese.plugin.excel.filter.FilterChain;
import com.geese.plugin.excel.util.Assert;
import java.util.Collection;

public class Filterable {
    private FilterChain beforeReadFilterChain = new FilterChain();
    private FilterChain afterReadFilterChain = new FilterChain();
    private FilterChain beforeWriteFilterChain = new FilterChain();
    private FilterChain afterWriteFilterChain = new FilterChain();

    public Filterable addBeforeReadFilter(Filter filter) {
        Assert.notNull(filter);
        this.beforeReadFilterChain.addFilter(filter);
        return this;
    }

    public Filterable addBeforeReadFilters(Collection<Filter> filters) {
        Assert.notEmpty(filters);
        this.beforeReadFilterChain.addFilters(filters);
        return this;
    }

    public Filterable addAfterReadFilter(Filter filter) {
        Assert.notNull(filter);
        this.afterReadFilterChain.addFilter(filter);
        return this;
    }

    public Filterable addAfterReadFilters(Collection<Filter> filters) {
        Assert.notEmpty(filters);
        this.afterReadFilterChain.addFilters(filters);
        return this;
    }

    public Filterable addBeforeWriteFilter(Filter filter) {
        Assert.notNull(filter);
        this.beforeWriteFilterChain.addFilter(filter);
        return this;
    }

    public Filterable addBeforeWriteFilters(Collection<Filter> filters) {
        Assert.notEmpty(filters);
        this.beforeWriteFilterChain.addFilters(filters);
        return this;
    }

    public Filterable addAfterWriteFilter(Filter filter) {
        Assert.notNull(filter);
        this.afterWriteFilterChain.addFilter(filter);
        return this;
    }

    public Filterable addAfterWriteFilters(Collection<Filter> filters) {
        Assert.notEmpty(filters);
        this.afterWriteFilterChain.addFilters(filters);
        return this;
    }

    public FilterChain getBeforeReadFilterChain() {
        return this.beforeReadFilterChain;
    }

    public void setBeforeReadFilterChain(FilterChain beforeReadFilterChain) {
        this.beforeReadFilterChain = beforeReadFilterChain;
    }

    public FilterChain getAfterReadFilterChain() {
        return this.afterReadFilterChain;
    }

    public void setAfterReadFilterChain(FilterChain afterReadFilterChain) {
        this.afterReadFilterChain = afterReadFilterChain;
    }

    public FilterChain getBeforeWriteFilterChain() {
        return this.beforeWriteFilterChain;
    }

    public void setBeforeWriteFilterChain(FilterChain beforeWriteFilterChain) {
        this.beforeWriteFilterChain = beforeWriteFilterChain;
    }

    public FilterChain getAfterWriteFilterChain() {
        return this.afterWriteFilterChain;
    }

    public void setAfterWriteFilterChain(FilterChain afterWriteFilterChain) {
        this.afterWriteFilterChain = afterWriteFilterChain;
    }
}

