/*
 * Decompiled with CFR 0.152.
 */
package com.geese.plugin.excel.mapping;

import com.geese.plugin.excel.ExcelHelper;
import com.geese.plugin.excel.ExcelValidation;
import com.geese.plugin.excel.OperationKey;
import com.geese.plugin.excel.filter.Filter;
import com.geese.plugin.excel.mapping.CellMapping;
import com.geese.plugin.excel.mapping.ExcelMapping;
import com.geese.plugin.excel.mapping.SheetMapping;
import com.geese.plugin.excel.util.Assert;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class ClientMapping {
    private InputStream excelInput;
    private List<String> queries = new ArrayList<String>();
    private OutputStream excelOutput;
    private List<String> inserts = new ArrayList<String>();
    private Boolean useXlsFormat = true;
    private File excelOutputTemplate;
    private Map<String, List<Map>> sheetAndTableDataMap = new LinkedHashMap<String, List<Map>>();
    private Map<String, Map> sheetAndPointDataMap = new LinkedHashMap<String, Map>();
    private Map<String, Collection<ExcelValidation>> sheetAndValidationMap = new LinkedHashMap<String, Collection<ExcelValidation>>();
    private Map<String, Collection<Filter>> sheetFiltersMap = new LinkedHashMap<String, Collection<Filter>>();

    public ClientMapping addValidation(ExcelValidation validation, String switchSheet) {
        if (this.sheetAndValidationMap.containsKey(switchSheet)) {
            this.sheetAndValidationMap.get(switchSheet).add(validation);
            return this;
        }
        LinkedHashSet<ExcelValidation> validations = new LinkedHashSet<ExcelValidation>();
        validations.add(validation);
        this.sheetAndValidationMap.put(switchSheet, validations);
        return this;
    }

    public ClientMapping addValidations(Collection<ExcelValidation> validations, String switchSheet) {
        if (this.sheetAndValidationMap.containsKey(switchSheet)) {
            this.sheetAndValidationMap.get(switchSheet).addAll(validations);
            return this;
        }
        this.sheetAndValidationMap.put(switchSheet, validations);
        return this;
    }

    public ClientMapping addFilter(Filter filter, String switchSheet) {
        if (this.sheetFiltersMap.containsKey(switchSheet)) {
            this.sheetFiltersMap.get(switchSheet).add(filter);
            return this;
        }
        LinkedHashSet<Filter> filters = new LinkedHashSet<Filter>();
        filters.add(filter);
        this.sheetFiltersMap.put(switchSheet, filters);
        return this;
    }

    public ClientMapping addFilters(Collection<Filter> filters, String switchSheet) {
        if (this.sheetFiltersMap.containsKey(switchSheet)) {
            this.sheetFiltersMap.get(switchSheet).addAll(filters);
            return this;
        }
        this.sheetFiltersMap.put(switchSheet, filters);
        return this;
    }

    public ClientMapping addTableData(List<Map> tableData, String switchSheet) {
        this.sheetAndTableDataMap.put(switchSheet, tableData);
        return this;
    }

    public ClientMapping addPointData(Map pointData, String switchSheet) {
        this.sheetAndPointDataMap.put(switchSheet, pointData);
        return this;
    }

    public ExcelMapping parseClientInput() {
        ExcelMapping excelMapping = null;
        if (!this.queries.isEmpty()) {
            excelMapping = this.parseQuery();
        } else if (!this.inserts.isEmpty()) {
            excelMapping = this.parseInsert();
        }
        excelMapping.setSheetFiltersMap(this.getSheetFiltersMap());
        excelMapping.classificationFilters();
        return excelMapping;
    }

    private ExcelMapping parseInsert() {
        ExcelMapping excelMapping = new ExcelMapping();
        LinkedHashMap<String, SheetMapping> sheetMappingMap = new LinkedHashMap<String, SheetMapping>();
        for (String insert : this.inserts) {
            SheetMapping sheetMapping;
            String into;
            Map<OperationKey, String> operationKeyMap;
            if ((insert = insert.trim()).matches("^\\{.+\\}$")) {
                String[] points;
                insert = insert.replaceAll("\\{|\\}", "");
                operationKeyMap = ExcelHelper.parseInsert(insert);
                into = operationKeyMap.get((Object)OperationKey.INTO);
                Assert.isTrue(this.sheetAndPointDataMap.containsKey(into));
                sheetMapping = (SheetMapping)sheetMappingMap.get(into);
                if (null == sheetMapping) {
                    sheetMapping = new SheetMapping();
                    sheetMapping.setDataKey(into);
                    sheetMapping.setName(into);
                    if (ExcelHelper.isNumber(into)) {
                        sheetMapping.setIndex(Integer.valueOf(into));
                    }
                    sheetMappingMap.put(into, sheetMapping);
                    sheetMapping.setExcelMapping(excelMapping);
                }
                Map pointData = this.sheetAndPointDataMap.get(into);
                for (String point : points = operationKeyMap.get((Object)OperationKey.COLUMN).split(",")) {
                    String[] items = point.trim().split("-|\\s+");
                    CellMapping p = new CellMapping();
                    p.setRowNumber(Integer.valueOf(items[0]));
                    p.setColumnNumber(Integer.valueOf(items[1]));
                    p.setDataKey(items[2]);
                    p.setData(pointData.get(p.getDataKey()));
                    sheetMapping.getPoints().add(p);
                    p.setSheetMapping(sheetMapping);
                }
                continue;
            }
            operationKeyMap = ExcelHelper.parseInsert(insert);
            into = operationKeyMap.get((Object)OperationKey.INTO);
            Assert.isTrue(this.sheetAndTableDataMap.containsKey(into));
            sheetMapping = new SheetMapping();
            sheetMapping.setExcelMapping(excelMapping);
            String[] columns = operationKeyMap.get((Object)OperationKey.COLUMN).split(",");
            int autoColumnIndex = 0;
            for (String column : columns) {
                CellMapping cellMapping = new CellMapping();
                String[] indexAndName = column.trim().split("\\s+");
                if (indexAndName.length == 1) {
                    cellMapping.setDataKey(indexAndName[0].trim());
                    cellMapping.setColumnNumber(autoColumnIndex++);
                } else {
                    Integer columnIndex = Integer.valueOf(indexAndName[0].trim());
                    cellMapping.setColumnNumber(columnIndex);
                    cellMapping.setDataKey(indexAndName[1].trim());
                    autoColumnIndex = columnIndex + 1;
                }
                sheetMapping.getTableHeads().add(cellMapping);
                cellMapping.setSheetMapping(sheetMapping);
            }
            sheetMapping.setName(into);
            if (ExcelHelper.isNumber(into)) {
                sheetMapping.setIndex(Integer.valueOf(into));
            }
            sheetMapping.setDataKey(into);
            String limit = operationKeyMap.get((Object)OperationKey.LIMIT);
            if (null != limit) {
                String[] items = limit.trim().split(",");
                sheetMapping.setStartRow(Integer.valueOf(items[0].trim()));
                if (items.length == 2) {
                    sheetMapping.setRowInterval(Integer.valueOf(items[1].trim()));
                }
            }
            sheetMapping.setTableData(this.sheetAndTableDataMap.get(into));
            sheetMappingMap.put(into, sheetMapping);
        }
        excelMapping.setSheetMappings(sheetMappingMap.values());
        return excelMapping;
    }

    private ExcelMapping parseQuery() {
        ExcelMapping excelMapping = new ExcelMapping();
        LinkedHashMap<String, SheetMapping> sheetMappingMap = new LinkedHashMap<String, SheetMapping>();
        for (String query : this.queries) {
            Map<OperationKey, String> operationKeyMap;
            if ((query = query.trim()).matches("^\\{.+\\}$")) {
                String[] points;
                operationKeyMap = ExcelHelper.parseQuery(query = query.replaceAll("\\{|\\}", ""));
                String from = operationKeyMap.get((Object)OperationKey.FROM);
                SheetMapping sheetMapping = (SheetMapping)sheetMappingMap.get(from);
                if (null == sheetMapping) {
                    sheetMapping = new SheetMapping();
                    sheetMapping.setDataKey(from);
                    sheetMapping.setName(from);
                    if (ExcelHelper.isNumber(from)) {
                        sheetMapping.setIndex(Integer.valueOf(from));
                    }
                    sheetMappingMap.put(from, sheetMapping);
                    sheetMapping.setExcelMapping(excelMapping);
                }
                for (String point : points = operationKeyMap.get((Object)OperationKey.COLUMN).split(",")) {
                    String[] items = point.trim().split("-|\\s+");
                    CellMapping p = new CellMapping();
                    p.setRowNumber(Integer.valueOf(items[0]));
                    p.setColumnNumber(Integer.valueOf(items[1]));
                    p.setDataKey(items[2]);
                    sheetMapping.getPoints().add(p);
                    p.setSheetMapping(sheetMapping);
                }
                continue;
            }
            operationKeyMap = ExcelHelper.parseQuery(query);
            SheetMapping sheetMapping = new SheetMapping();
            sheetMapping.setExcelMapping(excelMapping);
            String[] columns = operationKeyMap.get((Object)OperationKey.COLUMN).split(",");
            int autoColumnIndex = 0;
            for (String column : columns) {
                CellMapping cellMapping = new CellMapping();
                String[] indexAndName = column.trim().split("\\s+");
                if (indexAndName.length == 1) {
                    cellMapping.setDataKey(indexAndName[0].trim());
                    cellMapping.setColumnNumber(autoColumnIndex++);
                } else {
                    Integer columnIndex = Integer.valueOf(indexAndName[0].trim());
                    cellMapping.setColumnNumber(columnIndex);
                    cellMapping.setDataKey(indexAndName[1].trim());
                    autoColumnIndex = columnIndex + 1;
                }
                sheetMapping.getTableHeads().add(cellMapping);
                cellMapping.setSheetMapping(sheetMapping);
            }
            String from = operationKeyMap.get((Object)OperationKey.FROM);
            sheetMapping.setName(from);
            if (ExcelHelper.isNumber(from)) {
                sheetMapping.setIndex(Integer.valueOf(from));
            }
            sheetMapping.setDataKey(from);
            String limit = operationKeyMap.get((Object)OperationKey.LIMIT);
            if (null != limit) {
                String[] startAndSize = limit.trim().split(",");
                sheetMapping.setStartRow(Integer.valueOf(startAndSize[0].trim()));
                if (startAndSize.length == 2) {
                    Integer size = Integer.valueOf(startAndSize[1].trim());
                    sheetMapping.setEndRow(sheetMapping.getStartRow() + size);
                }
            }
            sheetMappingMap.put(from, sheetMapping);
        }
        excelMapping.setSheetMappings(sheetMappingMap.values());
        return excelMapping;
    }

    public InputStream getExcelInput() {
        return this.excelInput;
    }

    public void setExcelInput(InputStream excelInput) {
        this.excelInput = excelInput;
    }

    public List<String> getQueries() {
        return this.queries;
    }

    public void setQueries(List<String> queries) {
        this.queries = queries;
    }

    public List<String> getInserts() {
        return this.inserts;
    }

    public void setInserts(List<String> inserts) {
        this.inserts = inserts;
    }

    public OutputStream getExcelOutput() {
        return this.excelOutput;
    }

    public void setExcelOutput(OutputStream excelOutput) {
        this.excelOutput = excelOutput;
    }

    public Boolean getUseXlsFormat() {
        return this.useXlsFormat;
    }

    public void setUseXlsFormat(Boolean useXlsFormat) {
        this.useXlsFormat = useXlsFormat;
    }

    public File getExcelOutputTemplate() {
        return this.excelOutputTemplate;
    }

    public void setExcelOutputTemplate(File excelOutputTemplate) {
        this.excelOutputTemplate = excelOutputTemplate;
    }

    public Map<String, Collection<Filter>> getSheetFiltersMap() {
        return this.sheetFiltersMap;
    }

    public void setSheetFiltersMap(Map<String, Collection<Filter>> sheetFiltersMap) {
        this.sheetFiltersMap = sheetFiltersMap;
    }

    public Map<String, Collection<ExcelValidation>> getSheetAndValidationMap() {
        return this.sheetAndValidationMap;
    }

    public void setSheetAndValidationMap(Map<String, Collection<ExcelValidation>> sheetAndValidationMap) {
        this.sheetAndValidationMap = sheetAndValidationMap;
    }
}

