/*
 * Decompiled with CFR 0.152.
 */
package com.geese.plugin.excel.mapping;

import com.geese.plugin.excel.filter.Filter;
import com.geese.plugin.excel.filter.FilterChain;
import com.geese.plugin.excel.filter.read.RowAfterReadFilter;
import com.geese.plugin.excel.filter.read.RowBeforeReadFilter;
import com.geese.plugin.excel.filter.read.SheetAfterReadFilter;
import com.geese.plugin.excel.filter.read.SheetBeforeReadFilter;
import com.geese.plugin.excel.filter.write.RowAfterWriteFilter;
import com.geese.plugin.excel.filter.write.RowBeforeWriteFilter;
import com.geese.plugin.excel.filter.write.SheetAfterWriteFilter;
import com.geese.plugin.excel.filter.write.SheetBeforeWriteFilter;
import com.geese.plugin.excel.mapping.SheetMapping;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExcelMapping {
    private Collection<SheetMapping> sheetMappings;
    private Map<String, Collection<Filter>> sheetFiltersMap = new LinkedHashMap<String, Collection<Filter>>();
    private Map<String, FilterChain> sheetBeforeReadFilterChainMap = new HashMap<String, FilterChain>();
    private Map<String, FilterChain> sheetBeforeWriteFilterChainMap = new HashMap<String, FilterChain>();
    private Map<String, FilterChain> sheetAfterReadFilterChainMap = new HashMap<String, FilterChain>();
    private Map<String, FilterChain> sheetAfterWriteFilterChainMap = new HashMap<String, FilterChain>();
    private Map<String, FilterChain> rowBeforeReadFilterChainMap = new HashMap<String, FilterChain>();
    private Map<String, FilterChain> rowBeforeWriteFilterChainMap = new HashMap<String, FilterChain>();
    private Map<String, FilterChain> rowAfterReadFilterChainMap = new HashMap<String, FilterChain>();
    private Map<String, FilterChain> rowAfterWriteFilterChainMap = new HashMap<String, FilterChain>();

    public Collection<SheetMapping> getSheetMappings() {
        return this.sheetMappings;
    }

    public void setSheetMappings(Collection<SheetMapping> sheetMappings) {
        this.sheetMappings = sheetMappings;
    }

    public Map<String, Collection<Filter>> getSheetFiltersMap() {
        return this.sheetFiltersMap;
    }

    public void setSheetFiltersMap(Map<String, Collection<Filter>> sheetFiltersMap) {
        this.sheetFiltersMap = sheetFiltersMap;
    }

    public FilterChain getSheetBeforeReadFilterChain(String sheet) {
        return this.sheetBeforeReadFilterChainMap.get(sheet);
    }

    public FilterChain getSheetBeforeWriteFilterChain(String sheet) {
        return this.sheetBeforeWriteFilterChainMap.get(sheet);
    }

    public FilterChain getSheetAfterReadFilterChain(String sheet) {
        return this.sheetAfterReadFilterChainMap.get(sheet);
    }

    public FilterChain getSheetAfterWriteFilterChain(String sheet) {
        return this.sheetAfterWriteFilterChainMap.get(sheet);
    }

    public FilterChain getRowBeforeReadFilterChain(String sheet) {
        return this.rowBeforeReadFilterChainMap.get(sheet);
    }

    public FilterChain getRowBeforeWriteFilterChain(String sheet) {
        return this.rowBeforeWriteFilterChainMap.get(sheet);
    }

    public FilterChain getRowAfterReadFilterChain(String sheet) {
        return this.rowAfterReadFilterChainMap.get(sheet);
    }

    public FilterChain getRowAfterWriteFilterChain(String sheet) {
        return this.rowAfterWriteFilterChainMap.get(sheet);
    }

    public void classificationFilters() {
        for (Map.Entry<String, Collection<Filter>> entry : this.sheetFiltersMap.entrySet()) {
            String sheet = entry.getKey();
            Collection<Filter> filters = entry.getValue();
            for (Filter filter : filters) {
                if (filter instanceof SheetBeforeReadFilter) {
                    this.addFilterToFilterChain(filter, this.sheetBeforeReadFilterChainMap, sheet);
                    continue;
                }
                if (filter instanceof SheetBeforeWriteFilter) {
                    this.addFilterToFilterChain(filter, this.sheetBeforeWriteFilterChainMap, sheet);
                    continue;
                }
                if (filter instanceof SheetAfterReadFilter) {
                    this.addFilterToFilterChain(filter, this.sheetAfterReadFilterChainMap, sheet);
                    continue;
                }
                if (filter instanceof SheetAfterWriteFilter) {
                    this.addFilterToFilterChain(filter, this.sheetAfterWriteFilterChainMap, sheet);
                    continue;
                }
                if (filter instanceof RowBeforeReadFilter) {
                    this.addFilterToFilterChain(filter, this.rowBeforeReadFilterChainMap, sheet);
                    continue;
                }
                if (filter instanceof RowBeforeWriteFilter) {
                    this.addFilterToFilterChain(filter, this.rowBeforeWriteFilterChainMap, sheet);
                    continue;
                }
                if (filter instanceof RowAfterReadFilter) {
                    this.addFilterToFilterChain(filter, this.rowAfterReadFilterChainMap, sheet);
                    continue;
                }
                if (!(filter instanceof RowAfterWriteFilter)) continue;
                this.addFilterToFilterChain(filter, this.rowAfterWriteFilterChainMap, sheet);
            }
        }
    }

    private void addFilterToFilterChain(Filter filter, Map<String, FilterChain> filterChainMap, String key) {
        if (filterChainMap.containsKey(key)) {
            filterChainMap.get(key).addFilter(filter);
            return;
        }
        FilterChain filterChain = new FilterChain();
        filterChain.addFilter(filter);
        filterChainMap.put(key, filterChain);
    }
}

