/*
 * Decompiled with CFR 0.152.
 */
package com.geese.plugin.excel.util;

import com.geese.plugin.excel.util.EmptyUtils;
import java.util.Arrays;
import java.util.List;

public final class Assert {
    private Assert() {
    }

    public static void isTrue(boolean state) {
        if (!state) {
            throw new IllegalArgumentException();
        }
    }

    public static void isTrue(boolean state, String errorMessage) {
        if (!state) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void isTrue(boolean state, String errorMessageTemplate, String ... errorMessageArgs) {
        if (!state) {
            throw new IllegalArgumentException(Assert.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> T notNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T notNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static <T> T notNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new NullPointerException(Assert.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    public static void notNull(Object first, Object second, Object ... more) {
        List<Object> args = Arrays.asList(first, second, more);
        for (Object arg : args) {
            if (null != arg) continue;
            throw new NullPointerException();
        }
    }

    public static <T> T notEmpty(T reference) {
        if (EmptyUtils.isEmpty(reference)) {
            throw new IllegalArgumentException();
        }
        return reference;
    }

    public static <T> T notEmpty(T reference, Object errorMessage) {
        if (EmptyUtils.isEmpty(reference)) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static <T> T notEmpty(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (EmptyUtils.isEmpty(reference)) {
            throw new IllegalArgumentException(Assert.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    public static void notEmpty(Object first, Object second, Object ... more) {
        List<Object> args = Arrays.asList(first, second, more);
        for (Object arg : args) {
            if (!EmptyUtils.isEmpty(arg)) continue;
            throw new IllegalArgumentException();
        }
    }

    static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

