/*
 * Decompiled with CFR 0.152.
 */
package com.geese.plugin.excel.util;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanPropertyUtils {
    private static SimpleDateFormat sdf = new SimpleDateFormat();

    public static void nullToEmpty(Object bean) {
        List<Field> fields = BeanPropertyUtils.getDeclaredFields(bean.getClass(), true);
        for (Field field : fields) {
            try {
                Object val;
                field.setAccessible(true);
                Class<?> fieldType = field.getType();
                if (String.class != fieldType || null != (val = field.get(bean))) continue;
                field.set(bean, "");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object mapToBean(Map map, Object bean) {
        List<Field> fields = BeanPropertyUtils.getDeclaredFields(bean.getClass(), true);
        HashMap<String, Field> fieldNameMap = new HashMap<String, Field>();
        for (Field field : fields) {
            fieldNameMap.put(field.getName(), field);
        }
        Set keys = map.keySet();
        for (Object key : keys) {
            if (!fieldNameMap.containsKey(key)) continue;
            Field field = (Field)fieldNameMap.get(key);
            field.setAccessible(true);
            try {
                BeanPropertyUtils.setFieldValue(bean, field, map.get(key));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
            finally {
                field.setAccessible(false);
            }
        }
        return bean;
    }

    private static Object setFieldValue(Object target, Field field, Object value) throws NoSuchFieldException, IllegalAccessException {
        BeanPropertyUtils.notNull(target);
        BeanPropertyUtils.notNull(field);
        if (value == null) {
            return target;
        }
        field.setAccessible(true);
        Class<?> fieldType = field.getType();
        if (String.class != value.getClass()) {
            field.set(target, value);
            return target;
        }
        String valueString = value.toString().trim();
        if (String.class == fieldType) {
            field.set(target, valueString);
            return target;
        }
        if (Integer.TYPE == fieldType || Integer.class == fieldType) {
            field.set(target, Integer.valueOf(valueString));
            return target;
        }
        if (Long.TYPE == fieldType || Long.class == fieldType) {
            field.set(target, Long.valueOf(valueString));
            return target;
        }
        if (Double.TYPE == fieldType || Double.class == fieldType) {
            field.set(target, Double.valueOf(valueString));
            return target;
        }
        if (Float.TYPE == fieldType || Float.class == fieldType) {
            field.set(target, Float.valueOf(valueString));
            return target;
        }
        if (Short.TYPE == fieldType || Short.class == fieldType) {
            field.set(target, Short.valueOf(valueString));
            return target;
        }
        if (Byte.TYPE == fieldType || Byte.class == fieldType) {
            field.set(target, Short.valueOf(valueString));
            return target;
        }
        if (Boolean.class == fieldType || Boolean.TYPE == fieldType) {
            field.set(target, Boolean.valueOf(valueString));
            return target;
        }
        if (BigDecimal.class == fieldType) {
            BigDecimal.valueOf(Double.valueOf(valueString));
            return target;
        }
        if (BigInteger.class == fieldType) {
            BigInteger.valueOf(Long.valueOf(valueString));
            return target;
        }
        if (Date.class == fieldType) {
            String dateString = valueString.replaceAll("[^\\d]+", "");
            switch (dateString.length()) {
                case 4: {
                    sdf.applyPattern("yyyy");
                    break;
                }
                case 6: {
                    sdf.applyPattern("yyyyMM");
                    break;
                }
                case 8: {
                    sdf.applyPattern("yyyyMMdd");
                    break;
                }
                case 10: {
                    sdf.applyPattern("yyyyMMddHH");
                    break;
                }
                case 12: {
                    sdf.applyPattern("yyyyMMddHHmm");
                    break;
                }
                case 14: {
                    sdf.applyPattern("yyyyMMddHHmmss");
                    break;
                }
                case 17: {
                    sdf.applyPattern("yyyyMMddHHmmssSSS");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u683c\u5f0f\uff1a" + valueString);
                }
            }
            try {
                field.set(target, sdf.parse(dateString));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return target;
        }
        if (fieldType.isEnum()) {
            field.set(target, Enum.valueOf(fieldType, valueString));
            return target;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u7c7b\u578b\u5904\u7406\uff1a" + fieldType);
    }

    public static Map beanToMap(Object bean) {
        return BeanPropertyUtils.beanToMap(bean, (List<String>)null);
    }

    public static Map beanToMap(Object bean, List<String> includes) {
        return (Map)BeanPropertyUtils.copy(bean, new HashMap(), includes, null);
    }

    public static Map beanToMap(Object bean, String ... excludes) {
        return (Map)BeanPropertyUtils.copy(bean, new HashMap(), null, Arrays.asList(excludes));
    }

    public static List<Map> beanToMap(List beans) {
        return BeanPropertyUtils.beanToMap(beans, (List<String>)null);
    }

    public static List<Map> beanToMap(List beans, List<String> includes) {
        ArrayList<Map> toList = new ArrayList<Map>();
        for (Object o : beans) {
            toList.add(BeanPropertyUtils.beanToMap(o, includes));
        }
        return toList;
    }

    public static List<Map> beanToMap(List beans, String ... excludes) {
        ArrayList<Map> toList = new ArrayList<Map>();
        for (Object o : beans) {
            toList.add(BeanPropertyUtils.beanToMap(o, excludes));
        }
        return toList;
    }

    public static Object copy(Object from, Object to) {
        return BeanPropertyUtils.copy(from, to, null, null);
    }

    public static Object copy(Object from, Object to, List<String> includes) {
        return BeanPropertyUtils.copy(from, to, includes, null);
    }

    public static Object copy(Object from, Object to, String ... excludes) {
        return BeanPropertyUtils.copy(from, to, null, Arrays.asList(excludes));
    }

    public static <T> T copy(Object from, Class<T> to) {
        return BeanPropertyUtils.copy(from, to, (List<String>)null);
    }

    public static <T> T copy(Object from, Class<T> to, String ... excludes) {
        T t = null;
        try {
            t = to.newInstance();
            BeanPropertyUtils.copy(from, t, null, Arrays.asList(excludes));
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return t;
    }

    public static <T> T copy(Object from, Class<T> to, List<String> includes) {
        T t = null;
        try {
            t = to.newInstance();
            BeanPropertyUtils.copy(from, t, includes, null);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return t;
    }

    public static <T> List<T> copy(List<?> from, Class<T> to) {
        return BeanPropertyUtils.copy(from, to, (List<String>)null);
    }

    public static <T> List<T> copy(List from, Class<T> to, String ... excludes) {
        ArrayList<T> toList = new ArrayList<T>();
        for (Object o : from) {
            toList.add(BeanPropertyUtils.copy(o, to, excludes));
        }
        return toList;
    }

    public static <T> List<T> copy(List<?> from, Class<T> to, List<String> includes) {
        ArrayList<T> toList = new ArrayList<T>();
        for (Object o : from) {
            toList.add(BeanPropertyUtils.copy(o, to, includes));
        }
        return toList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object copy(Object from, Object to, List<String> includes, List<String> excludes) {
        BeanPropertyUtils.notNull(from);
        BeanPropertyUtils.notNull(to);
        boolean hasIncludes = null != includes && !includes.isEmpty();
        boolean hasExcludes = false;
        if (!hasIncludes) {
            hasExcludes = null != excludes && !excludes.isEmpty();
        }
        Class<?> fromClass = from.getClass();
        List<Field> fromFields = BeanPropertyUtils.getDeclaredFields(fromClass, true);
        Class<?> toClass = to.getClass();
        boolean isMap = Map.class.isAssignableFrom(toClass);
        ArrayList<String> toFieldNames = null;
        if (!isMap) {
            toFieldNames = new ArrayList<String>();
            List<Field> toFields = BeanPropertyUtils.getDeclaredFields(toClass, true);
            for (Field toField : toFields) {
                toFieldNames.add(toField.getName());
            }
        }
        for (Field fromField : fromFields) {
            String fromFieldName = fromField.getName();
            try {
                fromField.setAccessible(true);
                if (isMap) {
                    ((Map)to).put(fromFieldName, fromField.get(from));
                    continue;
                }
                if (!toFieldNames.contains(fromFieldName) || hasIncludes && !includes.contains(fromFieldName) || hasExcludes && excludes.contains(fromFieldName)) continue;
                fromField.set(to, fromField.get(from));
            }
            catch (IllegalAccessException e) {
                System.err.println("\u5c5e\u6027\u8bbf\u95ee\u5f02\u5e38\uff1a" + e.getMessage());
            }
            finally {
                fromField.setAccessible(false);
            }
        }
        return to;
    }

    private static List<Field> getDeclaredFields(Class aClass, boolean deep) {
        ArrayList<Field> fieldsStore = new ArrayList<Field>();
        BeanPropertyUtils.getFields(fieldsStore, aClass, true, deep);
        return fieldsStore;
    }

    private static void getFields(List<Field> findedFields, Class aClass, boolean declared, boolean deep) {
        if (Object.class != aClass) {
            Field[] fields = declared ? aClass.getDeclaredFields() : aClass.getFields();
            findedFields.addAll(Arrays.asList(fields));
            if (deep) {
                BeanPropertyUtils.getFields(findedFields, aClass.getSuperclass(), declared, deep);
            }
        }
    }

    private static void notNull(Object object) {
        BeanPropertyUtils.notNull(object, "[Assertion failed] - this argument is required; it must not be null");
    }

    private static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void main(String[] args) {
        String s = "sd23f3f2d423".replaceAll("[^\\d]+", "");
        System.out.println(s);
    }
}

