/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.junit.extension.classpath;

import com.github.fridujo.junit.extension.classpath.ClasspathContext;
import com.github.fridujo.junit.extension.classpath.Gav;
import com.github.fridujo.junit.extension.classpath.NoMatchingClasspathElementFoundException;
import com.github.fridujo.junit.extension.classpath.PathElement;
import com.github.fridujo.junit.extension.classpath.Streams;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class Classpath {
    public final Set<PathElement> pathElements;
    private final ClasspathContext context;

    private Classpath(Set<PathElement> pathElements, ClasspathContext context) {
        this.pathElements = Collections.unmodifiableSet(new TreeSet<PathElement>(pathElements));
        this.context = context;
    }

    public static Classpath current() {
        return Classpath.current(new ClasspathContext());
    }

    static Classpath current(ClasspathContext context) {
        String rawClasspath = System.getProperty("java.class.path");
        Set<PathElement> pathElements = Arrays.stream(rawClasspath.split(File.pathSeparator)).map(PathElement::create).collect(Collectors.toSet());
        return new Classpath(pathElements, context);
    }

    public ClassLoader newClassLoader() {
        ClassLoader parent = this.getClass().getClassLoader().getParent();
        URLClassLoader urlClassLoader = new URLClassLoader(this.pathElements.stream().map(PathElement::toUrl).collect(Collectors.toList()).toArray(new URL[0]), parent);
        return urlClassLoader;
    }

    public Classpath removeJars(String[] excludeJars) {
        TreeSet<PathElement> newPaths = new TreeSet<PathElement>(this.pathElements);
        Arrays.stream(excludeJars).map(Gav::parse).forEach(gav -> newPaths.removeIf(p -> p.matches((Gav)gav)));
        return new Classpath(newPaths, this.context);
    }

    public Classpath removeGavs(String[] gavDescriptions) throws NoMatchingClasspathElementFoundException {
        return Streams.reduce(Arrays.stream(gavDescriptions), this, Classpath::removeGav);
    }

    public Classpath removeGav(String gavDescription) throws NoMatchingClasspathElementFoundException {
        Gav gav = Gav.parse(gavDescription);
        if (this.pathElements.stream().filter(pe -> pe.matches(gav)).count() == 0L) {
            throw new NoMatchingClasspathElementFoundException(gav);
        }
        Classpath classpath = this;
        for (PathElement matchingPath : this.pathElements.stream().filter(pe -> pe.matches(gav)).collect(Collectors.toSet())) {
            classpath = classpath.removeGavWithMatchingPath(gav, matchingPath);
        }
        return classpath;
    }

    private Classpath removeGavWithMatchingPath(Gav gav, PathElement matchingPath) {
        TreeSet<PathElement> newPaths = new TreeSet<PathElement>(this.pathElements);
        newPaths.removeIf(pe -> pe.matches(gav));
        Set<Gav> gavsToRemove = this.context.listDependencies(matchingPath);
        if (!gavsToRemove.isEmpty()) {
            HashSet<Gav> gavsToKeep = new HashSet<Gav>();
            for (PathElement pe2 : this.pathElements) {
                if (pe2.matches(gav) || gavsToRemove.stream().anyMatch(g -> pe2.matches((Gav)g))) continue;
                gavsToKeep.addAll(this.context.listDependencies(pe2));
            }
            gavsToRemove.removeAll(gavsToKeep);
            newPaths.removeIf(pe -> pe.matches(gavsToRemove));
        }
        return new Classpath(newPaths, this.context);
    }
}

