/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.junit.extension.classpath;

import com.github.fridujo.junit.extension.classpath.Classpath;
import com.github.fridujo.junit.extension.classpath.ClasspathContext;
import com.github.fridujo.junit.extension.classpath.ModifiedClasspath;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.platform.commons.util.ReflectionUtils;

public class ModifiedClasspathExtension
implements InvocationInterceptor {
    private final ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{ModifiedClasspathExtension.class});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) {
        this.silentlyInvokeOriginalMethod(invocation);
        ExtensionContext.Store store = extensionContext.getStore(this.namespace);
        ClasspathContext context = (ClasspathContext)store.getOrComputeIfAbsent(ClasspathContext.class);
        ModifiedClasspath annotation = ((Method)invocationContext.getExecutable()).getAnnotation(ModifiedClasspath.class);
        ClassLoader modifiedClassLoader = Classpath.current(context).removeJars(annotation.excludeJars()).removeGavs(annotation.excludeGavs()).newClassLoader();
        ClassLoader currentThreadPreviousClassLoader = this.replaceCurrentThreadClassLoader(modifiedClassLoader);
        try {
            this.invokeMethodWithModifiedClasspath(((Method)invocationContext.getExecutable()).getDeclaringClass().getName(), ((Method)invocationContext.getExecutable()).getName(), modifiedClassLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadPreviousClassLoader);
        }
    }

    private ClassLoader replaceCurrentThreadClassLoader(ClassLoader modifiedClassLoader) {
        ClassLoader currentThreadPreviousClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(modifiedClassLoader);
        return currentThreadPreviousClassLoader;
    }

    private void invokeMethodWithModifiedClasspath(String className, String methodName, ClassLoader classLoader) {
        Class<?> testClass;
        try {
            testClass = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot load test class [" + className + "] from modified classloader, verify that you did not exclude a path containing the test", e);
        }
        Object testInstance = ReflectionUtils.newInstance(testClass, (Object[])new Object[0]);
        Optional method = ReflectionUtils.findMethod(testClass, (String)methodName, (Class[])new Class[0]);
        ReflectionUtils.invokeMethod((Method)((Method)method.orElseThrow(() -> new IllegalStateException("No test method named " + methodName))), (Object)testInstance, (Object[])new Object[0]);
    }

    private void silentlyInvokeOriginalMethod(InvocationInterceptor.Invocation<Void> invocation) {
        try {
            invocation.proceed();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

