/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.junit.extension.classpath;

import com.github.fridujo.junit.extension.classpath.Gav;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Objects;

public class PathElement
implements Comparable<PathElement> {
    private final String rawPath;

    private PathElement(String rawPath) {
        this.rawPath = rawPath;
    }

    public static PathElement create(String rawPath) {
        String normalizedRawPath = rawPath;
        boolean directory = Files.isDirectory(Paths.get(rawPath, new String[0]), new LinkOption[0]);
        boolean alreadyHasTerminalSlash = rawPath.trim().endsWith(File.separator);
        if (directory && !alreadyHasTerminalSlash) {
            normalizedRawPath = normalizedRawPath.trim() + File.separator;
        }
        return new PathElement(normalizedRawPath);
    }

    public Path toPath() {
        return Paths.get(this.rawPath, new String[0]);
    }

    public URL toUrl() {
        try {
            return new URL("file:" + (!this.rawPath.startsWith("/") ? "/" : "") + this.rawPath);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean matches(Gav gav) {
        return gav.matchesJar(this.rawPath);
    }

    public boolean matches(Collection<Gav> gavs) {
        return gavs.stream().anyMatch(gav -> gav.matchesJar(this.rawPath));
    }

    public String toString() {
        return this.rawPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathElement that = (PathElement)o;
        return this.rawPath.equals(that.rawPath);
    }

    public int hashCode() {
        return Objects.hash(this.rawPath);
    }

    @Override
    public int compareTo(PathElement o) {
        return this.rawPath.compareTo(o.rawPath);
    }
}

