/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.junit.extension.classpath.maven;

import com.github.fridujo.junit.extension.classpath.PathElement;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectModelResolver;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.internal.impl.DefaultArtifactResolver;
import org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import org.eclipse.aether.internal.impl.DefaultRepositoryConnectorProvider;
import org.eclipse.aether.internal.impl.DefaultRepositoryEventDispatcher;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.eclipse.aether.internal.impl.DefaultSyncContextFactory;
import org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManagerFactory;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;

abstract class MavenOperations {
    private static final String ESC_SEP = Pattern.quote(File.separator);
    private static final Pattern MAVEN_ARTIFACT_PATH_PATTERN = Pattern.compile("(?:.*)" + ESC_SEP + "(?<artifactId>.*)" + ESC_SEP + "(?<version>.*)" + ESC_SEP + "\\k<artifactId>-\\k<version>" + Pattern.quote(".jar"));
    private final DefaultRepositorySystemSession session = new DefaultRepositorySystemSession();
    private final ProjectModelResolver modelResolver = new ProjectModelResolver((RepositorySystemSession)this.session, null, (RepositorySystem)new DefaultRepositorySystem().setVersionRangeResolver((VersionRangeResolver)new DefaultVersionRangeResolver()).setArtifactResolver((ArtifactResolver)new DefaultArtifactResolver().setSyncContextFactory((SyncContextFactory)new DefaultSyncContextFactory()).setRepositoryEventDispatcher((RepositoryEventDispatcher)new DefaultRepositoryEventDispatcher()).setVersionResolver((VersionResolver)new DefaultVersionResolver()).setRemoteRepositoryManager((RemoteRepositoryManager)new DefaultRemoteRepositoryManager()).setRepositoryConnectorProvider((RepositoryConnectorProvider)new DefaultRepositoryConnectorProvider())), (RemoteRepositoryManager)new DefaultRemoteRepositoryManager(), Collections.emptyList(), ProjectBuildingRequest.RepositoryMerging.POM_DOMINANT, null);

    protected MavenOperations(String localRepo) {
        try {
            this.session.setLocalRepositoryManager(new EnhancedLocalRepositoryManagerFactory().newInstance((RepositorySystemSession)this.session, new LocalRepository(localRepo)));
        }
        catch (NoLocalRepositoryManagerException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static String getVersion(Model model) {
        String version = model.getVersion();
        if (version != null) {
            return version;
        }
        if (model.getParent() == null) {
            throw new IllegalStateException("[" + model.getArtifactId() + "] No parent POM -> undefined version");
        }
        return model.getParent().getVersion();
    }

    protected static String getGroupId(Model model) {
        String groupId = model.getGroupId();
        if (groupId != null) {
            return groupId;
        }
        if (model.getParent() == null) {
            throw new IllegalStateException("[" + model.getArtifactId() + "] No parent POM -> undefined groupId");
        }
        return model.getParent().getGroupId();
    }

    protected static Optional<Model> getNonEffectiveModel(PathElement jarPath) {
        Optional<Path> pomPath = MavenOperations.getPomPath(jarPath);
        return pomPath.map(pp -> {
            Model model;
            block8: {
                MavenXpp3Reader reader = new MavenXpp3Reader();
                InputStream is = Files.newInputStream(pp, new OpenOption[0]);
                try {
                    model = reader.read(is);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | XmlPullParserException e) {
                        return null;
                    }
                }
                is.close();
            }
            return model;
        });
    }

    private static Optional<Path> getPomPath(PathElement jarPath) {
        String rawPath = jarPath.toPath().toString();
        if (!rawPath.endsWith(".jar")) {
            return Optional.empty();
        }
        Path pomPath = Paths.get(rawPath.substring(0, rawPath.length() - 4) + ".pom", new String[0]);
        if (!Files.exists(pomPath, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(pomPath);
    }

    protected Optional<Model> loadMavenProject(PathElement jarPath) {
        Matcher matcher = MAVEN_ARTIFACT_PATH_PATTERN.matcher(jarPath.toPath().toString());
        if (!matcher.matches()) {
            return Optional.empty();
        }
        Optional<Path> pomPath = MavenOperations.getPomPath(jarPath);
        if (!pomPath.isPresent()) {
            return Optional.empty();
        }
        try {
            DefaultModelBuildingRequest request = new DefaultModelBuildingRequest().setPomFile(pomPath.get().toFile()).setModelResolver((ModelResolver)this.modelResolver);
            DefaultModelBuilder defaultModelBuilder = new DefaultModelBuilderFactory().newInstance();
            ModelBuildingResult result = defaultModelBuilder.build((ModelBuildingRequest)request);
            return Optional.of(result.getEffectiveModel());
        }
        catch (ModelBuildingException e) {
            return Optional.empty();
        }
    }
}

