/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock;

import com.github.fridujo.rabbitmq.mock.MockExchange;
import com.github.fridujo.rabbitmq.mock.MockQueue;
import com.rabbitmq.client.AMQP;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BindableMockExchange
implements MockExchange {
    private final Map<String, MockQueue> queuesByBindingKeys = new ConcurrentHashMap<String, MockQueue>();
    private final String name;

    protected BindableMockExchange(String name) {
        this.name = name;
    }

    @Override
    public void publish(String routingKey, AMQP.BasicProperties props, byte[] body) {
        this.queuesByBindingKeys.entrySet().stream().filter(e -> this.match((String)e.getKey(), routingKey)).forEach(e -> ((MockQueue)e.getValue()).publish(this.name, routingKey, props, body));
    }

    protected abstract boolean match(String var1, String var2);

    @Override
    public void bind(MockQueue mockQueue, String routingKey) {
        this.queuesByBindingKeys.put(routingKey, mockQueue);
    }
}

