/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock;

import com.github.fridujo.rabbitmq.mock.MockNode;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.CancelCallback;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.ConfirmCallback;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ConsumerShutdownSignalCallback;
import com.rabbitmq.client.DeliverCallback;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.ReturnCallback;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockChannel
implements Channel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockChannel.class);
    private final MockNode node;
    private final AtomicBoolean opened = new AtomicBoolean(true);

    public MockChannel(MockNode node) {
        this.node = node;
    }

    public int getChannelNumber() {
        throw new UnsupportedOperationException();
    }

    public Connection getConnection() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.opened.set(false);
    }

    public void close(int closeCode, String closeMessage) {
        this.opened.set(false);
    }

    public void abort() {
        throw new UnsupportedOperationException();
    }

    public void abort(int closeCode, String closeMessage) {
        throw new UnsupportedOperationException();
    }

    public void addReturnListener(ReturnListener listener) {
        throw new UnsupportedOperationException();
    }

    public ReturnListener addReturnListener(ReturnCallback returnCallback) {
        throw new UnsupportedOperationException();
    }

    public boolean removeReturnListener(ReturnListener listener) {
        throw new UnsupportedOperationException();
    }

    public void clearReturnListeners() {
        throw new UnsupportedOperationException();
    }

    public void addConfirmListener(ConfirmListener listener) {
        throw new UnsupportedOperationException();
    }

    public ConfirmListener addConfirmListener(ConfirmCallback ackCallback, ConfirmCallback nackCallback) {
        throw new UnsupportedOperationException();
    }

    public boolean removeConfirmListener(ConfirmListener listener) {
        throw new UnsupportedOperationException();
    }

    public void clearConfirmListeners() {
        throw new UnsupportedOperationException();
    }

    public Consumer getDefaultConsumer() {
        throw new UnsupportedOperationException();
    }

    public void setDefaultConsumer(Consumer consumer) {
        throw new UnsupportedOperationException();
    }

    public void basicQos(int prefetchSize, int prefetchCount, boolean global) {
        throw new UnsupportedOperationException();
    }

    public void basicQos(int prefetchCount, boolean global) {
        throw new UnsupportedOperationException();
    }

    public void basicQos(int prefetchCount) {
    }

    public void basicPublish(String exchange, String routingKey, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.basicPublish(exchange, routingKey, false, props, body);
    }

    public void basicPublish(String exchange, String routingKey, boolean mandatory, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.basicPublish(exchange, routingKey, false, false, props, body);
    }

    public void basicPublish(String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) {
        this.node.basicPublish(exchange, routingKey, mandatory, immediate, props, body);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type) throws IOException {
        return this.exchangeDeclare(exchange, type, false, true, false, Collections.emptyMap());
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type) throws IOException {
        return this.exchangeDeclare(exchange, type, false, true, false, Collections.emptyMap());
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable) throws IOException {
        return this.exchangeDeclare(exchange, type, durable, true, false, Collections.emptyMap());
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable) throws IOException {
        return this.exchangeDeclare(exchange, type, durable, true, false, Collections.emptyMap());
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return this.exchangeDeclare(exchange, type, durable, autoDelete, false, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return this.exchangeDeclare(exchange, type, durable, autoDelete, false, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) {
        return this.node.exchangeDeclare(exchange, type, durable, autoDelete, internal, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        return this.exchangeDeclare(exchange, type.getType(), durable, autoDelete, internal, arguments);
    }

    public void exchangeDeclareNoWait(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) {
        throw new UnsupportedOperationException();
    }

    public void exchangeDeclareNoWait(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) {
        throw new UnsupportedOperationException();
    }

    public AMQP.Exchange.DeclareOk exchangeDeclarePassive(String name) {
        throw new UnsupportedOperationException();
    }

    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange, boolean ifUnused) {
        throw new UnsupportedOperationException();
    }

    public void exchangeDeleteNoWait(String exchange, boolean ifUnused) {
        throw new UnsupportedOperationException();
    }

    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange) {
        throw new UnsupportedOperationException();
    }

    public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey) {
        throw new UnsupportedOperationException();
    }

    public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        throw new UnsupportedOperationException();
    }

    public void exchangeBindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) {
        throw new UnsupportedOperationException();
    }

    public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey) {
        throw new UnsupportedOperationException();
    }

    public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        throw new UnsupportedOperationException();
    }

    public void exchangeUnbindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) {
        throw new UnsupportedOperationException();
    }

    public AMQP.Queue.DeclareOk queueDeclare() {
        return this.node.queueDeclare(UUID.randomUUID().toString(), false, true, true, null);
    }

    public AMQP.Queue.DeclareOk queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) {
        return this.node.queueDeclare(queue, durable, exclusive, autoDelete, arguments);
    }

    public void queueDeclareNoWait(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) {
        throw new UnsupportedOperationException();
    }

    public AMQP.Queue.DeclareOk queueDeclarePassive(String queue) throws IOException {
        if (!this.node.getQueue(queue).isPresent()) {
            throw new IOException("No queue named " + queue);
        }
        return null;
    }

    public AMQP.Queue.DeleteOk queueDelete(String queue) {
        throw new UnsupportedOperationException();
    }

    public AMQP.Queue.DeleteOk queueDelete(String queue, boolean ifUnused, boolean ifEmpty) {
        throw new UnsupportedOperationException();
    }

    public void queueDeleteNoWait(String queue, boolean ifUnused, boolean ifEmpty) {
        throw new UnsupportedOperationException();
    }

    public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey) {
        return this.node.queueBind(queue, exchange, routingKey, null);
    }

    public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return this.node.queueBind(queue, exchange, routingKey, arguments);
    }

    public void queueBindNoWait(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        throw new UnsupportedOperationException();
    }

    public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey) {
        throw new UnsupportedOperationException();
    }

    public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        throw new UnsupportedOperationException();
    }

    public AMQP.Queue.PurgeOk queuePurge(String queue) {
        throw new UnsupportedOperationException();
    }

    public GetResponse basicGet(String queue, boolean autoAck) {
        return this.node.basicGet(queue, autoAck);
    }

    public void basicAck(long deliveryTag, boolean multiple) {
        this.node.basicAck(deliveryTag);
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) {
        throw new UnsupportedOperationException();
    }

    public void basicReject(long deliveryTag, boolean requeue) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, Consumer callback) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, DeliverCallback deliverCallback, CancelCallback cancelCallback) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, boolean autoAck, Consumer callback) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, CancelCallback cancelCallback) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, Consumer callback) throws IOException {
        return this.basicConsume(queue, autoAck, "", false, false, arguments, callback);
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, Consumer callback) throws IOException {
        return this.basicConsume(queue, autoAck, consumerTag, false, false, Collections.emptyMap(), callback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, CancelCallback cancelCallback) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, Consumer callback) {
        return this.node.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, callback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        throw new UnsupportedOperationException();
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        throw new UnsupportedOperationException();
    }

    public void basicCancel(String consumerTag) {
        LOGGER.info("Cancelled consumer " + consumerTag);
    }

    public AMQP.Basic.RecoverOk basicRecover() {
        throw new UnsupportedOperationException();
    }

    public AMQP.Basic.RecoverOk basicRecover(boolean requeue) {
        throw new UnsupportedOperationException();
    }

    public AMQP.Tx.SelectOk txSelect() {
        throw new UnsupportedOperationException();
    }

    public AMQP.Tx.CommitOk txCommit() {
        throw new UnsupportedOperationException();
    }

    public AMQP.Tx.RollbackOk txRollback() {
        throw new UnsupportedOperationException();
    }

    public AMQP.Confirm.SelectOk confirmSelect() {
        throw new UnsupportedOperationException();
    }

    public long getNextPublishSeqNo() {
        throw new UnsupportedOperationException();
    }

    public boolean waitForConfirms() {
        throw new UnsupportedOperationException();
    }

    public boolean waitForConfirms(long timeout) {
        throw new UnsupportedOperationException();
    }

    public void waitForConfirmsOrDie() {
        throw new UnsupportedOperationException();
    }

    public void waitForConfirmsOrDie(long timeout) {
        throw new UnsupportedOperationException();
    }

    public void asyncRpc(Method method) {
        throw new UnsupportedOperationException();
    }

    public Command rpc(Method method) {
        throw new UnsupportedOperationException();
    }

    public long messageCount(String queue) {
        throw new UnsupportedOperationException();
    }

    public long consumerCount(String queue) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Command> asyncCompletableRpc(Method method) {
        throw new UnsupportedOperationException();
    }

    public void addShutdownListener(ShutdownListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeShutdownListener(ShutdownListener listener) {
        throw new UnsupportedOperationException();
    }

    public ShutdownSignalException getCloseReason() {
        throw new UnsupportedOperationException();
    }

    public void notifyListeners() {
        throw new UnsupportedOperationException();
    }

    public boolean isOpen() {
        return this.opened.get();
    }
}

