/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock;

import com.github.fridujo.rabbitmq.mock.MockDefaultExchange;
import com.github.fridujo.rabbitmq.mock.MockExchange;
import com.github.fridujo.rabbitmq.mock.MockExchangeFactory;
import com.github.fridujo.rabbitmq.mock.MockQueue;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.impl.AMQImpl;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class MockNode {
    private final Map<String, MockExchange> exchanges = new ConcurrentHashMap<String, MockExchange>();
    private final Map<String, MockQueue> queues = new ConcurrentHashMap<String, MockQueue>();

    public MockNode() {
        this.exchanges.put("", new MockDefaultExchange(this));
        this.queues.put("unrouted", new MockQueue("unrouted"));
    }

    public void basicPublish(String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) {
        if (!this.exchanges.containsKey(exchange)) {
            throw new IllegalArgumentException("No exchange named " + exchange);
        }
        AMQP.BasicProperties nonNullProperties = props != null ? props : new AMQP.BasicProperties.Builder().build();
        this.exchanges.get(exchange).publish(routingKey, nonNullProperties, body);
    }

    public String basicConsume(String queueName, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, Consumer callback) {
        String definitiveConsumerTag = "".equals(consumerTag) ? "amq.ctag-test" + UUID.randomUUID() : consumerTag;
        this.getQueueUnchecked(queueName).addConsumer(definitiveConsumerTag, callback, autoAck);
        return definitiveConsumerTag;
    }

    Optional<MockQueue> getQueue(String name) {
        return Optional.ofNullable(this.queues.get(name));
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchangeName, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) {
        this.exchanges.put(exchangeName, MockExchangeFactory.build(exchangeName, type));
        return new AMQImpl.Exchange.DeclareOk();
    }

    public AMQP.Queue.DeclareOk queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) {
        this.queues.putIfAbsent(queue, new MockQueue(queue));
        return new AMQP.Queue.DeclareOk.Builder().queue(queue).build();
    }

    public AMQP.Queue.BindOk queueBind(String queueName, String exchangeName, String routingKey, Map<String, Object> arguments) {
        MockExchange exchange = this.getExchangeUnchecked(exchangeName);
        MockQueue queue = this.getQueueUnchecked(queueName);
        exchange.bind(queue, routingKey);
        return new AMQImpl.Queue.BindOk();
    }

    public void basicAck(long deliveryTag) {
        this.queues.values().forEach(q -> q.basicAck(deliveryTag));
    }

    public GetResponse basicGet(String queueName, boolean autoAck) {
        MockQueue queue = this.getQueueUnchecked(queueName);
        return queue.basicGet(autoAck);
    }

    private MockExchange getExchangeUnchecked(String exchangeName) {
        if (!this.exchanges.containsKey(exchangeName)) {
            throw new IllegalArgumentException("No exchange named " + exchangeName);
        }
        return this.exchanges.get(exchangeName);
    }

    private MockQueue getQueueUnchecked(String queueName) {
        if (!this.queues.containsKey(queueName)) {
            throw new IllegalArgumentException("No queue named " + queueName);
        }
        return this.queues.get(queueName);
    }
}

