/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockQueue.class);
    private final String name;
    private final List<ConsumerAndTag> consumers = new ArrayList<ConsumerAndTag>();
    private final AtomicInteger sequence = new AtomicInteger();
    private final Queue<Message> messages = new LinkedList<Message>();
    private final Map<Long, Message> unackedMessages = new LinkedHashMap<Long, Message>();
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);

    public MockQueue(String name) {
        this.name = name;
        this.start();
    }

    private void start() {
        this.executorService.submit(() -> {
            while (true) {
                if (this.deliverToConsumerIfPossible()) {
                    continue;
                }
                TimeUnit.MILLISECONDS.sleep(30L);
            }
        });
    }

    private boolean deliverToConsumerIfPossible() {
        boolean delivered = false;
        if (this.consumers.size() > 0) {
            long deliveryTag = this.createDeliveryTag();
            Message message = this.messages.poll();
            if (message != null) {
                this.unackedMessages.put(deliveryTag, message);
                int index = this.sequence.incrementAndGet() % this.consumers.size();
                ConsumerAndTag nextConsumer = this.consumers.get(index);
                Envelope envelope = new Envelope(deliveryTag, false, message.exchangeName, message.routingKey);
                try {
                    nextConsumer.consumer.handleDelivery(nextConsumer.tag, envelope, message.props, message.body);
                    if (nextConsumer.autoAck) {
                        this.unackedMessages.remove(deliveryTag);
                    }
                    delivered = true;
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to deliver message to consumer [" + nextConsumer.tag + "]");
                    this.messages.offer(this.unackedMessages.remove(deliveryTag));
                }
            }
        }
        return delivered;
    }

    private long createDeliveryTag() {
        return System.currentTimeMillis() + (long)this.name.hashCode();
    }

    public void basicAck(long deliveryTag) {
        this.unackedMessages.remove(deliveryTag);
    }

    public void publish(String exchangeName, String routingKey, AMQP.BasicProperties props, byte[] body) {
        this.messages.offer(new Message(exchangeName, routingKey, props, body));
    }

    public void addConsumer(String consumerTag, Consumer consumer, boolean autoAck) {
        this.consumers.add(new ConsumerAndTag(consumerTag, consumer, autoAck));
    }

    public GetResponse basicGet(boolean autoAck) {
        long deliveryTag = this.createDeliveryTag();
        Message message = this.messages.poll();
        if (message != null) {
            if (!autoAck) {
                this.unackedMessages.put(deliveryTag, message);
            }
            Envelope envelope = new Envelope(deliveryTag, false, message.exchangeName, message.routingKey);
            return new GetResponse(envelope, message.props, message.body, this.messages.size());
        }
        return null;
    }

    static class Message {
        final String exchangeName;
        final String routingKey;
        final AMQP.BasicProperties props;
        final byte[] body;

        Message(String exchangeName, String routingKey, AMQP.BasicProperties props, byte[] body) {
            this.exchangeName = exchangeName;
            this.routingKey = routingKey;
            this.props = props;
            this.body = body;
        }
    }

    static class ConsumerAndTag {
        private final String tag;
        private final Consumer consumer;
        private final boolean autoAck;

        ConsumerAndTag(String tag, Consumer consumer, boolean autoAck) {
            this.tag = tag;
            this.consumer = consumer;
            this.autoAck = autoAck;
        }
    }
}

