/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock.spring;

import com.github.fridujo.rabbitmq.mock.MockChannel;
import com.github.fridujo.rabbitmq.mock.MockNode;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.BlockedListener;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ShutdownSignalException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;

class MockConnection
implements Connection {
    private final MockNode node;
    private final Set<ConnectionListener> connectionListeners;
    private AtomicBoolean opened = new AtomicBoolean(true);

    MockConnection(MockNode node, Set<ConnectionListener> connectionListeners) {
        this.node = node;
        this.connectionListeners = connectionListeners;
    }

    public Channel createChannel(boolean transactional) throws AmqpException {
        if (this.opened.get()) {
            return new MockChannel(this.node);
        }
        throw RabbitExceptionTranslator.convertRabbitAccessException((Throwable)new AlreadyClosedException(new ShutdownSignalException(false, true, null, (Object)this)));
    }

    public void close() throws AmqpException {
        this.opened.getAndSet(false);
        this.connectionListeners.forEach(connectionListener -> connectionListener.onClose((Connection)this));
    }

    public boolean isOpen() {
        return this.opened.get();
    }

    public int getLocalPort() {
        return -1;
    }

    public void addBlockedListener(BlockedListener blockedListener) {
    }

    public boolean removeBlockedListener(BlockedListener blockedListener) {
        return false;
    }
}

