/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock.spring;

import com.github.fridujo.rabbitmq.mock.MockNode;
import com.github.fridujo.rabbitmq.mock.spring.MockConnection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;

public class MockConnectionFactory
implements ConnectionFactory {
    private final MockNode node = new MockNode();
    private final Set<ConnectionListener> connectionListeners = new CopyOnWriteArraySet<ConnectionListener>();

    public Connection createConnection() throws AmqpException {
        MockConnection connection = new MockConnection(this.node, this.connectionListeners);
        this.connectionListeners.forEach(connectionListener -> connectionListener.onCreate(connection));
        return connection;
    }

    public String getHost() {
        return "localtest";
    }

    public int getPort() {
        return -1;
    }

    public String getVirtualHost() {
        return null;
    }

    public String getUsername() {
        return null;
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public boolean removeConnectionListener(ConnectionListener listener) {
        return this.connectionListeners.remove(listener);
    }

    public void clearConnectionListeners() {
        this.connectionListeners.clear();
    }
}

