/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock.exchange;

import com.github.fridujo.rabbitmq.mock.AmqArguments;
import com.github.fridujo.rabbitmq.mock.MockQueue;
import com.github.fridujo.rabbitmq.mock.Receiver;
import com.github.fridujo.rabbitmq.mock.ReceiverPointer;
import com.github.fridujo.rabbitmq.mock.ReceiverRegistry;
import com.github.fridujo.rabbitmq.mock.exchange.MockExchange;
import com.rabbitmq.client.AMQP;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BindableMockExchange
implements MockExchange {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockQueue.class);
    protected final Set<BindConfiguration> bindConfigurations = new LinkedHashSet<BindConfiguration>();
    private final String name;
    private final String type;
    private final AmqArguments arguments;
    private final ReceiverPointer pointer;
    private final ReceiverRegistry receiverRegistry;

    protected BindableMockExchange(String name, String type, AmqArguments arguments, ReceiverRegistry receiverRegistry) {
        this.name = name;
        this.type = type;
        this.arguments = arguments;
        this.pointer = new ReceiverPointer(ReceiverPointer.Type.EXCHANGE, name);
        this.receiverRegistry = receiverRegistry;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean publish(String previousExchangeName, String routingKey, AMQP.BasicProperties props, byte[] body) {
        Set<Receiver> matchingReceivers = this.matchingReceivers(routingKey, props).map(this.receiverRegistry::getReceiver).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        if (matchingReceivers.isEmpty()) {
            return this.getAlternateExchange().map(e -> {
                LOGGER.debug(this.localized("message to alternate " + e));
                return e.publish(this.name, routingKey, props, body);
            }).orElse(false);
        }
        matchingReceivers.forEach(e -> {
            LOGGER.debug(this.localized("message to " + e));
            e.publish(this.name, routingKey, props, body);
        });
        return true;
    }

    private Optional<Receiver> getAlternateExchange() {
        return this.arguments.getAlternateExchange().flatMap(this.receiverRegistry::getReceiver);
    }

    protected abstract Stream<ReceiverPointer> matchingReceivers(String var1, AMQP.BasicProperties var2);

    private String localized(String message) {
        return "[E " + this.name + "] " + message;
    }

    @Override
    public void bind(ReceiverPointer receiver, String routingKey, Map<String, Object> arguments) {
        this.bindConfigurations.add(new BindConfiguration(routingKey, receiver, arguments));
    }

    @Override
    public void unbind(ReceiverPointer receiver, String routingKey) {
        this.bindConfigurations.remove(new BindConfiguration(routingKey, receiver, Collections.emptyMap()));
    }

    @Override
    public ReceiverPointer pointer() {
        return this.pointer;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.name;
    }

    public static class BindConfiguration {
        public final String bindingKey;
        public final ReceiverPointer receiverPointer;
        public final Map<String, Object> bindArguments;

        public BindConfiguration(String bindingKey, ReceiverPointer receiverPointer, Map<String, Object> bindArguments) {
            this.bindingKey = bindingKey;
            this.receiverPointer = receiverPointer;
            this.bindArguments = bindArguments;
        }

        public ReceiverPointer receiverPointer() {
            return this.receiverPointer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BindConfiguration that = (BindConfiguration)o;
            return Objects.equals(this.bindingKey, that.bindingKey) && Objects.equals(this.receiverPointer, that.receiverPointer);
        }

        public int hashCode() {
            return Objects.hash(this.bindingKey, this.receiverPointer);
        }
    }
}

