/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock;

import com.github.fridujo.rabbitmq.mock.ReceiverPointer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class AmqArguments {
    public static final String DEAD_LETTER_EXCHANGE_KEY = "x-dead-letter-exchange";
    public static final String DEAD_LETTER_ROUTING_KEY_KEY = "x-dead-letter-routing-key";
    public static final String MESSAGE_TTL_KEY = "x-message-ttl";
    public static final String QUEUE_MAX_LENGTH_KEY = "x-max-length";
    public static final String QUEUE_MAX_LENGTH_BYTES_KEY = "x-max-length-bytes";
    public static final String OVERFLOW_KEY = "x-overflow";
    public static final String MAX_PRIORITY_KEY = "x-max-priority";
    private final String ALTERNATE_EXCHANGE_KEY = "alternate-exchange";
    private final Map<String, Object> arguments;

    public static AmqArguments empty() {
        return new AmqArguments(Collections.emptyMap());
    }

    public AmqArguments(Map<String, Object> arguments) {
        this.arguments = arguments;
    }

    public Optional<ReceiverPointer> getAlternateExchange() {
        return this.string("alternate-exchange").map(aeName -> new ReceiverPointer(ReceiverPointer.Type.EXCHANGE, (String)aeName));
    }

    public Optional<ReceiverPointer> getDeadLetterExchange() {
        return this.string(DEAD_LETTER_EXCHANGE_KEY).map(aeName -> new ReceiverPointer(ReceiverPointer.Type.EXCHANGE, (String)aeName));
    }

    public Optional<String> getDeadLetterRoutingKey() {
        return this.string(DEAD_LETTER_ROUTING_KEY_KEY);
    }

    public Optional<Integer> queueLengthLimit() {
        return this.positiveInteger(QUEUE_MAX_LENGTH_KEY);
    }

    public Optional<Integer> queueLengthBytesLimit() {
        return this.positiveInteger(QUEUE_MAX_LENGTH_BYTES_KEY);
    }

    public Overflow overflow() {
        return this.string(OVERFLOW_KEY).flatMap(x$0 -> Overflow.parse(x$0)).orElse(Overflow.DROP_HEAD);
    }

    public Optional<Long> getMessageTtlOfQueue() {
        return Optional.ofNullable(this.arguments.get(MESSAGE_TTL_KEY)).filter(aeObject -> aeObject instanceof Number).map(Number.class::cast).map(number -> number.longValue());
    }

    public Optional<Short> queueMaxPriority() {
        return this.positiveInteger(MAX_PRIORITY_KEY).filter(i -> i < 256).map(Integer::shortValue);
    }

    private Optional<Integer> positiveInteger(String key) {
        return Optional.ofNullable(this.arguments.get(key)).filter(aeObject -> aeObject instanceof Number).map(Number.class::cast).map(num -> num.intValue()).filter(i -> i > 0);
    }

    private Optional<String> string(String key) {
        return Optional.ofNullable(this.arguments.get(key)).filter(aeObject -> aeObject instanceof String).map(String.class::cast);
    }

    public static enum Overflow {
        DROP_HEAD("drop-head"),
        REJECT_PUBLISH("reject-publish");

        private final String stringValue;

        private Overflow(String stringValue) {
            this.stringValue = stringValue;
        }

        private static Optional<Overflow> parse(String value) {
            return Arrays.stream(Overflow.values()).filter(v -> value.equals(v.stringValue)).findFirst();
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

