/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock.exchange;

import com.github.fridujo.rabbitmq.mock.AmqArguments;
import com.github.fridujo.rabbitmq.mock.ReceiverPointer;
import com.github.fridujo.rabbitmq.mock.ReceiverRegistry;
import com.github.fridujo.rabbitmq.mock.exchange.SingleReceiverExchange;
import com.rabbitmq.client.AMQP;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConsistentHashExchange
extends SingleReceiverExchange {
    public static final String TYPE = "x-consistent-hash";
    private final List<Bucket> buckets = new ArrayList<Bucket>();

    public ConsistentHashExchange(String name, AmqArguments arguments, ReceiverRegistry receiverRegistry) {
        super(name, TYPE, arguments, receiverRegistry);
    }

    @Override
    protected Optional<ReceiverPointer> selectReceiver(String routingKey, AMQP.BasicProperties props) {
        int bucketSelector = Math.abs(routingKey.hashCode()) % this.buckets.size();
        return Optional.of(this.buckets.get(bucketSelector).receiverPointer);
    }

    @Override
    public void bind(ReceiverPointer receiver, String routingKey, Map<String, Object> arguments) {
        super.bind(receiver, routingKey, arguments);
        this.buckets.addAll(this.bucketsFor(routingKey, receiver));
    }

    @Override
    public void unbind(ReceiverPointer receiver, String routingKey) {
        super.unbind(receiver, routingKey);
        this.buckets.removeIf(b -> ((Bucket)b).receiverPointer.equals(receiver));
    }

    private int routingKeyToWeight(String routingKey) {
        try {
            return Integer.parseInt(routingKey);
        }
        catch (NumberFormatException e) {
            return routingKey.hashCode();
        }
    }

    private List<Bucket> bucketsFor(String routingKey, ReceiverPointer receiverPointer) {
        int weight = this.routingKeyToWeight(routingKey);
        return Stream.generate(() -> receiverPointer).map(Bucket::new).limit(weight).collect(Collectors.toList());
    }

    public static final class Bucket {
        private final ReceiverPointer receiverPointer;

        public Bucket(ReceiverPointer receiverPointer) {
            this.receiverPointer = receiverPointer;
        }
    }
}

