/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock;

import com.github.fridujo.rabbitmq.mock.Message;
import com.rabbitmq.client.AMQP;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface DeadLettering {
    public static final String X_DEATH_HEADER = "x-death";

    public static class Event {
        private static final String QUEUE_KEY = "queue";
        private static final String REASON_KEY = "reason";
        private static final String EXCHANGE_KEY = "exchange";
        private static final String ROUTING_KEYS_KEY = "routing-keys";
        private static final String COUNT_KEY = "count";
        private final String queue;
        private final ReasonType reason;
        private final String exchange;
        private final List<String> routingKeys;
        private final long count;

        public Event(String queue, ReasonType reason, Message message, int count) {
            this.queue = queue;
            this.reason = reason;
            this.exchange = message.exchangeName;
            this.routingKeys = Collections.singletonList(message.routingKey);
            this.count = count;
        }

        public Map<String, Object> asHeaderEntry() {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put(QUEUE_KEY, this.queue);
            entry.put(REASON_KEY, this.reason.headerValue);
            entry.put(EXCHANGE_KEY, this.exchange);
            entry.put(ROUTING_KEYS_KEY, this.routingKeys);
            entry.put(COUNT_KEY, this.count);
            return entry;
        }

        public AMQP.BasicProperties prependOn(AMQP.BasicProperties props) {
            Map<String, Object> currentEvent;
            Map headers = Optional.ofNullable(props.getHeaders()).map(HashMap::new).orElseGet(HashMap::new);
            List xDeathHeader = (List)headers.computeIfAbsent(DeadLettering.X_DEATH_HEADER, key -> new ArrayList());
            Optional<Map> previousEvent = xDeathHeader.stream().filter(this::sameQueueAndReason).findFirst();
            if (previousEvent.isPresent()) {
                xDeathHeader.remove(previousEvent.get());
                currentEvent = this.incrementCount(previousEvent.get());
            } else {
                currentEvent = this.asHeaderEntry();
            }
            xDeathHeader.add(0, currentEvent);
            return props.builder().headers(Collections.unmodifiableMap(headers)).build();
        }

        private Map<String, Object> incrementCount(Map<String, Object> previousEvent) {
            previousEvent.compute(COUNT_KEY, (key, count) -> (Long)count + 1L);
            return previousEvent;
        }

        private boolean sameQueueAndReason(Map<String, Object> event) {
            return this.queue.equals(event.get(QUEUE_KEY)) && this.reason.headerValue.equals(event.get(REASON_KEY));
        }
    }

    public static enum ReasonType {
        REJECTED("rejected"),
        EXPIRED("expired"),
        MAX_LEN("maxlen");

        public final String headerValue;

        private ReasonType(String headerValue) {
            this.headerValue = headerValue;
        }
    }
}

