/*
 * Decompiled with CFR 0.152.
 */
package com.github.frostyaxe.pagefactory;

import com.github.frostyaxe.pagefactory.ElementLocatorFactory;
import com.github.frostyaxe.pagefactory.FrostyElementLocatorFactory;
import com.github.frostyaxe.pagefactory.FrostyFieldDecorator;
import com.github.frostyaxe.pagefactory.annotations.FrostyConfig;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

public class FrostyFactory {
    private static Map<String, Object> frostyConfig = new HashMap<String, Object>();

    public static void initElements(WebDriver driver, Object page) {
        WebDriver driverRef = driver;
        FrostyFactory.initElements(new FrostyElementLocatorFactory((SearchContext)driverRef), page);
    }

    public static void initElements(ElementLocatorFactory factory, Object page) {
        ElementLocatorFactory factoryRef = factory;
        FrostyFactory.initElements(new FrostyFieldDecorator(factoryRef), page);
    }

    public static void initElements(FieldDecorator decorator, Object page) {
        FrostyFactory.createConfigMap(page);
        for (Class<?> proxyIn = page.getClass(); proxyIn != Object.class; proxyIn = proxyIn.getSuperclass()) {
            FrostyFactory.proxyFields(decorator, page, proxyIn);
        }
    }

    private static void proxyFields(FieldDecorator decorator, Object page, Class<?> proxyIn) {
        Field[] fields;
        for (Field field : fields = proxyIn.getDeclaredFields()) {
            Object value = decorator.decorate(page.getClass().getClassLoader(), field);
            if (value == null) continue;
            try {
                field.setAccessible(true);
                field.set(page, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void createConfigMap(Object page) {
        FrostyConfig[] config = (FrostyConfig[])page.getClass().getDeclaredAnnotationsByType(FrostyConfig.class);
        if (config.length <= 0) {
            System.err.println("FrostyConfig annotation is required!");
        } else {
            frostyConfig.put("host", config[config.length - 1].host());
            frostyConfig.put("port", config[config.length - 1].port());
        }
    }

    public static Map<String, Object> getConfigMap() {
        return frostyConfig;
    }
}

