/*
 * Decompiled with CFR 0.152.
 */
package com.github.frostyaxe.pagefactory;

import com.github.frostyaxe.pagefactory.ElementLocatorFactory;
import com.github.frostyaxe.pagefactory.annotations.SearchWith;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.interactions.Locatable;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementHandler;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementListHandler;

public class FrostyFieldDecorator
implements FieldDecorator {
    protected ElementLocatorFactory factory;

    public FrostyFieldDecorator(ElementLocatorFactory factoryRef) {
        this.factory = factoryRef;
    }

    public Object decorate(ClassLoader loader, Field field) {
        if (!WebElement.class.isAssignableFrom(field.getType()) && !this.isDecoratableList(field)) {
            return null;
        }
        ElementLocator locator = this.factory.createLocator(field);
        if (locator == null) {
            return null;
        }
        if (WebElement.class.isAssignableFrom(field.getType())) {
            return this.proxyForLocator(loader, locator);
        }
        if (List.class.isAssignableFrom(field.getType())) {
            return this.proxyForListLocator(loader, locator);
        }
        return null;
    }

    protected boolean isDecoratableList(Field field) {
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
        if (!WebElement.class.equals((Object)listType)) {
            return false;
        }
        return field.getAnnotation(SearchWith.class) != null;
    }

    protected WebElement proxyForLocator(ClassLoader loader, ElementLocator locator) {
        LocatingElementHandler handler = new LocatingElementHandler(locator);
        WebElement proxy = (WebElement)Proxy.newProxyInstance(loader, new Class[]{WebElement.class, WrapsElement.class, Locatable.class}, (InvocationHandler)handler);
        return proxy;
    }

    protected List<WebElement> proxyForListLocator(ClassLoader loader, ElementLocator locator) {
        LocatingElementListHandler handler = new LocatingElementListHandler(locator);
        List proxy = (List)Proxy.newProxyInstance(loader, new Class[]{List.class}, (InvocationHandler)handler);
        return proxy;
    }
}

