/*
 * Decompiled with CFR 0.152.
 */
package blobstore.azure;

import blobstore.Store;
import blobstore.azure.AzureBlob;
import blobstore.azure.AzureStore$;
import blobstore.package$;
import blobstore.url.Authority;
import blobstore.url.Path;
import blobstore.url.Path$;
import blobstore.url.Url;
import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.std.Queue$;
import cats.syntax.ApplicativeErrorIdOps$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.batch.BlobBatchAsyncClient;
import com.azure.storage.blob.batch.BlobBatchClientBuilder;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobItemProperties;
import com.azure.storage.blob.models.BlobListDetails;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.ParallelTransferOptions;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import fs2.compat.NotGiven$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\red\u0001B\u0015+\u0001=B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t1\u0002\u0011\t\u0011)A\u00053\"AA\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003_\u0011!\t\u0007A!A!\u0002\u0013q\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011\r\u0004!1!Q\u0001\f\u0011DQA\u001e\u0001\u0005\u0002]Dq!a\u0001\u0001\t\u0003\n)\u0001C\u0004\u00020\u0001!\t%!\r\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!I\u0011\u0011\u0011\u0001\u0012\u0002\u0013\u0005\u00111\u0011\u0005\n\u0003;\u0003\u0011\u0013!C\u0001\u0003?Cq!!\u0013\u0001\t\u0003\t9\u000bC\u0004\u0002b\u0002!\t%a9\t\u000f\u0005}\b\u0001\"\u0011\u0003\u0002!9!Q\u0003\u0001\u0005B\t]\u0001\"\u0003B\u0013\u0001E\u0005I\u0011\u0001B\u0014\u0011\u001d\u0011Y\u0003\u0001C!\u0005[AqA!\u0011\u0001\t\u0003\u0012\u0019\u0005C\u0004\u0003P\u0001!\tA!\u0015\b\u000f\t\u001d$\u0006#\u0001\u0003j\u00191\u0011F\u000bE\u0001\u0005WBaA^\f\u0005\u0002\t5\u0004b\u0002B8/\u0011\u0005!\u0011\u000f\u0005\n\u0005';\u0012\u0013!C\u0001\u0005+C\u0011B!(\u0018#\u0003%\tAa(\t\u0013\t\u001dv#%A\u0005\u0002\t%\u0006\"\u0003B[/E\u0005I\u0011\u0001B\\\u0011%\u0011ylFI\u0001\n\u0003\u0011\t\rC\u0004\u0003J^!IAa3\t\u000f\tuw\u0003\"\u0003\u0003`\"9!Q^\f\u0005\n\t=XA\u0002B~/\u0011\u0011i\u0010C\u0004\u0003\u0000^!Ia!\u0001\t\u0013\r\u001ds#%A\u0005\u0002\r%\u0003\"CB)/E\u0005I\u0011AB*\u0011%\u0019YfFI\u0001\n\u0003\u0019i\u0006C\u0005\u0004f]\t\n\u0011\"\u0001\u0004h!I1qN\f\u0012\u0002\u0013\u00051\u0011\u000f\u0002\u000b\u0003j,(/Z*u_J,'BA\u0016-\u0003\u0015\t'0\u001e:f\u0015\u0005i\u0013!\u00032m_\n\u001cHo\u001c:f\u0007\u0001)\"\u0001M\u001f\u0014\u0007\u0001\tt\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VM\u001a\t\u0005qeZ\u0014*D\u0001-\u0013\tQDFA\u0003Ti>\u0014X\r\u0005\u0002={1\u0001A!\u0002 \u0001\u0005\u0004y$!\u0001$\u0016\u0005\u0001;\u0015CA!E!\t\u0011$)\u0003\u0002Dg\t9aj\u001c;iS:<\u0007C\u0001\u001aF\u0013\t15GA\u0002B]f$Q\u0001S\u001fC\u0002\u0001\u0013\u0011a\u0018\t\u0003\u0015.k\u0011AK\u0005\u0003\u0019*\u0012\u0011\"\u0011>ve\u0016\u0014En\u001c2\u0011\u000593V\"A(\u000b\u0005A\u000b\u0016\u0001\u00022m_\nT!AU*\u0002\u000fM$xN]1hK*\u00111\u0006\u0016\u0006\u0002+\u0006\u00191m\\7\n\u0005]{%A\u0006\"m_\n\u001cVM\u001d<jG\u0016\f5/\u001f8d\u00072LWM\u001c;\u0002'\u0011,g-Y;mi\u001a+H\u000e\\'fi\u0006$\u0017\r^1\u0011\u0005IR\u0016BA.4\u0005\u001d\u0011un\u001c7fC:\f\u0011\u0004Z3gCVdG\u000f\u0016:bS2LgnZ*mCNDg)\u001b7fg\u0006I!\r\\8dWNK'0\u001a\t\u0003e}K!\u0001Y\u001a\u0003\u0007%sG/\u0001\u0006ok6\u0014UO\u001a4feN\f\u0011\"];fk\u0016\u001c\u0016N_3\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002fgnr!A\u001a9\u000f\u0005\u001dlgB\u00015l\u001b\u0005I'B\u00016/\u0003\u0019a$o\\8u}%\tA.\u0001\u0003dCR\u001c\u0018B\u00018p\u0003\u0019)gMZ3di*\tA.\u0003\u0002re\u00069\u0001/Y2lC\u001e,'B\u00018p\u0013\t!XOA\u0003Bgft7M\u0003\u0002re\u00061A(\u001b8jiz\"\u0002\u0002_>}{z|\u0018\u0011\u0001\u000b\u0003sj\u00042A\u0013\u0001<\u0011\u0015\u0019\u0007\u0002q\u0001e\u0011\u0015Y\u0003\u00021\u0001N\u0011\u001dA\u0006\u0002%AA\u0002eCq\u0001\u0018\u0005\u0011\u0002\u0003\u0007\u0011\fC\u0004^\u0011A\u0005\t\u0019\u00010\t\u000f\u0005D\u0001\u0013!a\u0001=\"9!\r\u0003I\u0001\u0002\u0004q\u0016\u0001\u00027jgR,B!a\u0002\u0002(Q1\u0011\u0011BA\u0011\u0003W\u0001r!a\u0003\u0002\u0012m\n)\"\u0004\u0002\u0002\u000e)\u0011\u0011qB\u0001\u0004MN\u0014\u0014\u0002BA\n\u0003\u001b\u0011aa\u0015;sK\u0006l\u0007#BA\f\u0003;IUBAA\r\u0015\r\tY\u0002L\u0001\u0004kJd\u0017\u0002BA\u0010\u00033\u00111!\u0016:m\u0011\u001d\tY\"\u0003a\u0001\u0003G\u0001b!a\u0006\u0002\u001e\u0005\u0015\u0002c\u0001\u001f\u0002(\u00111\u0011\u0011F\u0005C\u0002\u0001\u0013\u0011!\u0011\u0005\t\u0003[I\u0001\u0013!a\u00013\u0006I!/Z2veNLg/Z\u0001\u0004O\u0016$X\u0003BA\u001a\u0003\u0007\"b!!\u000e\u0002>\u0005\u0015\u0003cBA\u0006\u0003#Y\u0014q\u0007\t\u0004e\u0005e\u0012bAA\u001eg\t!!)\u001f;f\u0011\u001d\tYB\u0003a\u0001\u0003\u007f\u0001b!a\u0006\u0002\u001e\u0005\u0005\u0003c\u0001\u001f\u0002D\u00111\u0011\u0011\u0006\u0006C\u0002\u0001Ca!a\u0012\u000b\u0001\u0004q\u0016!C2ik:\\7+\u001b>f\u0003\r\u0001X\u000f^\u000b\u0005\u0003\u001b\nY\u0007\u0006\u0005\u0002P\u0005\u0015\u0014QNA9!%\t\t&!\u0017<\u0003o\tyF\u0004\u0003\u0002T\u0005]cb\u00015\u0002V%\u0011\u0011qB\u0005\u0004c\u00065\u0011\u0002BA.\u0003;\u0012A\u0001U5qK*\u0019\u0011/!\u0004\u0011\u0007I\n\t'C\u0002\u0002dM\u0012A!\u00168ji\"9\u00111D\u0006A\u0002\u0005\u001d\u0004CBA\f\u0003;\tI\u0007E\u0002=\u0003W\"a!!\u000b\f\u0005\u0004\u0001\u0005\u0002CA8\u0017A\u0005\t\u0019A-\u0002\u0013=4XM]<sSR,\u0007\"CA:\u0017A\u0005\t\u0019AA;\u0003\u0011\u0019\u0018N_3\u0011\u000bI\n9(a\u001f\n\u0007\u0005e4G\u0001\u0004PaRLwN\u001c\t\u0004e\u0005u\u0014bAA@g\t!Aj\u001c8h\u00035\u0001X\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU!\u0011QQAN+\t\t9IK\u0002Z\u0003\u0013[#!a#\u0011\t\u00055\u0015qS\u0007\u0003\u0003\u001fSA!!%\u0002\u0014\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+\u001b\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011TAH\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0007\u0003Sa!\u0019\u0001!\u0002\u001bA,H\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0011\t\t+!*\u0016\u0005\u0005\r&\u0006BA;\u0003\u0013#a!!\u000b\u000e\u0005\u0004\u0001U\u0003BAU\u0003c#\"\"a\u0014\u0002,\u0006M\u0016QWAd\u0011\u001d\tYB\u0004a\u0001\u0003[\u0003b!a\u0006\u0002\u001e\u0005=\u0006c\u0001\u001f\u00022\u00121\u0011\u0011\u0006\bC\u0002\u0001Ca!a\u001c\u000f\u0001\u0004I\u0006bBA\\\u001d\u0001\u0007\u0011\u0011X\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b#\u0002\u001a\u0002x\u0005m\u0006\u0003BA_\u0003\u0007l!!a0\u000b\u0007\u0005\u0005w*\u0001\u0004n_\u0012,Gn]\u0005\u0005\u0003\u000b\fyL\u0001\nCY>\u0014\u0017\n^3n!J|\u0007/\u001a:uS\u0016\u001c\bbBAe\u001d\u0001\u0007\u00111Z\u0001\u0005[\u0016$\u0018\r\u0005\u0005\u0002N\u0006U\u00171\\An\u001d\u0011\ty-!5\u0011\u0005!\u001c\u0014bAAjg\u00051\u0001K]3eK\u001aLA!a6\u0002Z\n\u0019Q*\u00199\u000b\u0007\u0005M7\u0007\u0005\u0003\u0002N\u0006u\u0017\u0002BAp\u00033\u0014aa\u0015;sS:<\u0017\u0001B7pm\u0016,b!!:\u0002r\u0006mHCBAt\u0003S\f\u0019\u0010\u0005\u0003={\u0005}\u0003bBAv\u001f\u0001\u0007\u0011Q^\u0001\u0004gJ\u001c\u0007CBA\f\u0003;\ty\u000fE\u0002=\u0003c$a!!\u000b\u0010\u0005\u0004\u0001\u0005bBA{\u001f\u0001\u0007\u0011q_\u0001\u0004IN$\bCBA\f\u0003;\tI\u0010E\u0002=\u0003w$a!!@\u0010\u0005\u0004\u0001%!\u0001\"\u0002\t\r|\u0007/_\u000b\u0007\u0005\u0007\u0011YAa\u0005\u0015\r\u0005\u001d(Q\u0001B\u0007\u0011\u001d\tY\u000f\u0005a\u0001\u0005\u000f\u0001b!a\u0006\u0002\u001e\t%\u0001c\u0001\u001f\u0003\f\u00111\u0011\u0011\u0006\tC\u0002\u0001Cq!!>\u0011\u0001\u0004\u0011y\u0001\u0005\u0004\u0002\u0018\u0005u!\u0011\u0003\t\u0004y\tMAABA\u007f!\t\u0007\u0001)\u0001\u0004sK6|g/Z\u000b\u0005\u00053\u0011\t\u0003\u0006\u0004\u0002h\nm!1\u0005\u0005\b\u00037\t\u0002\u0019\u0001B\u000f!\u0019\t9\"!\b\u0003 A\u0019AH!\t\u0005\r\u0005%\u0012C1\u0001A\u0011!\ti#\u0005I\u0001\u0002\u0004I\u0016\u0001\u0005:f[>4X\r\n3fM\u0006,H\u000e\u001e\u00133+\u0011\t)I!\u000b\u0005\r\u0005%\"C1\u0001A\u0003%\u0001X\u000f\u001e*pi\u0006$X-\u0006\u0003\u00030\tmBCBA(\u0005c\u0011i\u0004C\u0004\u00034M\u0001\rA!\u000e\u0002\u0015\r|W\u000e];uKV\u0013H\u000e\u0005\u0003={\t]\u0002CBA\f\u0003;\u0011I\u0004E\u0002=\u0005w!a!!\u000b\u0014\u0005\u0004\u0001\u0005b\u0002B '\u0001\u0007\u00111P\u0001\u0006Y&l\u0017\u000e^\u0001\u0005gR\fG/\u0006\u0003\u0003F\t5C\u0003BA\u0005\u0005\u000fBq!a\u0007\u0015\u0001\u0004\u0011I\u0005\u0005\u0004\u0002\u0018\u0005u!1\n\t\u0004y\t5CABA\u0015)\t\u0007\u0001)\u0001\bmSN$XK\u001c3fe2L\u0018N\\4\u0016\t\tM#1\f\u000b\u000b\u0003\u0013\u0011)F!\u0018\u0003b\t\u0015\u0004bBA\u000e+\u0001\u0007!q\u000b\t\u0007\u0003/\tiB!\u0017\u0011\u0007q\u0012Y\u0006\u0002\u0004\u0002*U\u0011\r\u0001\u0011\u0005\u0007\u0005?*\u0002\u0019A-\u0002\u0019\u0019,H\u000e\\'fi\u0006$\u0017\r^1\t\r\t\rT\u00031\u0001Z\u0003a)\u0007\u0010]3diR\u0013\u0018-\u001b7j]\u001e\u001cF.Y:i\r&dWm\u001d\u0005\u0007\u0003[)\u0002\u0019A-\u0002\u0015\u0005SXO]3Ti>\u0014X\r\u0005\u0002K/M\u0011q#\r\u000b\u0003\u0005S\nQ!\u00199qYf,BAa\u001d\u0003|Qq!Q\u000fBD\u0005\u0013\u0013YI!$\u0003\u0010\nEE\u0003\u0002B<\u0005\u0003\u0003BA\u0013\u0001\u0003zA\u0019AHa\u001f\u0005\ryJ\"\u0019\u0001B?+\r\u0001%q\u0010\u0003\u0007\u0011\nm$\u0019\u0001!\t\u0013\t\r\u0015$!AA\u0004\t\u0015\u0015AC3wS\u0012,gnY3%eA!Qm\u001dB=\u0011\u0015Y\u0013\u00041\u0001N\u0011\u001dA\u0016\u0004%AA\u0002eCq\u0001X\r\u0011\u0002\u0003\u0007\u0011\fC\u0004^3A\u0005\t\u0019\u00010\t\u000f\u0005L\u0002\u0013!a\u0001=\"9!-\u0007I\u0001\u0002\u0004q\u0016aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0016\t\u0005\u0015%q\u0013\u0003\u0007}i\u0011\rA!'\u0016\u0007\u0001\u0013Y\n\u0002\u0004I\u0005/\u0013\r\u0001Q\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%gU!\u0011Q\u0011BQ\t\u0019q4D1\u0001\u0003$V\u0019\u0001I!*\u0005\r!\u0013\tK1\u0001A\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"T\u0003\u0002BV\u0005_+\"A!,+\u0007y\u000bI\t\u0002\u0004?9\t\u0007!\u0011W\u000b\u0004\u0001\nMFA\u0002%\u00030\n\u0007\u0001)A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00136+\u0011\u0011YK!/\u0005\ryj\"\u0019\u0001B^+\r\u0001%Q\u0018\u0003\u0007\u0011\ne&\u0019\u0001!\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIY*BAa+\u0003D\u00121aH\bb\u0001\u0005\u000b,2\u0001\u0011Bd\t\u0019A%1\u0019b\u0001\u0001\u0006)RO\u001d7U_\u000e{g\u000e^1j]\u0016\u0014\u0018I\u001c3CY>\u0014W\u0003\u0002Bg\u00057$BAa4\u0003VB9!G!5\u0002\\\u0006m\u0017b\u0001Bjg\t1A+\u001e9mKJBq!a\u0007 \u0001\u0004\u00119\u000e\u0005\u0004\u0002\u0018\u0005u!\u0011\u001c\t\u0004y\tmGABA\u0015?\t\u0007\u0001)\u0001\u000bu_\ncwNY%uK6\u0004&o\u001c9feRLWm\u001d\u000b\u0005\u0005C\u0014\u0019\u000fE\u00043\u0005#\fY,a3\t\u000f\t\u0015\b\u00051\u0001\u0003h\u0006\u0011!\r\u001d\t\u0005\u0003{\u0013I/\u0003\u0003\u0003l\u0006}&A\u0004\"m_\n\u0004&o\u001c9feRLWm]\u0001\ni>DU-\u00193feN$BA!=\u0003xB!\u0011Q\u0018Bz\u0013\u0011\u0011)0a0\u0003\u001f\tcwN\u0019%uiBDU-\u00193feNDqA!?\"\u0001\u0004\tY,A\u0002cSB\u00141$T1zE\u0016\u0014En\u001c2Ji\u0016l\u0007K]8qKJ$\u0018.Z:NKR\f\u0007#\u0002\u001a\u0002x\t\u0005\u0018A\u00042m_\nLE/Z7U_B\u000bG\u000f\u001b\u000b\t\u0007\u0007\u00199d!\u0011\u0004DAA1QAB\n\u0007/\u0019i\"\u0004\u0002\u0004\b)!1\u0011BB\u0006\u0003!1WO\\2uS>t'\u0002BB\u0007\u0007\u001f\tA!\u001e;jY*\u00111\u0011C\u0001\u0005U\u00064\u0018-\u0003\u0003\u0004\u0016\r\u001d!\u0001\u0003$v]\u000e$\u0018n\u001c8\u0011\t\u0005u6\u0011D\u0005\u0005\u00077\tyL\u0001\u0005CY>\u0014\u0017\n^3n!\u0019\u0019yb!\f\u000425\u00111\u0011\u0005\u0006\u0005\u0007G\u0019)#A\u0005qk\nd\u0017n\u001d5fe*!1qEB\u0015\u0003\u0011\u0019wN]3\u000b\u0005\r-\u0012a\u0002:fC\u000e$xN]\u0005\u0005\u0007_\u0019\tC\u0001\u0003N_:|\u0007#BA\f\u0007gI\u0015\u0002BB\u001b\u00033\u0011A\u0001U1uQ\"91\u0011H\u0012A\u0002\rm\u0012aD2p]R\f\u0017N\\3s\u00072LWM\u001c;\u0011\u00079\u001bi$C\u0002\u0004@=\u0013\u0001D\u00117pE\u000e{g\u000e^1j]\u0016\u0014\u0018i]=oG\u000ec\u0017.\u001a8u\u0011\u0019\u0011\u0019g\ta\u00013\"91QI\u0012A\u0002\u0005m\u0017!C2p]R\f\u0017N\\3s\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU!\u0011QQB&\t\u0019qDE1\u0001\u0004NU\u0019\u0001ia\u0014\u0005\r!\u001bYE1\u0001A\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU!\u0011QQB+\t\u0019qTE1\u0001\u0004XU\u0019\u0001i!\u0017\u0005\r!\u001b)F1\u0001A\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU!!1VB0\t\u0019qdE1\u0001\u0004bU\u0019\u0001ia\u0019\u0005\r!\u001byF1\u0001A\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU!!1VB5\t\u0019qtE1\u0001\u0004lU\u0019\u0001i!\u001c\u0005\r!\u001bIG1\u0001A\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU!!1VB:\t\u0019q\u0004F1\u0001\u0004vU\u0019\u0001ia\u001e\u0005\r!\u001b\u0019H1\u0001A\u0001")
public class AzureStore<F>
implements Store<F, AzureBlob> {
    private final BlobServiceAsyncClient azure;
    private final boolean defaultFullMetadata;
    private final boolean defaultTrailingSlashFiles;
    private final int blockSize;
    private final int numBuffers;
    private final int queueSize;
    private final Async<F> evidence$1;

    public static <F> int $lessinit$greater$default$6() {
        return AzureStore$.MODULE$.$lessinit$greater$default$6();
    }

    public static <F> int $lessinit$greater$default$5() {
        return AzureStore$.MODULE$.$lessinit$greater$default$5();
    }

    public static <F> int $lessinit$greater$default$4() {
        return AzureStore$.MODULE$.$lessinit$greater$default$4();
    }

    public static <F> boolean $lessinit$greater$default$3() {
        return AzureStore$.MODULE$.$lessinit$greater$default$3();
    }

    public static <F> boolean $lessinit$greater$default$2() {
        return AzureStore$.MODULE$.$lessinit$greater$default$2();
    }

    public static <F> int apply$default$6() {
        return AzureStore$.MODULE$.apply$default$6();
    }

    public static <F> int apply$default$5() {
        return AzureStore$.MODULE$.apply$default$5();
    }

    public static <F> int apply$default$4() {
        return AzureStore$.MODULE$.apply$default$4();
    }

    public static <F> boolean apply$default$3() {
        return AzureStore$.MODULE$.apply$default$3();
    }

    public static <F> boolean apply$default$2() {
        return AzureStore$.MODULE$.apply$default$2();
    }

    public static <F> AzureStore<F> apply(BlobServiceAsyncClient blobServiceAsyncClient, boolean bl, boolean bl2, int n, int n2, int n3, Async<F> async) {
        return AzureStore$.MODULE$.apply(blobServiceAsyncClient, bl, bl2, n, n2, n3, async);
    }

    public <A> boolean list$default$2() {
        return Store.list$default$2$((Store)this);
    }

    public <A> Stream<F, Url<AzureBlob>> list(Url<A> url, boolean recursive) {
        return this.listUnderlying(url, this.defaultFullMetadata, this.defaultTrailingSlashFiles, recursive);
    }

    public <A> Stream<F, Object> get(Url<A> url, int chunkSize) {
        Tuple2<String, String> tuple2 = AzureStore$.MODULE$.blobstore$azure$AzureStore$$urlToContainerAndBlob(url);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String container = (String)tuple2._1();
        String blobName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)container, (Object)blobName);
        Tuple2 tuple23 = tuple22;
        String container2 = (String)tuple23._1();
        String blobName2 = (String)tuple23._2();
        return fs2.interop.reactivestreams.package$.MODULE$.fromPublisher((Publisher)this.azure.getBlobContainerAsyncClient(container2).getBlobAsyncClient(blobName2).download(), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)byteBuffer -> Stream$.MODULE$.chunk(Chunk$.MODULE$.byteBuffer(byteBuffer)), NotGiven$.MODULE$.default());
    }

    public <A> Function1<Stream<F, Object>, Stream<F, BoxedUnit>> put(Url<A> url, boolean overwrite, Option<Object> size) {
        return this.put(url, overwrite, (Option<BlobItemProperties>)((Option)size.fold((Function0 & Serializable & scala.Serializable)() -> package.all$.MODULE$.none(), (Function1 & Serializable & scala.Serializable)s -> OptionIdOps$.MODULE$.some$extension(package.all$.MODULE$.catsSyntaxOptionId((Object)new BlobItemProperties().setContentLength(Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)s))))))), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public <A> Function1<Stream<F, Object>, Stream<F, BoxedUnit>> put(Url<A> url, boolean overwrite, Option<BlobItemProperties> properties, scala.collection.immutable.Map<String, String> meta) {
        return (Function1 & Serializable & scala.Serializable)in -> Stream$.MODULE$.resource(fs2.interop.reactivestreams.package$.MODULE$.StreamOps(in.chunks().map((Function1 & Serializable & scala.Serializable)chunk -> ByteBuffer.wrap((byte[])chunk.toArray(ClassTag$.MODULE$.Byte())))).toUnicastPublisher($this.evidence$1), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)publisher -> {
            Tuple2 tuple2;
            Tuple2<String, String> tuple22 = AzureStore$.MODULE$.blobstore$azure$AzureStore$$urlToContainerAndBlob(url);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            String container = (String)tuple22._1();
            String blobName = (String)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)container, (Object)blobName);
            Tuple2 tuple24 = tuple23;
            String container2 = (String)tuple24._1();
            String blobName2 = (String)tuple24._2();
            BlobAsyncClient blobClient = $this.azure.getBlobContainerAsyncClient(container2).getBlobAsyncClient(blobName2);
            Flux flux = Flux.from((Publisher)publisher);
            ParallelTransferOptions pto = new ParallelTransferOptions().setBlockSizeLong(Predef$.MODULE$.long2Long((long)$this.blockSize)).setMaxConcurrency(Predef$.MODULE$.int2Integer(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper($this.numBuffers), 2)));
            Tuple2 tuple25 = tuple2 = overwrite ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Mono.empty()), null) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)blobClient.exists().flatMap(exists -> Predef$.MODULE$.Boolean2boolean(exists) ? Mono.error((Throwable)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob.")) : Mono.empty())), (Object)new BlobRequestConditions().setIfNoneMatch("*"));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Mono overwriteCheck = (Mono)tuple2._1();
            BlobRequestConditions requestConditions = (BlobRequestConditions)tuple2._2();
            Tuple2 tuple26 = new Tuple2((Object)overwriteCheck, (Object)requestConditions);
            Tuple2 tuple27 = tuple26;
            Mono overwriteCheck2 = (Mono)tuple27._1();
            BlobRequestConditions requestConditions2 = (BlobRequestConditions)tuple27._2();
            Option headers = properties.map((Function1 & Serializable & scala.Serializable)bip -> AzureStore$.MODULE$.blobstore$azure$AzureStore$$toHeaders((BlobItemProperties)bip));
            Mono upload = overwriteCheck2.then(blobClient.uploadWithResponse(flux, pto, (BlobHttpHeaders)headers.orNull(Predef$.MODULE$.$conforms()), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)meta).asJava(), (AccessTier)properties.flatMap((Function1 & Serializable & scala.Serializable)bip -> Option$.MODULE$.apply((Object)bip.getAccessTier())).orNull(Predef$.MODULE$.$conforms()), requestConditions2)).flatMap(resp -> FluxUtil.toMono((Response)resp));
            return Stream$.MODULE$.eval(package.all$.MODULE$.toFunctorOps(cats.effect.package$.MODULE$.Async().apply($this.evidence$1).fromCompletableFuture(cats.effect.package$.MODULE$.Async().apply($this.evidence$1).delay((Function0 & Serializable & scala.Serializable)() -> upload.toFuture())), $this.evidence$1).void());
        }, NotGiven$.MODULE$.default());
    }

    public <A> boolean put$default$2() {
        return true;
    }

    public <A> Option<Object> put$default$3() {
        return None$.MODULE$;
    }

    public <A, B> F move(Url<A> src, Url<B> dst) {
        return (F)FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.copy(src, dst), this.evidence$1), (Function0 & Serializable & scala.Serializable)() -> this.remove(src, true), this.evidence$1);
    }

    public <A, B> F copy(Url<A> src, Url<B> dst) {
        Tuple2<String, String> tuple2 = AzureStore$.MODULE$.blobstore$azure$AzureStore$$urlToContainerAndBlob(src);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String srcContainer = (String)tuple2._1();
        String srcBlob = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)srcContainer, (Object)srcBlob);
        Tuple2 tuple23 = tuple22;
        String srcContainer2 = (String)tuple23._1();
        String srcBlob2 = (String)tuple23._2();
        Tuple2<String, String> tuple24 = AzureStore$.MODULE$.blobstore$azure$AzureStore$$urlToContainerAndBlob(dst);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        String dstContainer = (String)tuple24._1();
        String dstBlob = (String)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)dstContainer, (Object)dstBlob);
        Tuple2 tuple26 = tuple25;
        String dstContainer2 = (String)tuple26._1();
        String dstBlob2 = (String)tuple26._2();
        String srcUrl = this.azure.getBlobContainerAsyncClient(srcContainer2).getBlobAsyncClient(srcBlob2).getBlobUrl();
        BlobAsyncClient blobClient = this.azure.getBlobContainerAsyncClient(dstContainer2).getBlobAsyncClient(dstBlob2);
        PollerFlux copy = blobClient.beginCopy(srcUrl, Duration.of(1L, ChronoUnit.SECONDS));
        return (F)package.all$.MODULE$.toFunctorOps(cats.effect.package$.MODULE$.Async().apply(this.evidence$1).fromCompletableFuture(cats.effect.package$.MODULE$.Async().apply(this.evidence$1).delay((Function0 & Serializable & scala.Serializable)() -> copy.next().flatMap(x$6 -> x$6.getFinalResult()).toFuture())), this.evidence$1).void();
    }

    public <A> F remove(Url<A> url, boolean recursive) {
        Mono mono;
        Tuple2<String, String> tuple2 = AzureStore$.MODULE$.blobstore$azure$AzureStore$$urlToContainerAndBlob(url);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String container = (String)tuple2._1();
        String blobOrPrefix = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)container, (Object)blobOrPrefix);
        Tuple2 tuple23 = tuple22;
        String container2 = (String)tuple23._1();
        String blobOrPrefix2 = (String)tuple23._2();
        BlobContainerAsyncClient containerClient = this.azure.getBlobContainerAsyncClient(container2);
        if (recursive) {
            BlobBatchAsyncClient blobBatchClient = new BlobBatchClientBuilder(this.azure).buildAsyncClient();
            ListBlobsOptions opts = new ListBlobsOptions();
            ListBlobsOptions options = opts.setPrefix(blobOrPrefix2);
            mono = containerClient.listBlobs(options).buffer(256).flatMap((Function)new Function<List<BlobItem>, Flux<Void>>(null, containerClient, blobBatchClient){
                private final BlobContainerAsyncClient containerClient$1;
                private final BlobBatchAsyncClient blobBatchClient$1;

                public <V> Function<V, Flux<Void>> compose(Function<? super V, ? extends List<BlobItem>> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<List<BlobItem>, V> andThen(Function<? super Flux<Void>, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public Flux<Void> apply(List<BlobItem> blobs) {
                    List urls = (List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(blobs).asScala()).map((Function1 & Serializable & scala.Serializable)b -> $this.containerClient$1.getBlobAsyncClient(b.getName()).getBlobUrl(), Buffer$.MODULE$.canBuildFrom())).asJava();
                    return this.blobBatchClient$1.deleteBlobs(urls, DeleteSnapshotsOptionType.INCLUDE).map(x$8 -> (Void)x$8.getValue());
                }
                {
                    this.containerClient$1 = containerClient$1;
                    this.blobBatchClient$1 = blobBatchClient$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1(blobstore.azure.AzureStore$$anon$2 com.azure.storage.blob.models.BlobItem )}, serializedLambda);
                }
            }).ignoreElements();
        } else {
            mono = AzureStore.recoverNotFound$1(containerClient.getBlobAsyncClient(blobOrPrefix2).delete());
        }
        Mono mono2 = mono;
        return (F)package.all$.MODULE$.toFunctorOps(cats.effect.package$.MODULE$.Async().apply(this.evidence$1).fromCompletableFuture(cats.effect.package$.MODULE$.Async().apply(this.evidence$1).delay((Function0 & Serializable & scala.Serializable)() -> mono2.toFuture())), this.evidence$1).void();
    }

    public <A> boolean remove$default$2() {
        return false;
    }

    public <A> Function1<Stream<F, Object>, Stream<F, BoxedUnit>> putRotate(F computeUrl, long limit) {
        Resource openNewFile = cats.effect.package$.MODULE$.Resource().eval(computeUrl).flatMap((Function1 & Serializable & scala.Serializable)computed -> {
            Tuple2<String, String> tuple2 = AzureStore$.MODULE$.blobstore$azure$AzureStore$$urlToContainerAndBlob(computed);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String container = (String)tuple2._1();
            String blob = (String)tuple2._2();
            Tuple3 tuple3 = new Tuple3(tuple2, (Object)container, (Object)blob);
            Tuple3 tuple32 = tuple3;
            Tuple2 tuple22 = (Tuple2)tuple32._1();
            String container2 = (String)tuple32._2();
            String blob2 = (String)tuple32._3();
            return cats.effect.package$.MODULE$.Resource().eval(Queue$.MODULE$.bounded($this.queueSize, $this.evidence$1)).flatMap((Function1 & Serializable & scala.Serializable)queue -> fs2.interop.reactivestreams.package$.MODULE$.StreamOps(Stream$.MODULE$.fromQueueNoneTerminated(queue, Stream$.MODULE$.fromQueueNoneTerminated$default$2(), $this.evidence$1)).toUnicastPublisher($this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)publisher -> {
                BlobAsyncClient blobClient = $this.azure.getBlobContainerAsyncClient(container2).getBlobAsyncClient(blob2);
                ParallelTransferOptions pto = new ParallelTransferOptions().setBlockSizeLong(Predef$.MODULE$.long2Long((long)$this.blockSize)).setMaxConcurrency(Predef$.MODULE$.int2Integer(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper($this.numBuffers), 2)));
                Flux flux = Flux.from((Publisher)publisher);
                Mono upload = blobClient.upload(flux, pto, true);
                return cats.effect.package$.MODULE$.Resource().make(cats.effect.package$.MODULE$.Async().apply($this.evidence$1).start(package.all$.MODULE$.toFunctorOps(cats.effect.package$.MODULE$.Async().apply($this.evidence$1).fromCompletableFuture(cats.effect.package$.MODULE$.Async().apply($this.evidence$1).delay((Function0 & Serializable & scala.Serializable)() -> upload.toFuture())), $this.evidence$1).void()), (Function1 & Serializable & scala.Serializable)x$9 -> package.all$.MODULE$.toFlatMapOps(x$9.join(), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> x$10.fold((Function0 & Serializable & scala.Serializable)() -> cats.effect.package$.MODULE$.Async().apply($this.evidence$1).unit(), (Function1 & Serializable & scala.Serializable)e -> cats.effect.package$.MODULE$.Async().apply($this.evidence$1).raiseError(e), (Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x))), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)_2 -> cats.effect.package$.MODULE$.Resource().make(cats.effect.package$.MODULE$.Async().apply($this.evidence$1).unit(), (Function1 & Serializable & scala.Serializable)x$11 -> queue.offer((Object)None$.MODULE$), $this.evidence$1).map((Function1 & Serializable & scala.Serializable)_ -> queue));
            }));
        });
        return package$.MODULE$.putRotateBase(limit, openNewFile, (Function1 & Serializable & scala.Serializable)queue -> (Function1 & Serializable & scala.Serializable)bytes -> queue.offer((Object)new Some((Object)ByteBuffer.wrap((byte[])bytes.toArray(ClassTag$.MODULE$.Byte())))), this.evidence$1);
    }

    public <A> Stream<F, Url<AzureBlob>> stat(Url<A> url) {
        Tuple2<String, String> tuple2 = AzureStore$.MODULE$.blobstore$azure$AzureStore$$urlToContainerAndBlob(url);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String container = (String)tuple2._1();
        String blobName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)container, (Object)blobName);
        Tuple2 tuple23 = tuple22;
        String container2 = (String)tuple23._1();
        String blobName2 = (String)tuple23._2();
        Mono mono = this.azure.getBlobContainerAsyncClient(container2).getBlobAsyncClient(blobName2).getProperties();
        return Stream.OptionStreamOps$.MODULE$.unNone$extension(Stream$.MODULE$.OptionStreamOps(Stream$.MODULE$.eval(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(cats.effect.package$.MODULE$.Async().apply(this.evidence$1).fromCompletableFuture(cats.effect.package$.MODULE$.Async().apply(this.evidence$1).delay((Function0 & Serializable & scala.Serializable)() -> mono.toFuture())), this.evidence$1), this.evidence$1)).evalMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            Left left = null;
            Either either = x0$1;
            if (either instanceof Right) {
                Right right = (Right)either;
                BlobProperties props = (BlobProperties)right.value();
                Tuple2<BlobItemProperties, scala.collection.immutable.Map<String, String>> tuple2 = AzureStore$.MODULE$.blobstore$azure$AzureStore$$toBlobItemProperties(props);
                if (tuple2 == null) throw new MatchError(tuple2);
                BlobItemProperties bip = (BlobItemProperties)tuple2._1();
                scala.collection.immutable.Map meta = (scala.collection.immutable.Map)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)bip, (Object)meta);
                Tuple2 tuple23 = tuple22;
                BlobItemProperties bip2 = (BlobItemProperties)tuple23._1();
                scala.collection.immutable.Map meta2 = (scala.collection.immutable.Map)tuple23._2();
                Path path = Path$.MODULE$.of(blobName2, (Object)new AzureBlob(container2, blobName2, (Option<BlobItemProperties>)OptionIdOps$.MODULE$.some$extension(package.all$.MODULE$.catsSyntaxOptionId((Object)bip2)), (scala.collection.immutable.Map<String, String>)meta2));
                return ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)OptionIdOps$.MODULE$.some$extension(package.all$.MODULE$.catsSyntaxOptionId((Object)url.withPath(path)))), $this.evidence$1);
            }
            if (either instanceof Left) {
                BlobStorageException blobStorageException;
                bl = true;
                left = (Left)either;
                Throwable e = (Throwable)left.value();
                if (e instanceof BlobStorageException && (blobStorageException = (BlobStorageException)e).getStatusCode() == 404) {
                    return ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)package.all$.MODULE$.none()), $this.evidence$1);
                }
            }
            if (!bl) throw new MatchError((Object)either);
            Throwable e = (Throwable)left.value();
            return ApplicativeErrorIdOps$.MODULE$.raiseError$extension(package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)e), $this.evidence$1);
        })));
    }

    public <A> Stream<F, Url<AzureBlob>> listUnderlying(Url<A> url, boolean fullMetadata, boolean expectTrailingSlashFiles, boolean recursive) {
        Tuple2<String, String> tuple2 = AzureStore$.MODULE$.blobstore$azure$AzureStore$$urlToContainerAndBlob(url);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String container = (String)tuple2._1();
        String blobName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)container, (Object)blobName);
        Tuple2 tuple23 = tuple22;
        String container2 = (String)tuple23._1();
        String blobName2 = (String)tuple23._2();
        String string = blobName2;
        String string2 = "/";
        ListBlobsOptions options = new ListBlobsOptions().setPrefix(!(string != null ? !string.equals(string2) : string2 != null) ? "" : blobName2).setDetails(new BlobListDetails().setRetrieveMetadata(fullMetadata));
        BlobContainerAsyncClient containerClient = this.azure.getBlobContainerAsyncClient(container2);
        PagedFlux blobPagedFlux = recursive ? containerClient.listBlobs(options) : containerClient.listBlobsByHierarchy("/", options);
        Flux flux = blobPagedFlux.filter(bi -> Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)bi.isDeleted())).forall((Function1 & Serializable & scala.Serializable)deleted -> BoxesRunTime.boxToBoolean((boolean)AzureStore.$anonfun$listUnderlying$2(BoxesRunTime.unboxToBoolean((Object)deleted))))).flatMap(AzureStore$.MODULE$.blobstore$azure$AzureStore$$blobItemToPath(containerClient, expectTrailingSlashFiles, container2)).map((Function)new Function<Path<AzureBlob>, Url<AzureBlob>>(null, url){
            private final Url url$3;

            public <V> Function<V, Url<AzureBlob>> compose(Function<? super V, ? extends Path<AzureBlob>> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<Path<AzureBlob>, V> andThen(Function<? super Url<AzureBlob>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Url<AzureBlob> apply(Path<AzureBlob> p) {
                Path<AzureBlob> x$1 = p;
                String x$2 = this.url$3.copy$default$1();
                Authority x$3 = this.url$3.copy$default$2();
                return this.url$3.copy(x$2, x$3, x$1);
            }
            {
                this.url$3 = url$3;
            }
        });
        return fs2.interop.reactivestreams.package$.MODULE$.fromPublisher((Publisher)flux, this.evidence$1);
    }

    private static final Mono recoverNotFound$1(Mono m) {
        return m.onErrorResume(t -> {
            BlobStorageException blobStorageException;
            Throwable throwable = t;
            boolean bl = throwable instanceof BlobStorageException ? (blobStorageException = (BlobStorageException)throwable).getStatusCode() == 404 : false;
            return bl;
        }, (Function)new Function<Throwable, Mono<Void>>(null){

            public <V> Function<V, Mono<Void>> compose(Function<? super V, ? extends Throwable> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<Throwable, V> andThen(Function<? super Mono<Void>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Mono<Void> apply(Throwable t) {
                return Mono.empty();
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$listUnderlying$2(boolean deleted) {
        return !deleted;
    }

    public AzureStore(BlobServiceAsyncClient azure, boolean defaultFullMetadata, boolean defaultTrailingSlashFiles, int blockSize, int numBuffers, int queueSize, Async<F> evidence$1) {
        this.azure = azure;
        this.defaultFullMetadata = defaultFullMetadata;
        this.defaultTrailingSlashFiles = defaultTrailingSlashFiles;
        this.blockSize = blockSize;
        this.numBuffers = numBuffers;
        this.queueSize = queueSize;
        this.evidence$1 = evidence$1;
    }
}

