/*
 * Decompiled with CFR 0.152.
 */
package blobstore.gcs;

import blobstore.Path;
import blobstore.Store;
import blobstore.gcs.GcsStore$;
import cats.effect.Blocker$;
import cats.effect.ContextShift;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import com.google.api.gax.paging.Page;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import fs2.io.package$;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.time.Instant;
import java.util.Date;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\n\u0015\u0005eA\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"A\u0001\n\u0001B\u0001B\u0003%\u0011\n\u0003\u0005Y\u0001\t\u0005\t\u0015a\u0003Z\u0011!a\u0006A!A!\u0002\u0017i\u0006\"\u00021\u0001\t\u0003\t\u0007\"\u00026\u0001\t\u0013Y\u0007bBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!a\u0013\u0001\t\u0003\ti\u0005C\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d\u001d9\u0011q\r\u000b\t\u0002\u0005%dAB\n\u0015\u0011\u0003\tY\u0007\u0003\u0004a\u001f\u0011\u0005\u0011Q\u000e\u0005\b\u0003_zA\u0011AA9\u0011%\tyiDI\u0001\n\u0003\t\tJ\u0001\u0005HGN\u001cFo\u001c:f\u0015\t)b#A\u0002hGNT\u0011aF\u0001\nE2|'m\u001d;pe\u0016\u001c\u0001!\u0006\u0002\u001bOM\u0019\u0001aG\u0011\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\r\u00113%J\u0007\u0002-%\u0011AE\u0006\u0002\u0006'R|'/\u001a\t\u0003M\u001db\u0001\u0001B\u0003)\u0001\t\u0007\u0011FA\u0001G+\tQ\u0013'\u0005\u0002,]A\u0011A\u0004L\u0005\u0003[u\u0011qAT8uQ&tw\r\u0005\u0002\u001d_%\u0011\u0001'\b\u0002\u0004\u0003:LH!\u0002\u001a(\u0005\u0004Q#!A0\u0002\u000fM$xN]1hKB\u0011Q'P\u0007\u0002m)\u00111g\u000e\u0006\u0003qe\nQa\u00197pk\u0012T!AO\u001e\u0002\r\u001d|wn\u001a7f\u0015\u0005a\u0014aA2p[&\u0011aH\u000e\u0002\b'R|'/Y4f\u0003\u001d\u0011Gn\\2lKJ\u0004\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\r\u00154g-Z2u\u0015\u0005)\u0015\u0001B2biNL!a\u0012\"\u0003\u000f\tcwnY6fe\u0006!\u0011m\u00197t!\rQ%+\u0016\b\u0003\u0017Bs!\u0001T(\u000e\u00035S!A\u0014\r\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012BA)\u001e\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0015+\u0003\t1K7\u000f\u001e\u0006\u0003#v\u0001\"!\u000e,\n\u0005]3$aA!dY\u0006\ta\tE\u0002B5\u0016J!a\u0017\"\u0003\tMKhnY\u0001\u0003\u0007N\u00032!\u00110&\u0013\ty&I\u0001\u0007D_:$X\r\u001f;TQ&4G/\u0001\u0004=S:LGO\u0010\u000b\u0005E\u001eD\u0017\u000eF\u0002dK\u001a\u00042\u0001\u001a\u0001&\u001b\u0005!\u0002\"\u0002-\u0007\u0001\bI\u0006\"\u0002/\u0007\u0001\bi\u0006\"B\u001a\u0007\u0001\u0004!\u0004\"B \u0007\u0001\u0004\u0001\u0005b\u0002%\u0007!\u0003\u0005\r!S\u0001\u0007?\u000eDWO\\6\u0015\u00051,\bcA7qe6\taNC\u0001p\u0003\r17OM\u0005\u0003c:\u0014Qa\u00115v].\u0004\"AI:\n\u0005Q4\"\u0001\u0002)bi\"DQA^\u0004A\u0002]\f!\u0001]4\u0011\ta|\u00181A\u0007\u0002s*\u0011!p_\u0001\u0007a\u0006<\u0017N\\4\u000b\u0005ql\u0018aA4bq*\u0011a0O\u0001\u0004CBL\u0017bAA\u0001s\n!\u0001+Y4f!\r)\u0014QA\u0005\u0004\u0003\u000f1$\u0001\u0002\"m_\n\fA\u0001\\5tiR!\u0011QBA\n!\u0015i\u0017qB\u0013s\u0013\r\t\tB\u001c\u0002\u0007'R\u0014X-Y7\t\r\u0005U\u0001\u00021\u0001s\u0003\u0011\u0001\u0018\r\u001e5\u0002\u0007\u001d,G\u000f\u0006\u0004\u0002\u001c\u0005\r\u0012Q\u0005\t\u0007[\u0006=Q%!\b\u0011\u0007q\ty\"C\u0002\u0002\"u\u0011AAQ=uK\"1\u0011QC\u0005A\u0002IDq!a\n\n\u0001\u0004\tI#A\u0005dQVt7nU5{KB\u0019A$a\u000b\n\u0007\u00055RDA\u0002J]R\f1\u0001];u)\u0011\t\u0019$!\u0013\u0011\u0013\u0005U\u0012QH\u0013\u0002\u001e\u0005\rc\u0002BA\u001c\u0003wq1\u0001TA\u001d\u0013\u0005y\u0017BA)o\u0013\u0011\ty$!\u0011\u0003\tAK\u0007/\u001a\u0006\u0003#:\u00042\u0001HA#\u0013\r\t9%\b\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u0016)\u0001\rA]\u0001\u0005[>4X\r\u0006\u0004\u0002P\u0005E\u0013Q\u000b\t\u0005M\u001d\n\u0019\u0005\u0003\u0004\u0002T-\u0001\rA]\u0001\u0004gJ\u001c\u0007BBA,\u0017\u0001\u0007!/A\u0002egR\fAaY8qsR1\u0011qJA/\u0003?Ba!a\u0015\r\u0001\u0004\u0011\bBBA,\u0019\u0001\u0007!/\u0001\u0004sK6|g/\u001a\u000b\u0005\u0003\u001f\n)\u0007\u0003\u0004\u0002\u00165\u0001\rA]\u0001\t\u000f\u000e\u001c8\u000b^8sKB\u0011AmD\n\u0003\u001fm!\"!!\u001b\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u0005M\u00141\u0010\u000b\t\u0003k\nI)a#\u0002\u000eR1\u0011qOAA\u0003\u000b\u0003B\u0001\u001a\u0001\u0002zA\u0019a%a\u001f\u0005\r!\n\"\u0019AA?+\rQ\u0013q\u0010\u0003\u0007e\u0005m$\u0019\u0001\u0016\t\ra\u000b\u00029AAB!\u0011\t%,!\u001f\t\rq\u000b\u00029AAD!\u0011\te,!\u001f\t\u000bM\n\u0002\u0019\u0001\u001b\t\u000b}\n\u0002\u0019\u0001!\t\u000b!\u000b\u0002\u0019A%\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0011\t\u0019*!+\u0016\u0005\u0005U%fA%\u0002\u0018.\u0012\u0011\u0011\u0014\t\u0005\u00037\u000b)+\u0004\u0002\u0002\u001e*!\u0011qTAQ\u0003%)hn\u00195fG.,GMC\u0002\u0002$v\t!\"\u00198o_R\fG/[8o\u0013\u0011\t9+!(\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u0004)%\t\u0007\u00111V\u000b\u0004U\u00055FA\u0002\u001a\u0002*\n\u0007!\u0006")
public final class GcsStore<F>
implements Store<F> {
    private final Storage storage;
    private final ExecutionContext blocker;
    private final List<Acl> acls;
    private final Sync<F> F;
    private final ContextShift<F> CS;

    public static <F> List<Acl> $lessinit$greater$default$3() {
        return GcsStore$.MODULE$.$lessinit$greater$default$3();
    }

    public static <F> GcsStore<F> apply(Storage storage, ExecutionContext executionContext, List<Acl> list, Sync<F> sync, ContextShift<F> contextShift) {
        return GcsStore$.MODULE$.apply(storage, executionContext, list, sync, contextShift);
    }

    private Chunk<Path> _chunk(Page<Blob> pg) {
        Tuple2 tuple2 = ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(pg.getValues()).asScala()).toSeq().partition((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq dirs = (Seq)tuple2._1();
        Seq files = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)dirs, (Object)files);
        Tuple2 tuple23 = tuple22;
        Seq dirs2 = (Seq)tuple23._1();
        Seq files2 = (Seq)tuple23._2();
        Chunk dirPaths = Chunk$.MODULE$.seq((Seq)dirs2.map((Function1 & Serializable & scala.Serializable)b -> new Path(b.getBucket(), new StringOps(Predef$.MODULE$.augmentString(b.getName())).stripSuffix("/"), (Option)None$.MODULE$, true, (Option)None$.MODULE$), Seq$.MODULE$.canBuildFrom()));
        Chunk filePaths = Chunk$.MODULE$.seq((Seq)files2.map((Function1 & Serializable & scala.Serializable)b -> {
            Option size = Option$.MODULE$.apply((Object)b.getSize()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x$3)));
            Option lastModified = Option$.MODULE$.apply((Object)b.getUpdateTime()).map((Function1 & Serializable & scala.Serializable)millis -> Date.from(Instant.ofEpochMilli(Predef$.MODULE$.Long2long(millis))));
            return new Path(b.getBucket(), b.getName(), size, false, lastModified);
        }, Seq$.MODULE$.canBuildFrom()));
        return Chunk$.MODULE$.concat((Seq)new .colon.colon((Object)dirPaths, (List)new .colon.colon((Object)filePaths, (List)Nil$.MODULE$)));
    }

    public FreeC<F, Path, BoxedUnit> list(Path path) {
        return Stream$.MODULE$.unfoldChunkEval((Function0 & Serializable & scala.Serializable)() -> new Some((Object)$this.storage.list(path.root(), new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.prefix((String)path.key())})), (Function1 & Serializable & scala.Serializable)getPage -> Blocker$.MODULE$.delay$extension($this.blocker, (Function0 & Serializable & scala.Serializable)() -> ((Option)getPage.apply()).map((Function1 & Serializable & scala.Serializable)pg -> pg.hasNextPage() ? new Tuple2(this._chunk((Page<Blob>)pg), (Function0 & Serializable & scala.Serializable)() -> new Some((Object)pg.getNextPage())) : new Tuple2(this._chunk((Page<Blob>)pg), (Function0 & Serializable & scala.Serializable)() -> None$.MODULE$)), $this.F, $this.CS));
    }

    public FreeC<F, Object, BoxedUnit> get(Path path, int chunkSize) {
        Object is = Blocker$.MODULE$.delay$extension(this.blocker, (Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)$this.storage.get(path.root(), path.key(), new Storage.BlobGetOption[0])).map((Function1 & Serializable & scala.Serializable)blob -> Channels.newInputStream((ReadableByteChannel)blob.reader(new Blob.BlobSourceOption[0]))), this.F, this.CS);
        return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(is), (Function1 & Serializable & scala.Serializable)x0$1 -> new Stream(GcsStore.$anonfun$get$3(this, chunkSize, path, x0$1)));
    }

    public Function1<Stream<F, Object>, Stream<F, BoxedUnit>> put(Path path) {
        Object fos = Sync$.MODULE$.apply(this.F).delay((Function0 & Serializable & scala.Serializable)() -> {
            void var3_2;
            BlobInfo.Builder b = BlobInfo.newBuilder((String)path.root(), (String)path.key());
            void builder = $this.acls.nonEmpty() ? b.setAcl((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter($this.acls).asJava()) : var3_2;
            BlobInfo blobInfo = builder.build();
            WriteChannel writer = $this.storage.writer(blobInfo, new Storage.BlobWriteOption[0]);
            return Channels.newOutputStream((WritableByteChannel)writer);
        });
        return package$.MODULE$.writeOutputStream(fos, this.blocker, true, this.F, this.CS);
    }

    public F move(Path src, Path dst) {
        return (F)this.F.productR(this.copy(src, dst), this.remove(src));
    }

    public F copy(Path src, Path dst) {
        Storage.CopyRequest req = Storage.CopyRequest.newBuilder().setSource(src.root(), src.key()).setTarget(BlobId.of((String)dst.root(), (String)dst.key())).build();
        return (F)this.F.void(Blocker$.MODULE$.delay$extension(this.blocker, (Function0 & Serializable & scala.Serializable)() -> $this.storage.copy(req).getResult(), this.F, this.CS));
    }

    public F remove(Path path) {
        return (F)this.F.void(Blocker$.MODULE$.delay$extension(this.blocker, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> $this.storage.delete(path.root(), path.key(), new Storage.BlobSourceOption[0]), this.F, this.CS));
    }

    public static final /* synthetic */ FreeC $anonfun$get$3(GcsStore $this, int chunkSize$1, Path path$2, Option x0$1) {
        FreeC freeC;
        Option option = x0$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            InputStream is = (InputStream)some.value();
            freeC = package$.MODULE$.readInputStream(ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId((Object)is), $this.F), chunkSize$1, $this.blocker, true, $this.F, $this.CS);
        } else if (None$.MODULE$.equals(option)) {
            freeC = Stream$.MODULE$.raiseError((Throwable)new StorageException(404, new StringBuilder(18).append("Object not found, ").append(path$2).toString()), RaiseThrowable$.MODULE$.fromApplicativeError($this.F));
        } else {
            throw new MatchError((Object)option);
        }
        return freeC;
    }

    public GcsStore(Storage storage, ExecutionContext blocker, List<Acl> acls, Sync<F> F, ContextShift<F> CS) {
        this.storage = storage;
        this.blocker = blocker;
        this.acls = acls;
        this.F = F;
        this.CS = CS;
    }
}

