/*
 * Decompiled with CFR 0.152.
 */
package blobstore.gcs;

import blobstore.Path;
import blobstore.Store;
import blobstore.gcs.GcsPath;
import blobstore.gcs.GcsPath$;
import blobstore.gcs.GcsStore$;
import cats.effect.Blocker$;
import cats.effect.ContextShift;
import cats.effect.Sync;
import cats.instances.package;
import cats.syntax.ApplicativeErrorIdOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.google.api.gax.paging.Page;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import fs2.Chunk$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import fs2.io.package$;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.concurrent.ExecutionContext;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001B\f\u0019\u0005uA\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"AA\n\u0001B\u0001B\u0003%Q\n\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003^\u0011!\u0001\u0007A!A!\u0002\u0017\t\u0007\u0002\u00033\u0001\u0005\u0003\u0005\u000b1B3\t\u000b!\u0004A\u0011A5\t\u000bM\u0004A\u0011\t;\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001bBA\u001b\u0001\u0011\u0005\u0013q\u0007\u0005\b\u0003\u0007\u0002A\u0011IA#\u0011\u001d\tY\u0005\u0001C!\u0003\u001bBq!!\u0015\u0001\t\u0003\t\u0019fB\u0004\u0002daA\t!!\u001a\u0007\r]A\u0002\u0012AA4\u0011\u0019A\u0007\u0003\"\u0001\u0002j!9\u00111\u000e\t\u0005\u0002\u00055\u0004bBAF!\u0011%\u0011Q\u0012\u0005\b\u0003g\u0003B\u0011BA[\u0011%\t)\rEI\u0001\n\u0003\t9\rC\u0005\u0002fB\t\n\u0011\"\u0001\u0002h\nAqiY:Ti>\u0014XM\u0003\u0002\u001a5\u0005\u0019qmY:\u000b\u0003m\t\u0011B\u00197pEN$xN]3\u0004\u0001U\u0011adK\n\u0004\u0001})\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\rE\u0002'O%j\u0011AG\u0005\u0003Qi\u0011Qa\u0015;pe\u0016\u0004\"AK\u0016\r\u0001\u0011)A\u0006\u0001b\u0001[\t\ta)\u0006\u0002/kE\u0011qF\r\t\u0003AAJ!!M\u0011\u0003\u000f9{G\u000f[5oOB\u0011\u0001eM\u0005\u0003i\u0005\u00121!\u00118z\t\u001514F1\u0001/\u0005\u0005y\u0016aB:u_J\fw-\u001a\t\u0003s\u0005k\u0011A\u000f\u0006\u0003omR!\u0001P\u001f\u0002\u000b\rdw.\u001e3\u000b\u0005yz\u0014AB4p_\u001edWMC\u0001A\u0003\r\u0019w.\\\u0005\u0003\u0005j\u0012qa\u0015;pe\u0006<W-A\u0004cY>\u001c7.\u001a:\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015AB3gM\u0016\u001cGOC\u0001J\u0003\u0011\u0019\u0017\r^:\n\u0005-3%a\u0002\"m_\u000e\\WM]\u0001\u0005C\u000ed7\u000fE\u0002O-fs!a\u0014+\u000f\u0005A\u001bV\"A)\u000b\u0005Ic\u0012A\u0002\u001fs_>$h(C\u0001#\u0013\t)\u0016%A\u0004qC\u000e\\\u0017mZ3\n\u0005]C&\u0001\u0002'jgRT!!V\u0011\u0011\u0005eR\u0016BA.;\u0005\r\t5\r\\\u0001\u001aI\u00164\u0017-\u001e7u)J\f\u0017\u000e\\5oONc\u0017m\u001d5GS2,7\u000f\u0005\u0002!=&\u0011q,\t\u0002\b\u0005>|G.Z1o\u0003\u00051\u0005cA#cS%\u00111M\u0012\u0002\u0005'ft7-\u0001\u0002D'B\u0019QIZ\u0015\n\u0005\u001d4%\u0001D\"p]R,\u0007\u0010^*iS\u001a$\u0018A\u0002\u001fj]&$h\bF\u0003k_B\f(\u000fF\u0002l[:\u00042\u0001\u001c\u0001*\u001b\u0005A\u0002\"\u00021\b\u0001\b\t\u0007\"\u00023\b\u0001\b)\u0007\"B\u001c\b\u0001\u0004A\u0004\"B\"\b\u0001\u0004!\u0005b\u0002'\b!\u0003\u0005\r!\u0014\u0005\b9\u001e\u0001\n\u00111\u0001^\u0003\u0011a\u0017n\u001d;\u0015\u0005Ut\b\u0003\u0002<zSml\u0011a\u001e\u0006\u0002q\u0006\u0019am\u001d\u001a\n\u0005i<(AB*ue\u0016\fW\u000e\u0005\u0002'y&\u0011QP\u0007\u0002\u0005!\u0006$\b\u000eC\u0003\u0000\u0011\u0001\u000710\u0001\u0003qCRD\u0017aA4fiR1\u0011QAA\u0007\u0003\u001f\u0001RA^=*\u0003\u000f\u00012\u0001IA\u0005\u0013\r\tY!\t\u0002\u0005\u0005f$X\rC\u0003\u0000\u0013\u0001\u00071\u0010C\u0004\u0002\u0012%\u0001\r!a\u0005\u0002\u0013\rDWO\\6TSj,\u0007c\u0001\u0011\u0002\u0016%\u0019\u0011qC\u0011\u0003\u0007%sG/A\u0002qkR$B!!\b\u00024AI\u0011qDA\u0014S\u0005\u001d\u0011Q\u0006\b\u0005\u0003C\t)CD\u0002Q\u0003GI\u0011\u0001_\u0005\u0003+^LA!!\u000b\u0002,\t!\u0001+\u001b9f\u0015\t)v\u000fE\u0002!\u0003_I1!!\r\"\u0005\u0011)f.\u001b;\t\u000b}T\u0001\u0019A>\u0002\t5|g/\u001a\u000b\u0007\u0003s\tY$a\u0010\u0011\t)Z\u0013Q\u0006\u0005\u0007\u0003{Y\u0001\u0019A>\u0002\u0007M\u00148\r\u0003\u0004\u0002B-\u0001\ra_\u0001\u0004IN$\u0018\u0001B2paf$b!!\u000f\u0002H\u0005%\u0003BBA\u001f\u0019\u0001\u00071\u0010\u0003\u0004\u0002B1\u0001\ra_\u0001\u0007e\u0016lwN^3\u0015\t\u0005e\u0012q\n\u0005\u0006\u007f6\u0001\ra_\u0001\u000fY&\u001cH/\u00168eKJd\u00170\u001b8h)\u0019\t)&!\u0018\u0002`A)a/_\u0015\u0002XA\u0019A.!\u0017\n\u0007\u0005m\u0003DA\u0004HGN\u0004\u0016\r\u001e5\t\u000b}t\u0001\u0019A>\t\r\u0005\u0005d\u00021\u0001^\u0003a)\u0007\u0010]3diR\u0013\u0018-\u001b7j]\u001e\u001cF.Y:i\r&dWm]\u0001\t\u000f\u000e\u001c8\u000b^8sKB\u0011A\u000eE\n\u0003!}!\"!!\u001a\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u0005=\u0014q\u000f\u000b\t\u0003c\n))a\"\u0002\nR1\u00111OA?\u0003\u0003\u0003B\u0001\u001c\u0001\u0002vA\u0019!&a\u001e\u0005\r1\u0012\"\u0019AA=+\rq\u00131\u0010\u0003\u0007m\u0005]$\u0019\u0001\u0018\t\r\u0001\u0014\u00029AA@!\u0011)%-!\u001e\t\r\u0011\u0014\u00029AAB!\u0011)e-!\u001e\t\u000b]\u0012\u0002\u0019\u0001\u001d\t\u000b\r\u0013\u0002\u0019\u0001#\t\u000b1\u0013\u0002\u0019A'\u0002!5L7o]5oOJ{w\u000e^#se>\u0014H\u0003BAH\u0003?\u0003B!!%\u0002\u001c6\u0011\u00111\u0013\u0006\u0005\u0003+\u000b9*\u0001\u0003mC:<'BAAM\u0003\u0011Q\u0017M^1\n\t\u0005u\u00151\u0013\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t\u0007bBAQ'\u0001\u0007\u00111U\u0001\u0004[N<\u0007\u0003BAS\u0003[sA!a*\u0002*B\u0011\u0001+I\u0005\u0004\u0003W\u000b\u0013A\u0002)sK\u0012,g-\u0003\u0003\u00020\u0006E&AB*ue&twMC\u0002\u0002,\u0006\nA\u0002]1uQR{'\t\\8c\u0013\u0012$B!a.\u0002DB)\u0001%!/\u0002>&\u0019\u00111X\u0011\u0003\r=\u0003H/[8o!\rI\u0014qX\u0005\u0004\u0003\u0003T$A\u0002\"m_\nLE\rC\u0003\u0000)\u0001\u000710A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0005\u0003\u0013\fy.\u0006\u0002\u0002L*\u001aQ*!4,\u0005\u0005=\u0007\u0003BAi\u00037l!!a5\u000b\t\u0005U\u0017q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!7\"\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003;\f\u0019NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$a\u0001L\u000bC\u0002\u0005\u0005Xc\u0001\u0018\u0002d\u00121a'a8C\u00029\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T\u0003BAu\u0003[,\"!a;+\u0007u\u000bi\r\u0002\u0004--\t\u0007\u0011q^\u000b\u0004]\u0005EHA\u0002\u001c\u0002n\n\u0007a\u0006")
public final class GcsStore<F>
implements Store<F> {
    private final Storage storage;
    private final ExecutionContext blocker;
    private final List<Acl> acls;
    private final boolean defaultTrailingSlashFiles;
    private final Sync<F> F;
    private final ContextShift<F> CS;

    public static <F> boolean $lessinit$greater$default$4() {
        return GcsStore$.MODULE$.$lessinit$greater$default$4();
    }

    public static <F> List<Acl> $lessinit$greater$default$3() {
        return GcsStore$.MODULE$.$lessinit$greater$default$3();
    }

    public static <F> GcsStore<F> apply(Storage storage, ExecutionContext executionContext, List<Acl> list, Sync<F> sync, ContextShift<F> contextShift) {
        return GcsStore$.MODULE$.apply(storage, executionContext, list, sync, contextShift);
    }

    public FreeC<F, Path, BoxedUnit> list(Path path) {
        return this.listUnderlying(path, this.defaultTrailingSlashFiles);
    }

    public FreeC<F, Object, BoxedUnit> get(Path path, int chunkSize) {
        FreeC freeC;
        Option<BlobId> option = GcsStore$.MODULE$.blobstore$gcs$GcsStore$$pathToBlobId(path);
        if (None$.MODULE$.equals(option)) {
            freeC = Stream$.MODULE$.raiseError((Throwable)GcsStore$.MODULE$.blobstore$gcs$GcsStore$$missingRootError(new StringBuilder(17).append("Unable to read '").append(path).append("'").toString()), RaiseThrowable$.MODULE$.fromApplicativeError(this.F));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            BlobId blobId = (BlobId)some.value();
            Object fis = Blocker$.MODULE$.delay$extension(this.blocker, (Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)$this.storage.get(blobId)).map((Function1 & Serializable & scala.Serializable)blob -> Channels.newInputStream((ReadableByteChannel)blob.reader(new Blob.BlobSourceOption[0]))), this.F, this.CS);
            freeC = Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(fis), (Function1 & Serializable & scala.Serializable)x0$1 -> new Stream(GcsStore.$anonfun$get$3(this, chunkSize, path, x0$1)));
        } else {
            throw new MatchError(option);
        }
        return freeC;
    }

    public Function1<Stream<F, Object>, Stream<F, BoxedUnit>> put(Path path) {
        Function1 function1;
        Option<BlobId> option = GcsStore$.MODULE$.blobstore$gcs$GcsStore$$pathToBlobId(path);
        if (None$.MODULE$.equals(option)) {
            function1 = x$1 -> new Stream(Stream$.MODULE$.raiseError((Throwable)GcsStore$.MODULE$.blobstore$gcs$GcsStore$$missingRootError(new StringBuilder(21).append("Unable to write to '").append(path).append("'").toString()), RaiseThrowable$.MODULE$.fromApplicativeError(this.F)));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            BlobId blobId = (BlobId)some.value();
            Object fos = this.F.delay((Function0 & Serializable & scala.Serializable)() -> {
                BlobInfo blobInfo = (BlobInfo)GcsPath$.MODULE$.narrow(path).fold((Function0 & Serializable & scala.Serializable)() -> {
                    BlobInfo.Builder b = BlobInfo.newBuilder((BlobId)blobId);
                    return ($this.acls.nonEmpty() ? b.setAcl((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter($this.acls).asJava()) : b).build();
                }, (Function1 & Serializable & scala.Serializable)x$2 -> x$2.blobInfo());
                WriteChannel writer = $this.storage.writer(blobInfo, new Storage.BlobWriteOption[0]);
                return Channels.newOutputStream((WritableByteChannel)writer);
            });
            function1 = package$.MODULE$.writeOutputStream(fos, this.blocker, true, this.F, this.CS);
        } else {
            throw new MatchError(option);
        }
        return function1;
    }

    public F move(Path src, Path dst) {
        return (F)package.all$.MODULE$.catsSyntaxApply(this.copy(src, dst), this.F).$times$greater(this.remove(src));
    }

    public F copy(Path src, Path dst) {
        return (F)package.all$.MODULE$.toFlatMapOps(GcsStore$.MODULE$.blobstore$gcs$GcsStore$$pathToBlobId(src).fold((Function0 & Serializable & scala.Serializable)() -> ApplicativeErrorIdOps$.MODULE$.raiseError$extension(package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)GcsStore$.MODULE$.blobstore$gcs$GcsStore$$missingRootError(new StringBuilder(12).append("Wrong src '").append(src).append("'").toString())), $this.F), (Function1 & Serializable & scala.Serializable)x$3 -> ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId(x$3), $this.F)), this.F).flatMap((Function1 & Serializable & scala.Serializable)srcBlobId -> package.all$.MODULE$.toFlatMapOps(GcsStore$.MODULE$.blobstore$gcs$GcsStore$$pathToBlobId(dst).fold((Function0 & Serializable & scala.Serializable)() -> ApplicativeErrorIdOps$.MODULE$.raiseError$extension(package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)GcsStore$.MODULE$.blobstore$gcs$GcsStore$$missingRootError(new StringBuilder(12).append("Wrong dst '").append(dst).append("'").toString())), $this.F), (Function1 & Serializable & scala.Serializable)x$4 -> ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId(x$4), $this.F)), $this.F).flatMap((Function1 & Serializable & scala.Serializable)dstBlobId -> package.all$.MODULE$.toFunctorOps(Blocker$.MODULE$.delay$extension($this.blocker, (Function0 & Serializable & scala.Serializable)() -> $this.storage.copy(Storage.CopyRequest.of((BlobId)srcBlobId, (BlobId)dstBlobId)).getResult(), $this.F, $this.CS), $this.F).map((Function1 & Serializable & scala.Serializable)_ -> {
            GcsStore.$anonfun$copy$8(_);
            return BoxedUnit.UNIT;
        })));
    }

    public F remove(Path path) {
        Object object;
        Option<BlobId> option = GcsStore$.MODULE$.blobstore$gcs$GcsStore$$pathToBlobId(path);
        if (option instanceof Some) {
            Some some = (Some)option;
            BlobId blobId = (BlobId)some.value();
            object = package.all$.MODULE$.toFunctorOps(Blocker$.MODULE$.delay$extension(this.blocker, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> $this.storage.delete(blobId), this.F, this.CS), this.F).void();
        } else if (None$.MODULE$.equals(option)) {
            object = ApplicativeErrorIdOps$.MODULE$.raiseError$extension(package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)GcsStore$.MODULE$.blobstore$gcs$GcsStore$$missingRootError(new StringBuilder(19).append("Unable to remove '").append(path).append("'").toString())), this.F);
        } else {
            throw new MatchError(option);
        }
        return (F)object;
    }

    public FreeC<F, GcsPath, BoxedUnit> listUnderlying(Path path, boolean expectTrailingSlashFiles) {
        FreeC freeC;
        Option<BlobId> option = GcsStore$.MODULE$.blobstore$gcs$GcsStore$$pathToBlobId(path);
        if (None$.MODULE$.equals(option)) {
            freeC = Stream$.MODULE$.raiseError((Throwable)GcsStore$.MODULE$.blobstore$gcs$GcsStore$$missingRootError(new StringBuilder(17).append("Unable to list '").append(path).append("'").toString()), RaiseThrowable$.MODULE$.fromApplicativeError(this.F));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            BlobId blobId = (BlobId)some.value();
            freeC = Stream$.MODULE$.unfoldChunkEval((Function0 & Serializable & scala.Serializable)() -> {
                Storage.BlobListOption[] blobListOptionArray = new Storage.BlobListOption[2];
                blobListOptionArray[0] = Storage.BlobListOption.currentDirectory();
                String string = blobId.getName();
                String string2 = "/";
                blobListOptionArray[1] = Storage.BlobListOption.prefix((String)(!(string != null ? !string.equals(string2) : string2 != null) ? "" : blobId.getName()));
                return new Some((Object)$this.storage.list(blobId.getBucket(), blobListOptionArray));
            }, (Function1 & Serializable & scala.Serializable)getPage -> package.all$.MODULE$.toFlatMapOps(Blocker$.MODULE$.delay$extension($this.blocker, getPage, $this.F, $this.CS), $this.F).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Object object;
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    object = ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)package.all$.MODULE$.none()), $this.F);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    Page page = (Page)some.value();
                    object = package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toTraverseOps((Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(page.getValues()).asScala()).toList(), package.list$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Blob blob = x0$2;
                        Object object = blob.isDirectory() ? (expectTrailingSlashFiles ? Blocker$.MODULE$.delay$extension($this.blocker, (Function0 & Serializable & scala.Serializable)() -> (Blob)Option$.MODULE$.apply((Object)$this.storage.get(blob.getBlobId())).getOrElse((Function0 & Serializable & scala.Serializable)() -> blob), $this.F, $this.CS) : ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)blob), $this.F)) : ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)blob), $this.F);
                        return object;
                    }, $this.F), $this.F).map((Function1 & Serializable & scala.Serializable)paths -> OptionIdOps$.MODULE$.some$extension(package.all$.MODULE$.catsSyntaxOptionId((Object)new Tuple2((Object)Chunk$.MODULE$.seq((Seq)paths.map((Function1 & Serializable & scala.Serializable)blob -> new GcsPath(blob.toBuilder().build()), List$.MODULE$.canBuildFrom())), (Function0 & Serializable & scala.Serializable)() -> page.hasNextPage() ? new Some((Object)page.getNextPage()) : None$.MODULE$))));
                } else {
                    throw new MatchError((Object)option);
                }
                return object;
            }));
        } else {
            throw new MatchError(option);
        }
        return freeC;
    }

    public static final /* synthetic */ FreeC $anonfun$get$3(GcsStore $this, int chunkSize$1, Path path$1, Option x0$1) {
        FreeC freeC;
        Option option = x0$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            InputStream is = (InputStream)some.value();
            freeC = package$.MODULE$.readInputStream(ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)is), $this.F), chunkSize$1, $this.blocker, true, $this.F, $this.CS);
        } else if (None$.MODULE$.equals(option)) {
            freeC = Stream$.MODULE$.raiseError((Throwable)new StorageException(404, new StringBuilder(18).append("Object not found, ").append(path$1).toString()), RaiseThrowable$.MODULE$.fromApplicativeError($this.F));
        } else {
            throw new MatchError((Object)option);
        }
        return freeC;
    }

    public static final /* synthetic */ void $anonfun$copy$8(Blob _) {
    }

    public GcsStore(Storage storage, ExecutionContext blocker, List<Acl> acls, boolean defaultTrailingSlashFiles, Sync<F> F, ContextShift<F> CS) {
        this.storage = storage;
        this.blocker = blocker;
        this.acls = acls;
        this.defaultTrailingSlashFiles = defaultTrailingSlashFiles;
        this.F = F;
        this.CS = CS;
    }
}

