/*
 * Decompiled with CFR 0.152.
 */
package blobstore.s3;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class CompletableFuturePublisher<T>
implements Publisher<T> {
    private final Supplier<CompletableFuture<T>> futureSupplier;

    CompletableFuturePublisher(Supplier<CompletableFuture<T>> supplier) {
        this.futureSupplier = supplier;
    }

    public static <T> Publisher<T> from(CompletableFuture<T> completableFuture) {
        return new CompletableFuturePublisher<T>(() -> completableFuture);
    }

    public final void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "Subscriber cannot be null");
        subscriber.onSubscribe((Subscription)new CompletableFutureSubscription(subscriber));
    }

    class CompletableFutureSubscription
    implements Subscription {
        private final Subscriber<? super T> subscriber;
        private final AtomicBoolean completed = new AtomicBoolean(false);
        private CompletableFuture<T> future;

        CompletableFutureSubscription(Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        public synchronized void request(long l) {
            if (l != 0L && !this.completed.get()) {
                if (l < 0L) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot request a negative number");
                    this.subscriber.onError((Throwable)illegalArgumentException);
                } else {
                    try {
                        CompletableFuture completableFuture = CompletableFuturePublisher.this.futureSupplier.get();
                        if (completableFuture == null) {
                            this.subscriber.onComplete();
                        } else {
                            this.future = completableFuture;
                            completableFuture.whenComplete((object, throwable) -> {
                                if (this.completed.compareAndSet(false, true)) {
                                    if (throwable != null) {
                                        this.subscriber.onError(throwable);
                                    } else {
                                        if (object != null) {
                                            this.subscriber.onNext(object);
                                        }
                                        this.subscriber.onComplete();
                                    }
                                }
                            });
                        }
                    }
                    catch (Throwable throwable2) {
                        this.subscriber.onError(throwable2);
                    }
                }
            }
        }

        public synchronized void cancel() {
            if (this.completed.compareAndSet(false, true) && this.future != null) {
                this.future.cancel(false);
            }
        }
    }
}

