/*
 * Decompiled with CFR 0.152.
 */
package blobstore.url;

import blobstore.url.Authority;
import blobstore.url.Host;
import blobstore.url.Host$;
import blobstore.url.Hostname$;
import blobstore.url.Port;
import blobstore.url.Port$;
import blobstore.url.UserInfo;
import blobstore.url.exception.AuthorityParseError;
import blobstore.url.exception.MultipleUrlValidationException;
import cats.Applicative;
import cats.ApplicativeError;
import cats.Functor;
import cats.Semigroupal;
import cats.Show;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyChainImpl$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.kernel.Eq;
import cats.kernel.Eq$;
import cats.kernel.Order;
import cats.package$;
import cats.syntax.EitherOps$;
import cats.syntax.ValidatedIdOpsBinCompat0$;
import cats.syntax.package;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

public final class Authority$
implements scala.Serializable {
    public static Authority$ MODULE$;
    private final Regex regex;
    private final Show<Authority> show;
    private final Order<Authority> order;
    private final Ordering<Authority> ordering;
    private final Eq<Authority> eq;

    static {
        new Authority$();
    }

    public Option<UserInfo> $lessinit$greater$default$2() {
        return None$.MODULE$;
    }

    public Option<Port> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    private Regex regex() {
        return this.regex;
    }

    public Authority unsafe(String candidate) {
        Validated<Object, Authority> validated = this.parse(candidate);
        if (validated instanceof Validated.Valid) {
            Validated.Valid valid = (Validated.Valid)validated;
            Authority a = (Authority)valid.a();
            return a;
        }
        if (validated instanceof Validated.Invalid) {
            Validated.Invalid invalid = (Validated.Invalid)validated;
            Object e = invalid.e();
            throw new MultipleUrlValidationException(e);
        }
        throw new MatchError(validated);
    }

    public Authority localhost() {
        return this.unsafe("localhost");
    }

    public <F> F parseF(String host, ApplicativeError<F, Throwable> evidence$1) {
        return (F)EitherOps$.MODULE$.liftTo$extension(package.all$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(package.all$.MODULE$.catsSyntaxEither(this.parse(host).toEither()), (Function1 & Serializable & scala.Serializable)errors -> new MultipleUrlValidationException(errors))), evidence$1);
    }

    public Validated<Object, Authority> parse(String candidate) {
        return EitherOps$.MODULE$.toValidated$extension(package.all$.MODULE$.catsSyntaxEither(this.regex().findFirstMatchIn((CharSequence)candidate).toRight((Function0 & Serializable & scala.Serializable)() -> cats.data.package$.MODULE$.NonEmptyChain().apply((Object)new AuthorityParseError.InvalidFormat(candidate, MODULE$.regex().pattern().pattern()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AuthorityParseError.InvalidFormat[0]))).flatMap((Function1 & Serializable & scala.Serializable)m -> {
            Option password = Option$.MODULE$.apply((Object)m.group(2));
            Option user = Option$.MODULE$.apply((Object)m.group(1)).map((Function1 & Serializable & scala.Serializable)x$1 -> new UserInfo((String)x$1, (Option<String>)password));
            Validated host2 = (Validated)Option$.MODULE$.apply((Object)m.group(3)).map((Function1 & Serializable & scala.Serializable)h -> Hostname$.MODULE$.parse((String)h)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(package.all$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new AuthorityParseError.MissingHostname(candidate))));
            Validated port2 = (Validated)package.all$.MODULE$.toTraverseOps((Object)Option$.MODULE$.apply((Object)m.group(4)), UnorderedFoldable$.MODULE$.catsTraverseForOption()).traverse((Function1 & Serializable & scala.Serializable)p -> Port$.MODULE$.parse((String)p).toValidatedNec(), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()));
            return ((Validated)package.all$.MODULE$.catsSyntaxTuple3Semigroupal(new Tuple3((Object)host2, (Object)ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(package.all$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)user)), (Object)port2)).mapN((Function3 & Serializable & scala.Serializable)(host, userInfo, port) -> new Authority((Host)host, (Option<UserInfo>)userInfo, (Option<Port>)port), (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()))).toEither();
        })));
    }

    public Show<Authority> show() {
        return this.show;
    }

    public Order<Authority> order() {
        return this.order;
    }

    public Ordering<Authority> ordering() {
        return this.ordering;
    }

    public Eq<Authority> eq() {
        return this.eq;
    }

    public Authority apply(Host host, Option<UserInfo> userInfo, Option<Port> port) {
        return new Authority(host, userInfo, port);
    }

    public Option<UserInfo> apply$default$2() {
        return None$.MODULE$;
    }

    public Option<Port> apply$default$3() {
        return None$.MODULE$;
    }

    public Option<Tuple3<Host, Option<UserInfo>, Option<Port>>> unapply(Authority x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.host(), x$0.userInfo(), x$0.port()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean blobstore$url$Authority$$$anonfun$eq$1(Authority x, Authority y) {
        return package.all$.MODULE$.catsSyntaxEq((Object)x.host(), Host$.MODULE$.order()).$eq$eq$eq((Object)y.host()) && package.all$.MODULE$.catsSyntaxEq(x.port(), (Eq)Eq$.MODULE$.catsKernelOrderForOption(Port$.MODULE$.order())).$eq$eq$eq(y.port());
    }

    private Authority$() {
        MODULE$ = this;
        this.regex = new StringOps(Predef$.MODULE$.augmentString("^(?:([^:@]+)(?::([^@]+))?@)?([^:/@]+)(?::([0-9]+))?$")).r();
        this.show = (Show & Serializable)s -> new StringBuilder(0).append(package.all$.MODULE$.toShow((Object)s.host(), Host$.MODULE$.show()).show()).append(s.port().map((Function1 & Serializable & scala.Serializable)x$2 -> package.all$.MODULE$.toShow(x$2, Port$.MODULE$.show()).show()).map((Function1 & Serializable & scala.Serializable)x$3 -> new StringBuilder(1).append(":").append((String)x$3).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
        this.order = package$.MODULE$.Order().by((Function1 & Serializable & scala.Serializable)x$4 -> package.all$.MODULE$.toShow(x$4, MODULE$.show()).show(), Eq$.MODULE$.catsKernelInstancesForString());
        this.ordering = this.order().toOrdering();
        this.eq = new Eq<Authority>(){
            public static final long serialVersionUID = 0L;

            public boolean eqv$mcZ$sp(boolean x, boolean y) {
                return Eq.eqv$mcZ$sp$((Eq)this, (boolean)x, (boolean)y);
            }

            public boolean eqv$mcB$sp(byte x, byte y) {
                return Eq.eqv$mcB$sp$((Eq)this, (byte)x, (byte)y);
            }

            public boolean eqv$mcC$sp(char x, char y) {
                return Eq.eqv$mcC$sp$((Eq)this, (char)x, (char)y);
            }

            public boolean eqv$mcD$sp(double x, double y) {
                return Eq.eqv$mcD$sp$((Eq)this, (double)x, (double)y);
            }

            public boolean eqv$mcF$sp(float x, float y) {
                return Eq.eqv$mcF$sp$((Eq)this, (float)x, (float)y);
            }

            public boolean eqv$mcI$sp(int x, int y) {
                return Eq.eqv$mcI$sp$((Eq)this, (int)x, (int)y);
            }

            public boolean eqv$mcJ$sp(long x, long y) {
                return Eq.eqv$mcJ$sp$((Eq)this, (long)x, (long)y);
            }

            public boolean eqv$mcS$sp(short x, short y) {
                return Eq.eqv$mcS$sp$((Eq)this, (short)x, (short)y);
            }

            public boolean eqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Eq.eqv$mcV$sp$((Eq)this, (BoxedUnit)x, (BoxedUnit)y);
            }

            public boolean neqv(Object x, Object y) {
                return Eq.neqv$((Eq)this, (Object)x, (Object)y);
            }

            public boolean neqv$mcZ$sp(boolean x, boolean y) {
                return Eq.neqv$mcZ$sp$((Eq)this, (boolean)x, (boolean)y);
            }

            public boolean neqv$mcB$sp(byte x, byte y) {
                return Eq.neqv$mcB$sp$((Eq)this, (byte)x, (byte)y);
            }

            public boolean neqv$mcC$sp(char x, char y) {
                return Eq.neqv$mcC$sp$((Eq)this, (char)x, (char)y);
            }

            public boolean neqv$mcD$sp(double x, double y) {
                return Eq.neqv$mcD$sp$((Eq)this, (double)x, (double)y);
            }

            public boolean neqv$mcF$sp(float x, float y) {
                return Eq.neqv$mcF$sp$((Eq)this, (float)x, (float)y);
            }

            public boolean neqv$mcI$sp(int x, int y) {
                return Eq.neqv$mcI$sp$((Eq)this, (int)x, (int)y);
            }

            public boolean neqv$mcJ$sp(long x, long y) {
                return Eq.neqv$mcJ$sp$((Eq)this, (long)x, (long)y);
            }

            public boolean neqv$mcS$sp(short x, short y) {
                return Eq.neqv$mcS$sp$((Eq)this, (short)x, (short)y);
            }

            public boolean neqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Eq.neqv$mcV$sp$((Eq)this, (BoxedUnit)x, (BoxedUnit)y);
            }

            public final boolean eqv(Authority x, Authority y) {
                return Authority$.blobstore$url$Authority$$$anonfun$eq$1(x, y);
            }
            {
                Eq.$init$((Eq)this);
            }
        };
    }
}

