/*
 * Decompiled with CFR 0.152.
 */
package blobstore.url;

import blobstore.url.Port;
import blobstore.url.exception.PortParseError;
import blobstore.url.exception.SingleValidationException;
import blobstore.url.exception.SingleValidationException$;
import blobstore.url.exception.UrlParseError;
import cats.ApplicativeError;
import cats.Bifunctor$;
import cats.Show;
import cats.Show$;
import cats.data.Validated;
import cats.kernel.Order;
import cats.kernel.Order$;
import cats.syntax.EitherIdOps$;
import cats.syntax.EitherOps$;
import cats.syntax.package;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Try$;

public final class Port$
implements scala.Serializable {
    public static Port$ MODULE$;
    private final int MinPortNumber;
    private final int MaxPortNumber;
    private final Ordering<Port> ordering;
    private final Order<Port> order;
    private final Show<Port> show;

    static {
        new Port$();
    }

    public int MinPortNumber() {
        return this.MinPortNumber;
    }

    public int MaxPortNumber() {
        return this.MaxPortNumber;
    }

    public Validated<PortParseError, Port> parse(String c) {
        return EitherOps$.MODULE$.toValidated$extension(package.all$.MODULE$.catsSyntaxEither(((Either)package.all$.MODULE$.toBifunctorOps((Object)EitherOps$.MODULE$.leftMap$extension(package.all$.MODULE$.catsSyntaxEither(Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(c)).toInt()).toEither()), (Function1 & Serializable & scala.Serializable)x$1 -> new PortParseError.InvalidPort(c)), Bifunctor$.MODULE$.catsBifunctorForEither()).leftWiden()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Port$.$anonfun$parse$3(BoxesRunTime.unboxToInt((Object)x$2)))));
    }

    public Validated<PortParseError, Port> parse(int i) {
        return EitherOps$.MODULE$.toValidated$extension(package.all$.MODULE$.catsSyntaxEither(i < this.MinPortNumber() || i > this.MaxPortNumber() ? EitherIdOps$.MODULE$.asLeft$extension(package.all$.MODULE$.catsSyntaxEitherId((Object)new PortParseError.PortNumberOutOfRange(i))) : EitherIdOps$.MODULE$.asRight$extension(package.all$.MODULE$.catsSyntaxEitherId((Object)new Port(i)))));
    }

    public <F> F parseF(String c, ApplicativeError<F, Throwable> evidence$1) {
        return (F)EitherOps$.MODULE$.liftTo$extension(package.all$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(package.all$.MODULE$.catsSyntaxEither(this.parse(c).toEither()), (Function1 & Serializable & scala.Serializable)x$3 -> new SingleValidationException((UrlParseError)x$3, SingleValidationException$.MODULE$.apply$default$2()))), evidence$1);
    }

    public <F> F parseF(int i, ApplicativeError<F, Throwable> evidence$2) {
        return (F)EitherOps$.MODULE$.liftTo$extension(package.all$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(package.all$.MODULE$.catsSyntaxEither(this.parse(i).toEither()), (Function1 & Serializable & scala.Serializable)x$4 -> new SingleValidationException((UrlParseError)x$4, SingleValidationException$.MODULE$.apply$default$2()))), evidence$2);
    }

    public Port unsafe(String c) {
        Validated<PortParseError, Port> validated = this.parse(c);
        if (validated instanceof Validated.Valid) {
            Validated.Valid valid = (Validated.Valid)validated;
            Port p = (Port)valid.a();
            return p;
        }
        if (validated instanceof Validated.Invalid) {
            Validated.Invalid invalid = (Validated.Invalid)validated;
            PortParseError e = (PortParseError)invalid.e();
            throw new SingleValidationException(e, SingleValidationException$.MODULE$.apply$default$2());
        }
        throw new MatchError(validated);
    }

    public Port unsafe(int i) {
        Validated<PortParseError, Port> validated = this.parse(i);
        if (validated instanceof Validated.Valid) {
            Validated.Valid valid = (Validated.Valid)validated;
            Port p = (Port)valid.a();
            return p;
        }
        if (validated instanceof Validated.Invalid) {
            Validated.Invalid invalid = (Validated.Invalid)validated;
            PortParseError e = (PortParseError)invalid.e();
            throw new SingleValidationException(e, SingleValidationException$.MODULE$.apply$default$2());
        }
        throw new MatchError(validated);
    }

    public int compare(Port one, Port two) {
        return new RichInt(Predef$.MODULE$.intWrapper(one.portNumber())).compare((Object)BoxesRunTime.boxToInteger((int)two.portNumber()));
    }

    public Ordering<Port> ordering() {
        return this.ordering;
    }

    public Order<Port> order() {
        return this.order;
    }

    public Show<Port> show() {
        return this.show;
    }

    public Port apply(int portNumber) {
        return new Port(portNumber);
    }

    public Option<Object> unapply(Port x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)x$0.portNumber()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Either $anonfun$parse$3(int x$2) {
        return MODULE$.parse(x$2).toEither();
    }

    public static final /* synthetic */ int blobstore$url$Port$$$anonfun$ordering$1(Port x, Port y) {
        return MODULE$.compare(x, y);
    }

    private Port$() {
        MODULE$ = this;
        this.MinPortNumber = 0;
        this.MaxPortNumber = 65535;
        this.ordering = new Ordering<Port>(){
            public static final long serialVersionUID = 0L;

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Port> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Port> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            public final int compare(Port x, Port y) {
                return Port$.blobstore$url$Port$$$anonfun$ordering$1(x, y);
            }
            {
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }
        };
        this.order = Order$.MODULE$.fromOrdering(this.ordering());
        this.show = (Show & Serializable)x$5 -> package.all$.MODULE$.toShow((Object)BoxesRunTime.boxToInteger((int)x$5.portNumber()), Show$.MODULE$.catsShowForInt()).show();
    }
}

