/*
 * Decompiled with CFR 0.152.
 */
package blobstore.url;

import blobstore.url.Authority;
import blobstore.url.Authority$;
import blobstore.url.Path;
import blobstore.url.Path$;
import blobstore.url.Path$AbsolutePath$;
import blobstore.url.Url;
import blobstore.url.exception.AuthorityParseError;
import blobstore.url.exception.MultipleUrlValidationException;
import blobstore.url.exception.UrlParseError;
import cats.ApplicativeError;
import cats.Bifunctor$;
import cats.Functor;
import cats.Invariant$;
import cats.Monad;
import cats.Semigroupal;
import cats.Show;
import cats.Show$;
import cats.data.NonEmptyChainImpl$;
import cats.data.OptionT;
import cats.data.Validated;
import cats.data.Validated$;
import cats.kernel.Eq;
import cats.kernel.Eq$;
import cats.kernel.Order;
import cats.package$;
import cats.syntax.EitherIdOps$;
import cats.syntax.EitherOps$;
import cats.syntax.EitherOpsBinCompat0$;
import cats.syntax.ValidatedExtension$;
import cats.syntax.ValidatedIdOpsBinCompat0$;
import cats.syntax.package;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.runtime.LazyRef;
import scala.util.Either;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class Url$
implements scala.Serializable {
    public static Url$ MODULE$;

    static {
        new Url$();
    }

    public <F> F parseF(String c, ApplicativeError<F, Throwable> evidence$1) {
        return (F)ValidatedExtension$.MODULE$.liftTo$extension(package.all$.MODULE$.catsSyntaxValidatedExtension(this.parse(c).leftMap((Function1 & Serializable & scala.Serializable)errors -> new MultipleUrlValidationException(errors))), evidence$1);
    }

    public Url<String> unsafe(String c) {
        Validated<Object, Url<String>> validated = this.parse(c);
        if (validated instanceof Validated.Valid) {
            Validated.Valid valid = (Validated.Valid)validated;
            Url u = (Url)valid.a();
            return u;
        }
        if (validated instanceof Validated.Invalid) {
            Validated.Invalid invalid = (Validated.Invalid)validated;
            Object e = invalid.e();
            throw new MultipleUrlValidationException(e);
        }
        throw new MatchError(validated);
    }

    public Validated<Object, Url<String>> parse(String c) {
        LazyRef parseNonFile$lzy = new LazyRef();
        Regex regex = new StringOps(Predef$.MODULE$.augmentString("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?")).r();
        if (c.startsWith("file")) {
            return Url$.parseFileUrl$1(c);
        }
        return Url$.parseNonFile$1(parseNonFile$lzy, regex, c);
    }

    public <A> Ordering<Url<A>> ordering() {
        return new Ordering<Url<A>>(){
            public static final long serialVersionUID = 0L;

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Url<A>> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Url<A>> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            public final int compare(Url<A> x, Url<A> y) {
                return Url$.blobstore$url$Url$$$anonfun$ordering$1(x, y);
            }
            {
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }
        };
    }

    public <A> Order<Url<A>> order() {
        return package$.MODULE$.Order().fromOrdering(this.ordering());
    }

    public <A> Show<Url<A>> show() {
        return (Show & Serializable)u -> {
            String pathString;
            String string;
            Path path = u.path();
            if (path instanceof Path.AbsolutePath) {
                Path.AbsolutePath absolutePath = (Path.AbsolutePath)path;
                string = new StringOps(Predef$.MODULE$.augmentString(package.all$.MODULE$.toShow((Object)absolutePath, Path$AbsolutePath$.MODULE$.show()).show())).stripPrefix("/");
            } else {
                string = pathString = package.all$.MODULE$.toShow(path, Path$.MODULE$.show()).show();
            }
            if (package.all$.MODULE$.catsSyntaxEq((Object)u.scheme(), (Eq)Eq$.MODULE$.catsKernelInstancesForString()).$eq$eq$eq((Object)"file")) {
                return Show.ShowInterpolator$.MODULE$.show$extension(package.all$.MODULE$.showInterpolator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":///", ""}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)u.scheme(), (Show.ContravariantShow)Show$.MODULE$.catsShowForString())), new Show.Shown(Show.Shown$.MODULE$.mat((Object)pathString, (Show.ContravariantShow)Show$.MODULE$.catsShowForString()))}));
            }
            return Show.ShowInterpolator$.MODULE$.show$extension(package.all$.MODULE$.showInterpolator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://", "/", ""}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)u.scheme(), (Show.ContravariantShow)Show$.MODULE$.catsShowForString())), new Show.Shown(Show.Shown$.MODULE$.mat((Object)u.authority(), Authority$.MODULE$.show())), new Show.Shown(Show.Shown$.MODULE$.mat((Object)pathString, (Show.ContravariantShow)Show$.MODULE$.catsShowForString()))}));
        };
    }

    public <A> Url<A> apply(String scheme, Authority authority, Path<A> path) {
        return new Url<A>(scheme, authority, path);
    }

    public <A> Option<Tuple3<String, Authority, Path<A>>> unapply(Url<A> x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.scheme(), (Object)x$0.authority(), x$0.path()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final Try tryOpt$1(Function0 a) {
        return Try$.MODULE$.apply(a).map((Function1 & Serializable & scala.Serializable)x -> Option$.MODULE$.apply(x));
    }

    private static final AuthorityParseError.InvalidFileUrl invalidFileUrl$1(String u$1) {
        return new AuthorityParseError.InvalidFileUrl(Show.ShowInterpolator$.MODULE$.show$extension(package.all$.MODULE$.showInterpolator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not a valid file uri: ", ""}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)u$1, (Show.ContravariantShow)Show$.MODULE$.catsShowForString()))})));
    }

    private static final Validated parseFileUrl$1(String u) {
        Regex fileRegex = new StringOps(Predef$.MODULE$.augmentString("file:/([^:]+)")).r();
        return (Validated)fileRegex.findFirstMatchIn((CharSequence)u).map((Function1 & Serializable & scala.Serializable)m -> {
            Either matchRegex = EitherOps$.MODULE$.leftMap$extension(package.all$.MODULE$.catsSyntaxEither(Url$.tryOpt$1((Function0 & Serializable & scala.Serializable)() -> m.group(1)).toEither()), (Function1 & Serializable & scala.Serializable)x$1 -> Url$.invalidFileUrl$1(u));
            return EitherOpsBinCompat0$.MODULE$.toValidatedNec$extension(package.all$.MODULE$.catsSyntaxEitherBinCompat0(((Either)new OptionT(package.all$.MODULE$.toBifunctorOps((Object)matchRegex, Bifunctor$.MODULE$.catsBifunctorForEither()).leftWiden()).getOrElseF((Function0 & Serializable & scala.Serializable)() -> EitherIdOps$.MODULE$.asLeft$extension(package.all$.MODULE$.catsSyntaxEitherId((Object)new AuthorityParseError.InvalidFileUrl(Show.ShowInterpolator$.MODULE$.show$extension(package.all$.MODULE$.showInterpolator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File uri didn't match regex: ", ""}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)fileRegex.pattern().toString(), (Show.ContravariantShow)Show$.MODULE$.catsShowForString()))}))))), (Monad)Invariant$.MODULE$.catsMonadErrorForEither())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string = x0$1;
                if ("/".equals(string)) {
                    return EitherIdOps$.MODULE$.asLeft$extension(package.all$.MODULE$.catsSyntaxEitherId((Object)Url$.invalidFileUrl$1(u)));
                }
                if (string.startsWith("/")) {
                    return EitherIdOps$.MODULE$.asRight$extension(package.all$.MODULE$.catsSyntaxEitherId(new Url<String>("file", Authority$.MODULE$.localhost(), Path$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(string)).stripPrefix("/")))));
                }
                return EitherIdOps$.MODULE$.asRight$extension(package.all$.MODULE$.catsSyntaxEitherId(new Url<String>("file", Authority$.MODULE$.localhost(), Path$.MODULE$.apply(new StringBuilder(1).append("/").append(string).toString()))));
            })));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(package.all$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new AuthorityParseError.InvalidFileUrl(Show.ShowInterpolator$.MODULE$.show$extension(package.all$.MODULE$.showInterpolator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File uri didn't match regex: ", ""}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)fileRegex.pattern().toString(), (Show.ContravariantShow)Show$.MODULE$.catsShowForString()))}))))));
    }

    private static final /* synthetic */ Validated parseNonFile$lzycompute$1(LazyRef parseNonFile$lzy$1, Regex regex$1, String c$1) {
        Validated validated;
        LazyRef lazyRef = parseNonFile$lzy$1;
        synchronized (lazyRef) {
            validated = parseNonFile$lzy$1.initialized() ? (Validated)parseNonFile$lzy$1.value() : (Validated)parseNonFile$lzy$1.initialize(regex$1.findFirstMatchIn((CharSequence)c$1).map((Function1 & Serializable & scala.Serializable)m -> {
                Either authority = (Either)new OptionT(package.all$.MODULE$.toBifunctorOps((Object)EitherOps$.MODULE$.leftMap$extension(package.all$.MODULE$.catsSyntaxEither(Url$.tryOpt$1((Function0 & Serializable & scala.Serializable)() -> m.group(4)).toEither()), (Function1 & Serializable & scala.Serializable)t -> new AuthorityParseError.InvalidHost((Throwable)t)), Bifunctor$.MODULE$.catsBifunctorForEither()).leftWiden()).getOrElseF((Function0 & Serializable & scala.Serializable)() -> EitherIdOps$.MODULE$.asLeft$extension(package.all$.MODULE$.catsSyntaxEitherId((Object)new AuthorityParseError.MissingHost(c$1))), (Monad)Invariant$.MODULE$.catsMonadErrorForEither());
                Validated typedAuthority = EitherOps$.MODULE$.toValidated$extension(package.all$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(package.all$.MODULE$.catsSyntaxEither(authority), (Function1 & Serializable & scala.Serializable)x$2 -> cats.data.package$.MODULE$.NonEmptyChain().apply(x$2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AuthorityParseError[0]))).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Authority$.MODULE$.parse((String)x$3).toEither())));
                OptionT pathGroup = new OptionT((Object)Url$.tryOpt$1((Function0 & Serializable & scala.Serializable)() -> m.group(5))).map((Function1 & Serializable & scala.Serializable)x$4 -> new StringOps(Predef$.MODULE$.augmentString(x$4)).stripPrefix("/"), (Functor)Invariant$.MODULE$.catsInstancesForTry());
                Path path = (Path)((Try)pathGroup.map((Function1 & Serializable & scala.Serializable)s -> Path$.MODULE$.apply((String)s), (Functor)Invariant$.MODULE$.catsInstancesForTry()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Path$.MODULE$.empty(), (Functor)Invariant$.MODULE$.catsInstancesForTry())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Path$.MODULE$.empty());
                Validated scheme = EitherOpsBinCompat0$.MODULE$.toValidatedNec$extension(package.all$.MODULE$.catsSyntaxEitherBinCompat0((Either)new OptionT(package.all$.MODULE$.toBifunctorOps((Object)EitherOps$.MODULE$.leftMap$extension(package.all$.MODULE$.catsSyntaxEither(Url$.tryOpt$1((Function0 & Serializable & scala.Serializable)() -> m.group(2)).toEither()), (Function1 & Serializable & scala.Serializable)t -> new UrlParseError.MissingScheme(c$1, (Option<Throwable>)new Some(t))), Bifunctor$.MODULE$.catsBifunctorForEither()).leftWiden()).getOrElseF((Function0 & Serializable & scala.Serializable)() -> EitherIdOps$.MODULE$.asLeft$extension(package.all$.MODULE$.catsSyntaxEitherId((Object)new UrlParseError.MissingScheme(c$1, (Option<Throwable>)None$.MODULE$))), (Monad)Invariant$.MODULE$.catsMonadErrorForEither())));
                return (Validated)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)scheme, (Object)typedAuthority)).mapN((Function2 & Serializable & scala.Serializable)(s, a) -> new Url((String)s, (Authority)a, path), (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()));
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(package.all$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new UrlParseError.CouldntParseUrl(c$1)))));
        }
        return validated;
    }

    private static final Validated parseNonFile$1(LazyRef parseNonFile$lzy$1, Regex regex$1, String c$1) {
        if (parseNonFile$lzy$1.initialized()) {
            return (Validated)parseNonFile$lzy$1.value();
        }
        return Url$.parseNonFile$lzycompute$1(parseNonFile$lzy$1, regex$1, c$1);
    }

    public static final /* synthetic */ int blobstore$url$Url$$$anonfun$ordering$1(Url x, Url y) {
        return new StringOps(Predef$.MODULE$.augmentString(package.all$.MODULE$.toShow((Object)x, MODULE$.show()).show())).compare(package.all$.MODULE$.toShow((Object)y, MODULE$.show()).show());
    }

    private Url$() {
        MODULE$ = this;
    }
}

