/*
 * Decompiled with CFR 0.152.
 */
package ro.skyah.comparator.matcher;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.Set;
import ro.skyah.comparator.CompareMode;
import ro.skyah.comparator.JSONCompare;
import ro.skyah.comparator.matcher.AbstractJsonMatcher;
import ro.skyah.comparator.matcher.JsonMatcher;
import ro.skyah.comparator.matcher.MatcherException;
import ro.skyah.util.MessageUtil;

public class JsonArrayMatcher
extends AbstractJsonMatcher {
    private Set<Integer> matchedPositions = new HashSet<Integer>();

    public JsonArrayMatcher(JsonNode expected, JsonNode actual) {
        super(expected, actual);
    }

    public void matches() throws MatcherException {
        for (int i = 0; i < this.expected.size(); ++i) {
            JsonNode element = this.expected.get(i);
            AbstractJsonMatcher.UseCase useCase = JsonArrayMatcher.getUseCase(element.asText());
            boolean found = false;
            for (int j = 0; j < this.actual.size(); ++j) {
                JsonNode actElement;
                if (this.matchedPositions.contains(j) || compareModes.contains((Object)CompareMode.JSON_ARRAY_STRICT_ORDER) && j != i) continue;
                if (useCase.equals((Object)AbstractJsonMatcher.UseCase.MATCH)) {
                    actElement = this.actual.get(j);
                    try {
                        new JsonMatcher(element, actElement).matches();
                    }
                    catch (MatcherException e) {
                        if (!compareModes.contains((Object)CompareMode.JSON_ARRAY_STRICT_ORDER)) continue;
                        throw new MatcherException(String.format("JSON ARRAY elements differ at position %s", i + 1));
                    }
                    found = true;
                    this.matchedPositions.add(j);
                    break;
                }
                actElement = this.actual.get(j);
                try {
                    new JsonMatcher(element, actElement).matches();
                    continue;
                }
                catch (MatcherException e) {
                    found = true;
                    break;
                }
            }
            if (!found && useCase.equals((Object)AbstractJsonMatcher.UseCase.MATCH)) {
                throw new MatcherException("Expected element from position " + (i + 1) + " was NOT FOUND:\n" + MessageUtil.cropM(JSONCompare.prettyPrint(element)));
            }
            if (!found || !useCase.equals((Object)AbstractJsonMatcher.UseCase.DO_NOT_MATCH)) continue;
            throw new MatcherException("Expected element from position " + (i + 1) + " was FOUND:\n" + MessageUtil.cropM(JSONCompare.prettyPrint(element)));
        }
        if (compareModes.contains((Object)CompareMode.JSON_ARRAY_NON_EXTENSIBLE) && this.expected.size() < this.actual.size()) {
            throw new MatcherException("Actual JSON ARRAY has extra elements");
        }
    }
}

