/*
 * Decompiled with CFR 0.152.
 */
package ro.skyah.comparator.matcher;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ro.skyah.comparator.CompareMode;
import ro.skyah.comparator.matcher.AbstractJsonMatcher;
import ro.skyah.comparator.matcher.JsonMatcher;
import ro.skyah.comparator.matcher.MatcherException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonObjectMatcher
extends AbstractJsonMatcher {
    private Set<String> matchedFieldNames = new HashSet<String>();

    public JsonObjectMatcher(JsonNode expected, JsonNode actual) {
        super(expected, actual);
    }

    @Override
    public void matches() throws MatcherException {
        Iterator it = this.expected.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String field = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            AbstractJsonMatcher.UseCase useCase = JsonObjectMatcher.getUseCase(field);
            String sanitizedField = JsonObjectMatcher.sanitize(field);
            Map.Entry<String, JsonNode> candidateEntry = this.searchCandidateEntryByField(sanitizedField, this.actual);
            if (useCase.equals((Object)AbstractJsonMatcher.UseCase.DO_NOT_MATCH) && candidateEntry == null) continue;
            if (useCase.equals((Object)AbstractJsonMatcher.UseCase.DO_NOT_MATCH) && candidateEntry != null) {
                throw new MatcherException(String.format("Field %s was found", field));
            }
            if (useCase.equals((Object)AbstractJsonMatcher.UseCase.MATCH) && candidateEntry == null) {
                throw new MatcherException(String.format("Field %s was not found", field));
            }
            String candidateField = candidateEntry.getKey();
            JsonNode candidateValue = candidateEntry.getValue();
            try {
                new JsonMatcher(value, candidateValue).matches();
            }
            catch (MatcherException e) {
                throw new MatcherException(String.format("%s <- field \"%s\"", e.getMessage(), sanitizedField));
            }
            this.matchedFieldNames.add(candidateField);
        }
        if (compareModes.contains((Object)CompareMode.JSON_OBJECT_NON_EXTENSIBLE) && this.expected.size() < this.actual.size()) {
            throw new MatcherException("Actual JSON OBJECT has extra fields");
        }
    }

    private Map.Entry<String, JsonNode> searchCandidateEntryByField(String fieldName, JsonNode target) {
        Iterator it = target.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String key = (String)entry.getKey();
            if (this.matchedFieldNames.contains(key) || !comparator.compareFields(fieldName, key)) continue;
            return entry;
        }
        return null;
    }
}

