/*
 * Decompiled with CFR 0.152.
 */
package ro.skyah.comparator.matcher;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import ro.skyah.comparator.matcher.AbstractJsonMatcher;
import ro.skyah.comparator.matcher.MatcherException;

public class JsonTextMatcher
extends AbstractJsonMatcher {
    public JsonTextMatcher(JsonNode expected, JsonNode actual) {
        super(expected, actual);
    }

    public void matches() throws MatcherException {
        AbstractJsonMatcher.UseCase useCase = JsonTextMatcher.getUseCase(this.expected.asText());
        this.matchStringType();
        this.matchNumberType();
        this.matchBooleanType();
        this.matchNullType();
        String expectedText = JsonTextMatcher.sanitize(this.expected.asText());
        String actualText = this.actual.asText();
        if (comparator.compareValues(expectedText, actualText) != useCase.equals((Object)AbstractJsonMatcher.UseCase.MATCH)) {
            throw new MatcherException(String.format("Expected value: %s  But found: %s ", this.expected, this.actual));
        }
    }

    private void matchNullType() throws MatcherException {
        if (this.expected.getNodeType().equals((Object)JsonNodeType.NULL) && !this.actual.getNodeType().equals((Object)JsonNodeType.NULL)) {
            throw new MatcherException(String.format("Expected value: %s  But found: %s ", this.expected, this.actual));
        }
    }

    private void matchNumberType() throws MatcherException {
        if (this.expected.getNodeType().equals((Object)JsonNodeType.NUMBER) && !this.actual.getNodeType().equals((Object)JsonNodeType.NUMBER)) {
            throw new MatcherException(String.format("Expected value: %s  But found: %s ", this.expected, this.actual));
        }
    }

    private void matchBooleanType() throws MatcherException {
        if (this.expected.getNodeType().equals((Object)JsonNodeType.BOOLEAN) && !this.actual.getNodeType().equals((Object)JsonNodeType.BOOLEAN)) {
            throw new MatcherException(String.format("Expected value: %s  But found: %s ", this.expected, this.actual));
        }
    }

    private void matchStringType() throws MatcherException {
        if (this.actual.getNodeType().equals((Object)JsonNodeType.STRING) && !this.expected.getNodeType().equals((Object)JsonNodeType.STRING)) {
            throw new MatcherException(String.format("Expected value: %s  But found: %s ", this.expected, this.actual));
        }
    }
}

