/*
 * Decompiled with CFR 0.152.
 */
package io.json.compare.matcher;

import com.fasterxml.jackson.databind.JsonNode;
import io.json.compare.CompareMode;
import io.json.compare.DefaultJsonComparator;
import io.json.compare.JsonComparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;

abstract class AbstractJsonMatcher {
    protected static final String JSON_PATH_EXP_PREFIX = "#(";
    protected static final String JSON_PATH_EXP_SUFFIX = ")";
    protected final JsonComparator comparator;
    protected final Set<CompareMode> compareModes;
    protected final JsonNode expected;
    protected final JsonNode actual;

    AbstractJsonMatcher(JsonNode expected, JsonNode actual, JsonComparator comparator, Set<CompareMode> compareModes) {
        this.expected = expected;
        this.actual = actual;
        this.comparator = comparator == null ? new DefaultJsonComparator() : comparator;
        this.compareModes = compareModes == null ? new HashSet() : compareModes;
    }

    protected abstract List<String> match();

    protected static UseCase getUseCase(JsonNode node) {
        if (node.isValueNode()) {
            return AbstractJsonMatcher.getUseCase(node.asText());
        }
        return UseCase.MATCH;
    }

    protected static UseCase getUseCase(String value) {
        if (value == null || value.isEmpty()) {
            return UseCase.MATCH;
        }
        if (value.equals(UseCase.MATCH_ANY.getValue())) {
            return UseCase.MATCH_ANY;
        }
        if (value.equals(UseCase.DO_NOT_MATCH_ANY.getValue())) {
            return UseCase.DO_NOT_MATCH_ANY;
        }
        if (value.startsWith(UseCase.DO_NOT_MATCH.getValue())) {
            return UseCase.DO_NOT_MATCH;
        }
        return UseCase.MATCH;
    }

    protected static String sanitize(String value) {
        if (AbstractJsonMatcher.getUseCase(value) == UseCase.DO_NOT_MATCH || AbstractJsonMatcher.getUseCase(value) == UseCase.DO_NOT_MATCH_ANY) {
            return value.substring(1);
        }
        return AbstractJsonMatcher.removeEscapes(value);
    }

    protected static Optional<String> extractJsonPathExp(String field) {
        if (field.startsWith(JSON_PATH_EXP_PREFIX) && field.endsWith(JSON_PATH_EXP_SUFFIX)) {
            return Optional.of(field.substring(JSON_PATH_EXP_PREFIX.length(), field.length() - JSON_PATH_EXP_SUFFIX.length()));
        }
        return Optional.empty();
    }

    private static String removeEscapes(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("\\" + UseCase.DO_NOT_MATCH.getValue()) || value.equals("\\" + UseCase.DO_NOT_MATCH_ANY.getValue()) || value.equals("\\" + UseCase.MATCH_ANY.getValue()) || value.startsWith("\\#(")) {
            return value.replaceFirst("\\\\", "");
        }
        return value;
    }

    protected static boolean isJsonObject(JsonNode jsonNode) {
        return jsonNode != null && jsonNode.isObject();
    }

    protected static boolean isJsonArray(JsonNode jsonNode) {
        return jsonNode != null && jsonNode.isArray();
    }

    protected static boolean isValueNode(JsonNode jsonNode) {
        return jsonNode != null && jsonNode.isValueNode();
    }

    protected static boolean isJsonPathNode(JsonNode jsonNode) {
        Iterator fieldNames;
        if (jsonNode != null && jsonNode.isObject() && (fieldNames = jsonNode.fieldNames()).hasNext()) {
            while (fieldNames.hasNext()) {
                if (AbstractJsonMatcher.extractJsonPathExp((String)fieldNames.next()).isPresent()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected static boolean isMissingNode(JsonNode jsonNode) {
        return jsonNode != null && jsonNode.isMissingNode();
    }

    protected static boolean areOfSameType(JsonNode expNode, JsonNode actNode) {
        return AbstractJsonMatcher.isValueNode(expNode) & AbstractJsonMatcher.isValueNode(actNode) || AbstractJsonMatcher.isJsonObject(expNode) & AbstractJsonMatcher.isJsonObject(actNode) || AbstractJsonMatcher.isJsonArray(expNode) & AbstractJsonMatcher.isJsonArray(actNode) || AbstractJsonMatcher.isJsonPathNode(expNode);
    }

    protected static enum UseCase {
        MATCH,
        DO_NOT_MATCH("!"),
        MATCH_ANY(".*"),
        DO_NOT_MATCH_ANY("!.*");

        private String value;

        private UseCase() {
        }

        private UseCase(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

