/*
 * Decompiled with CFR 0.152.
 */
package io.json.compare.matcher;

import com.fasterxml.jackson.databind.JsonNode;
import io.json.compare.CompareMode;
import io.json.compare.JSONCompare;
import io.json.compare.JsonComparator;
import io.json.compare.matcher.AbstractJsonMatcher;
import io.json.compare.matcher.JsonMatcher;
import io.json.compare.util.MessageUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class JsonArrayMatcher
extends AbstractJsonMatcher {
    private final Set<Integer> matchedPositions = new HashSet<Integer>();

    JsonArrayMatcher(JsonNode expected, JsonNode actual, JsonComparator comparator, Set<CompareMode> compareModes) {
        super(expected, actual, comparator, compareModes);
    }

    @Override
    public List<String> match() {
        ArrayList<String> diffs = new ArrayList<String>();
        for (int i = 0; i < this.expected.size(); ++i) {
            JsonNode expElement = this.expected.get(i);
            AbstractJsonMatcher.UseCase useCase = JsonArrayMatcher.getUseCase(expElement);
            if (useCase.equals((Object)AbstractJsonMatcher.UseCase.DO_NOT_MATCH_ANY) && !diffs.isEmpty()) continue;
            if (JsonArrayMatcher.isJsonPathNode(expElement)) {
                diffs.addAll(new JsonMatcher(expElement, this.actual, this.comparator, this.compareModes).match());
                continue;
            }
            diffs.addAll(this.matchWithJsonArray(i, expElement, useCase, this.actual));
        }
        if (this.compareModes.contains((Object)CompareMode.JSON_ARRAY_NON_EXTENSIBLE) && this.expected.size() < this.actual.size()) {
            diffs.add("Actual JSON ARRAY has extra elements");
        }
        return diffs;
    }

    private List<String> matchWithJsonArray(int expPosition, JsonNode expElement, AbstractJsonMatcher.UseCase useCase, JsonNode actualArray) {
        ArrayList<String> diffs = new ArrayList<String>();
        block6: for (int j = 0; j < actualArray.size(); ++j) {
            if (this.matchedPositions.contains(j) || this.compareModes.contains((Object)CompareMode.JSON_ARRAY_STRICT_ORDER) && j != expPosition) continue;
            switch (useCase) {
                case MATCH: {
                    JsonNode actElement = actualArray.get(j);
                    List<String> elementDiffs = new JsonMatcher(expElement, actElement, this.comparator, this.compareModes).match();
                    if (elementDiffs.isEmpty()) {
                        this.matchedPositions.add(j);
                        return Collections.emptyList();
                    }
                    if (!this.compareModes.contains((Object)CompareMode.JSON_ARRAY_STRICT_ORDER)) continue block6;
                    diffs.add(String.format("JSON ARRAY elements differ at position %s:" + System.lineSeparator() + "%s" + System.lineSeparator() + "________diffs________" + System.lineSeparator() + "%s", expPosition + 1, MessageUtil.cropL(JSONCompare.prettyPrint(expElement)), String.join((CharSequence)(System.lineSeparator() + "_____________________" + System.lineSeparator()), elementDiffs)));
                    return diffs;
                }
                case MATCH_ANY: {
                    this.matchedPositions.add(j);
                    return Collections.emptyList();
                }
                case DO_NOT_MATCH: {
                    List<String> elementDiffs;
                    JsonNode actElement = actualArray.get(j);
                    if (!JsonArrayMatcher.areOfSameType(expElement, actElement) || (elementDiffs = new JsonMatcher(expElement, actElement, this.comparator, this.compareModes).match()).isEmpty()) continue block6;
                    diffs.add("Expected element from position " + (expPosition + 1) + " was FOUND:" + System.lineSeparator() + MessageUtil.cropL(JSONCompare.prettyPrint(expElement)));
                    return diffs;
                }
                case DO_NOT_MATCH_ANY: {
                    diffs.add(String.format("Expected condition %s from position %s was not met. Actual JSON array has extra elements.", expElement, expPosition + 1));
                    return diffs;
                }
            }
        }
        if (useCase == AbstractJsonMatcher.UseCase.MATCH) {
            diffs.add(System.lineSeparator() + "Expected element from position " + (expPosition + 1) + " was NOT FOUND:" + System.lineSeparator() + MessageUtil.cropL(JSONCompare.prettyPrint(expElement)));
        } else if (useCase == AbstractJsonMatcher.UseCase.MATCH_ANY) {
            diffs.add(String.format("Expected condition %s from position %s was not met. Actual Json Array has no extra elements.", expElement, expPosition + 1));
        }
        return diffs;
    }
}

