/*
 * Decompiled with CFR 0.152.
 */
package io.json.compare.matcher;

import com.fasterxml.jackson.databind.JsonNode;
import io.json.compare.CompareMode;
import io.json.compare.JsonComparator;
import io.json.compare.matcher.AbstractJsonMatcher;
import io.json.compare.matcher.JsonArrayMatcher;
import io.json.compare.matcher.JsonObjectMatcher;
import io.json.compare.matcher.JsonValueMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class JsonMatcher
extends AbstractJsonMatcher {
    public JsonMatcher(JsonNode expected, JsonNode actual, JsonComparator comparator, Set<CompareMode> compareModes) {
        super(expected, actual, comparator, compareModes);
    }

    @Override
    public List<String> match() {
        if (JsonMatcher.isJsonObject(this.expected) && JsonMatcher.isJsonObject(this.actual)) {
            return new JsonObjectMatcher(this.expected, this.actual, this.comparator, this.compareModes).match();
        }
        if (JsonMatcher.isJsonArray(this.expected) && JsonMatcher.isJsonArray(this.actual)) {
            return new JsonArrayMatcher(this.expected, this.actual, this.comparator, this.compareModes).match();
        }
        if (JsonMatcher.isValueNode(this.expected) && JsonMatcher.isValueNode(this.actual)) {
            return new JsonValueMatcher(this.expected, this.actual, this.comparator, this.compareModes).match();
        }
        if (JsonMatcher.isJsonPathNode(this.expected)) {
            return new JsonObjectMatcher(this.expected, this.actual, this.comparator, this.compareModes).match();
        }
        if (JsonMatcher.isMissingNode(this.expected) && JsonMatcher.isMissingNode(this.actual)) {
            return Collections.emptyList();
        }
        ArrayList<String> diffs = new ArrayList<String>();
        diffs.add("Different JSON types: expected " + this.expected.getClass().getSimpleName() + " but got " + this.actual.getClass().getSimpleName());
        return diffs;
    }
}

