/*
 * Decompiled with CFR 0.152.
 */
package io.json.compare.matcher;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import io.json.compare.CompareMode;
import io.json.compare.JsonComparator;
import io.json.compare.matcher.AbstractJsonMatcher;
import io.json.compare.matcher.JsonMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class JsonPathMatcher
extends AbstractJsonMatcher {
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(DeserializationFeature.FAIL_ON_TRAILING_TOKENS);
    private static final ParseContext PARSE_CONTEXT = JsonPath.using((Configuration)new Configuration.ConfigurationBuilder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).build());
    private final String jsonPath;

    JsonPathMatcher(String jsonPath, JsonNode expectedValue, JsonNode actual, JsonComparator comparator, Set<CompareMode> compareModes) {
        super(expectedValue, actual, comparator, compareModes);
        this.jsonPath = jsonPath;
    }

    @Override
    public List<String> match() {
        ArrayList<String> diffs = new ArrayList<String>();
        JsonNode result = (JsonNode)MAPPER.convertValue(PARSE_CONTEXT.parse((Object)this.actual).read(this.jsonPath, new Predicate[0]), JsonNode.class);
        List<String> jsonPathDiffs = new JsonMatcher(this.expected, result, this.comparator, this.compareModes).match();
        jsonPathDiffs.forEach(diff -> diffs.add(String.format("Json path '%s' -> Expected json path result:" + System.lineSeparator() + "%s" + System.lineSeparator() + "But got:" + System.lineSeparator() + "%s" + System.lineSeparator() + "________diffs________" + System.lineSeparator() + "%s", this.jsonPath, this.expected, result, diff)));
        return diffs;
    }
}

