/*
 * Decompiled with CFR 0.152.
 */
package io.json.compare.matcher;

import com.fasterxml.jackson.databind.JsonNode;
import com.jayway.jsonpath.PathNotFoundException;
import io.json.compare.CompareMode;
import io.json.compare.JsonComparator;
import io.json.compare.matcher.AbstractJsonMatcher;
import io.json.compare.matcher.JsonMatcher;
import io.json.compare.matcher.JsonPathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class JsonObjectMatcher
extends AbstractJsonMatcher {
    private final Set<String> matchedFieldNames = new HashSet<String>();

    JsonObjectMatcher(JsonNode expected, JsonNode actual, JsonComparator comparator, Set<CompareMode> compareModes) {
        super(expected, actual, comparator, compareModes);
    }

    @Override
    public List<String> match() {
        ArrayList<String> diffs = new ArrayList<String>();
        Iterator it = this.expected.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String expectedField = (String)entry.getKey();
            JsonNode expectedValue = (JsonNode)entry.getValue();
            AbstractJsonMatcher.UseCase fieldUseCase = JsonObjectMatcher.getUseCase(expectedField);
            String expectedSanitizedField = JsonObjectMatcher.sanitize(expectedField);
            Optional<String> jsonPathExpression = JsonObjectMatcher.extractJsonPathExp(expectedSanitizedField);
            List<Map.Entry<String, JsonNode>> candidateEntries = null;
            if (!jsonPathExpression.isPresent()) {
                candidateEntries = this.searchCandidatesByField(fieldUseCase, expectedSanitizedField, this.actual);
            }
            switch (fieldUseCase) {
                case MATCH_ANY: 
                case MATCH: {
                    if (!jsonPathExpression.isPresent()) {
                        if (candidateEntries.isEmpty()) {
                            diffs.add(String.format("Field '%s' was NOT FOUND", expectedField));
                            break;
                        }
                        diffs.addAll(this.matchWithCandidates(expectedSanitizedField, expectedValue, candidateEntries));
                        break;
                    }
                    try {
                        diffs.addAll(new JsonPathMatcher(jsonPathExpression.get(), expectedValue, this.actual, this.comparator, this.compareModes).match());
                    }
                    catch (PathNotFoundException e) {
                        diffs.add(String.format("Json path '%s' -> %s", jsonPathExpression.get(), e.getMessage()));
                    }
                    break;
                }
                case DO_NOT_MATCH_ANY: {
                    if (this.expected.size() - JsonObjectMatcher.getDoNotMatchUseCases(this.expected) >= this.actual.size()) break;
                    diffs.add(String.format("Expected condition '%s' was not met. Actual JSON OBJECT has extra fields", expectedField));
                    break;
                }
                case DO_NOT_MATCH: {
                    if (!jsonPathExpression.isPresent()) {
                        if (candidateEntries.isEmpty()) break;
                        diffs.add(String.format("Field '%s' was FOUND", expectedField));
                        break;
                    }
                    try {
                        new JsonPathMatcher(jsonPathExpression.get(), expectedValue, this.actual, this.comparator, this.compareModes).match();
                    }
                    catch (PathNotFoundException e) {
                        break;
                    }
                    diffs.add(String.format("Json path '%s' was FOUND", expectedField));
                }
            }
        }
        if (this.compareModes.contains((Object)CompareMode.JSON_OBJECT_NON_EXTENSIBLE) && this.expected.size() - JsonObjectMatcher.getDoNotMatchUseCases(this.expected) < this.actual.size()) {
            diffs.add("Actual JSON OBJECT has extra fields");
        }
        return diffs;
    }

    private List<String> matchWithCandidates(String expectedField, JsonNode expectedValue, List<Map.Entry<String, JsonNode>> candidates) {
        ArrayList<String> diffs = new ArrayList<String>();
        AbstractJsonMatcher.UseCase expectedValueUseCase = JsonObjectMatcher.getUseCase(expectedValue);
        for (Map.Entry<String, JsonNode> candidateEntry : candidates) {
            String candidateField = candidateEntry.getKey();
            if (expectedValueUseCase == AbstractJsonMatcher.UseCase.MATCH_ANY) {
                this.matchedFieldNames.add(candidateField);
                return Collections.emptyList();
            }
            JsonNode candidateValue = candidateEntry.getValue();
            List<String> candidateDiffs = new JsonMatcher(expectedValue, candidateValue, this.comparator, this.compareModes).match();
            if (candidateDiffs.isEmpty()) {
                this.matchedFieldNames.add(candidateField);
                return Collections.emptyList();
            }
            candidateDiffs.forEach(diff -> diffs.add(String.format("%s -> %s", expectedField, diff)));
        }
        return diffs;
    }

    private List<Map.Entry<String, JsonNode>> searchCandidatesByField(AbstractJsonMatcher.UseCase fieldUseCase, String fieldName, JsonNode target) {
        ArrayList<Map.Entry<String, JsonNode>> candidates = new ArrayList<Map.Entry<String, JsonNode>>();
        Iterator it = target.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String key = (String)entry.getKey();
            if (this.matchedFieldNames.contains(key) || !fieldUseCase.equals((Object)AbstractJsonMatcher.UseCase.MATCH_ANY) && !this.comparator.compareFields(fieldName, key)) continue;
            candidates.add(entry);
        }
        return candidates;
    }
}

