/*
 * Decompiled with CFR 0.152.
 */
package io.json.compare.matcher;

import com.fasterxml.jackson.databind.JsonNode;
import io.json.compare.CompareMode;
import io.json.compare.JsonComparator;
import io.json.compare.matcher.AbstractJsonMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class JsonValueMatcher
extends AbstractJsonMatcher {
    JsonValueMatcher(JsonNode expected, JsonNode actual, JsonComparator comparator, Set<CompareMode> compareModes) {
        super(expected, actual, comparator, compareModes);
    }

    @Override
    public List<String> match() {
        ArrayList<String> diffs = new ArrayList<String>();
        String diff = System.lineSeparator() + "Expected %s: %s But got: %s";
        if (this.expected.isNull() && !this.actual.isNull()) {
            diffs.add(String.format(diff, "null", "", this.actual));
            return diffs;
        }
        if (this.expected.isNumber() && !this.actual.isNumber()) {
            diffs.add(String.format(diff, "number", this.expected, this.actual));
            return diffs;
        }
        if (this.expected.isBoolean() && !this.actual.isBoolean()) {
            diffs.add(String.format(diff, "boolean", this.expected, this.actual));
            return diffs;
        }
        if (this.actual.isTextual() && !this.expected.isTextual()) {
            diffs.add(String.format(diff, "text", this.expected, this.actual));
            return diffs;
        }
        AbstractJsonMatcher.UseCase useCase = JsonValueMatcher.getUseCase(this.expected.asText());
        String expectedText = JsonValueMatcher.sanitize(this.expected.asText());
        String actualText = this.actual.asText();
        if (!useCase.equals((Object)AbstractJsonMatcher.UseCase.MATCH_ANY) && this.comparator.compareValues(expectedText, actualText) != useCase.equals((Object)AbstractJsonMatcher.UseCase.MATCH)) {
            diffs.add(String.format(diff, "value", this.expected, this.actual));
        }
        return diffs;
    }
}

