/*
 * Decompiled with CFR 0.152.
 */
package com.github.plantuml.maven;

import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SourceFileReader;
import net.sourceforge.plantuml.preproc.Defines;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;

@Mojo(defaultPhase=LifecyclePhase.GENERATE_RESOURCES, name="generate")
public final class PlantUMLMojo
extends AbstractMojo {
    protected final Option option = new Option();
    @Parameter(property="truncatePattern")
    protected String truncatePattern;
    @Parameter(property="plantuml.sourceFiles", required=true)
    protected FileSet sourceFiles;
    @Parameter(property="plantuml.outputDirectory", defaultValue="${basedir}/target/plantuml", required=true)
    protected File outputDirectory;
    @Parameter(property="plantuml.outputInSourceDirectory", defaultValue="false")
    protected boolean outputInSourceDirectory;
    @Parameter(property="plantuml.charset")
    protected String charset;
    @Parameter(property="plantuml.config")
    protected String config;
    @Parameter(property="plantuml.format")
    protected String format;
    @Parameter(property="plantuml.graphvizDot")
    protected String graphvizDot;
    @Parameter(property="plantuml.verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(property="plantuml.withMetadata")
    protected boolean withMetadata = false;
    @Parameter(property="plantuml.overwrite")
    protected boolean overwrite = false;

    protected final void setFormat(String format) {
        if ("xmi".equalsIgnoreCase(format)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.XMI_STANDARD));
        } else if ("xmi:argo".equalsIgnoreCase(format)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.XMI_ARGO));
        } else if ("xmi:start".equalsIgnoreCase(format)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.XMI_STAR));
        } else if ("eps".equalsIgnoreCase(format)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.EPS));
        } else if ("eps:txt".equalsIgnoreCase(format)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.EPS_TEXT));
        } else if ("svg".equalsIgnoreCase(format)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.SVG));
        } else if ("txt".equalsIgnoreCase(format)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.ATXT));
        } else if ("utxt".equalsIgnoreCase(format)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.UTXT));
        } else if ("png".equalsIgnoreCase(format)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.PNG));
        } else if ("pdf".equalsIgnoreCase(format)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.PDF));
        } else {
            throw new IllegalArgumentException("Unrecognized format <" + format + ">");
        }
    }

    public void execute() throws MojoExecutionException {
        String invalidSourceFilesDirectoryWarnMsg = this.sourceFiles.getDirectory() + " is not a valid path";
        if (null == this.sourceFiles.getDirectory() || this.sourceFiles.getDirectory().isEmpty()) {
            this.getLog().warn((CharSequence)invalidSourceFilesDirectoryWarnMsg);
            return;
        }
        File baseDir = null;
        try {
            baseDir = new File(this.sourceFiles.getDirectory());
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)invalidSourceFilesDirectoryWarnMsg, (Throwable)e);
        }
        if (null == baseDir || !baseDir.exists() || !baseDir.isDirectory()) {
            this.getLog().warn((CharSequence)invalidSourceFilesDirectoryWarnMsg);
            return;
        }
        if (!this.outputInSourceDirectory) {
            if (!this.outputDirectory.exists()) {
                this.outputDirectory.mkdirs();
            }
            if (!this.outputDirectory.isDirectory()) {
                throw new IllegalArgumentException("<" + this.outputDirectory + "> is not a valid directory.");
            }
        }
        try {
            if (!this.outputInSourceDirectory) {
                this.option.setOutputDir(this.outputDirectory);
            }
            if (this.charset != null) {
                this.option.setCharset(this.charset);
            }
            if (this.config != null) {
                this.option.initConfig(this.config);
            }
            if (this.graphvizDot != null) {
                OptionFlags.getInstance().setDotExecutable(this.graphvizDot);
            }
            if (this.format != null) {
                this.setFormat(this.format);
            }
            if (this.verbose) {
                OptionFlags.getInstance().setVerbose(true);
            }
            List files = FileUtils.getFiles((File)baseDir, (String)this.getCommaSeparatedList(this.sourceFiles.getIncludes()), (String)this.getCommaSeparatedList(this.sourceFiles.getExcludes()));
            for (File file : files) {
                this.getLog().info((CharSequence)("Processing file <" + file + ">"));
                if (this.outputInSourceDirectory) {
                    this.option.setOutputDir(file.getParentFile());
                } else {
                    Path fileBasePath = file.getParentFile().toPath();
                    if (this.truncatePattern != null && this.truncatePattern.length() > 0) {
                        String[] truncateTokens = this.truncatePattern.split("/");
                        int truncateIndex = 0;
                        int endIndex = 0;
                        for (Path path : fileBasePath) {
                            ++endIndex;
                            String currentTruncateToken = truncateTokens[truncateIndex];
                            if ("*".equals(currentTruncateToken) || path.getFileName().toString().equals(currentTruncateToken)) {
                                if (++truncateIndex != truncateTokens.length) continue;
                                Path root = fileBasePath.getRoot();
                                Path subpath = fileBasePath.subpath(0, endIndex);
                                if (root != null) {
                                    fileBasePath = root.resolve(subpath);
                                    break;
                                }
                                fileBasePath = subpath;
                                break;
                            }
                            truncateIndex = 0;
                        }
                    }
                    Path relativize = fileBasePath.relativize(file.toPath().getParent());
                    File outputDir = this.outputDirectory.toPath().resolve(relativize).toFile();
                    this.option.setOutputDir(outputDir);
                }
                SourceFileReader sourceFileReader = new SourceFileReader(Defines.createEmpty(), file, this.option.getOutputDir(), this.option.getConfig(), this.option.getCharset(), this.option.getFileFormatOption());
                for (GeneratedImage image : sourceFileReader.getGeneratedImages()) {
                    this.getLog().debug((CharSequence)(image + " " + image.getDescription()));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception during plantuml process", e);
        }
    }

    protected String getCommaSeparatedList(List<String> list) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            String object = it.next();
            builder.append(object.toString());
            if (!it.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    protected FileFormatOption getFileFormatOption() {
        FileFormatOption formatOptions = new FileFormatOption(this.option.getFileFormatOption().getFileFormat(), this.withMetadata);
        if (formatOptions.isWithMetadata() != this.withMetadata) {
            return new FileFormatOption(this.option.getFileFormatOption().getFileFormat());
        }
        return formatOptions;
    }
}

