/*
 * Decompiled with CFR 0.152.
 */
package com.github.funthomas424242.rades.annotations.accessors.model.java;

import com.github.funthomas424242.rades.annotations.accessors.model.java.AccessorInjectionService;
import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public class AccessorSrcFileCreator
implements AutoCloseable {
    protected final AccessorInjectionService javaModelService;
    protected final Filer filer;
    protected final String className;
    protected PrintWriter writer;

    public AccessorSrcFileCreator(Filer filer, String className, AccessorInjectionService javaModelService) {
        this.filer = filer;
        this.className = className;
        this.javaModelService = javaModelService;
    }

    public void init() throws IOException {
        this.writer = new PrintWriter(this.filer.createSourceFile(this.className, new Element[0]).openWriter());
    }

    public void writeGetterMethod(String objectName, String fieldName, String getterName, String returnType) {
        this.writer.print("    public ");
        this.writer.print(returnType);
        this.writer.print(" ");
        this.writer.print(getterName);
        this.writer.println("( ) { ");
        this.writer.println("        return this." + objectName + "." + fieldName + ";");
        this.writer.println("    }");
        this.writer.println();
    }

    public void writeGenerateMethod(String objectName, ExecutableElement methode) {
        String methodName = methode.getSimpleName().toString();
        String returnType = methode.getReturnType().toString();
        this.writer.print("    public " + returnType + " " + methodName + "(");
        int[] i = new int[]{1};
        methode.getParameters().forEach(parameter -> {
            if (i[0] != 1) {
                this.writer.append(", ");
            }
            i[0] = i[0] + 1;
            String parameterType = parameter.asType().toString();
            String parameterName = parameter.getSimpleName().toString();
            this.writer.print("final " + parameterType + " " + parameterName);
        });
        this.writer.println("){");
        this.writer.print("        ");
        if (!"void".equals(returnType)) {
            this.writer.print("return ");
        }
        this.writer.print("this." + objectName + "." + methodName + "(");
        i[0] = 1;
        methode.getParameters().forEach(parameter -> {
            if (i[0] != 1) {
                this.writer.append(", ");
            }
            i[0] = i[0] + 1;
            String parameterName = parameter.getSimpleName().toString();
            this.writer.print(parameterName);
        });
        this.writer.println(");");
        this.writer.println("    }");
        this.writer.println();
    }

    public void writeGetOriginalObject(String simpleClassName, String objectName) {
        this.writer.println("    public " + simpleClassName + " to" + simpleClassName + "(){\n        return this." + objectName + ";\n    }\n");
    }

    public void writeConstructors(String simpleClassName, String objectName, String accessorSimpleClassName) {
        this.writer.print("    public " + accessorSimpleClassName + "( final " + simpleClassName + " " + objectName + " ){\n");
        this.writer.print("        this." + objectName + " = " + objectName + ";\n");
        this.writer.print("    }\n");
        this.writer.println();
    }

    public void writeFieldDefinition(String simpleClassName, String objectName) {
        this.writer.print("    protected final ");
        this.writer.print(simpleClassName);
        this.writer.print(" " + objectName + ";\n\n");
    }

    public void writeClassDeclaration(String accessorSimpleClassName) {
        this.writer.println("public class " + accessorSimpleClassName + " {");
        this.writer.println();
    }

    public void writeClassAnnotations(String className) {
        this.writer.print("@Generated(value=\"RadesAccessorProcessor\"\n, date=\"" + this.javaModelService.getNowAsISOString() + "\"\n, comments=\"" + className + "\")\n");
    }

    public void writePackage(String packageName) {
        this.writer.print("package ");
        this.writer.println(packageName + ";");
    }

    public void writeImports() {
        this.writer.println("import javax.annotation.Generated;");
        this.writer.println();
    }

    public void writeClassFinal() {
        this.writer.println("}");
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }
}

