/*
 * Decompiled with CFR 0.152.
 */
package com.github.funthomas424242.rades.annotations.accessors.processors;

import com.github.funthomas424242.rades.annotations.accessors.AddAccessor;
import com.github.funthomas424242.rades.annotations.accessors.NoAccessor;
import com.github.funthomas424242.rades.annotations.accessors.RadesAddAccessor;
import com.github.funthomas424242.rades.annotations.accessors.RadesNoAccessor;
import com.github.funthomas424242.rades.annotations.accessors.model.java.AccessorInjectionService;
import com.github.funthomas424242.rades.annotations.accessors.model.java.AccessorInjectionServiceProvider;
import com.github.funthomas424242.rades.annotations.accessors.model.java.AccessorSrcFileCreator;
import com.github.funthomas424242.rades.annotations.lang.java.JavaModelHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedAnnotationTypes(value={"com.github.funthomas424242.rades.annotations.accessors.RadesAddAccessor", "com.github.funthomas424242.rades.annotations.accessors.AddAccessor"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class RadesAccessorProcessor
extends AbstractProcessor {
    protected final Logger logger = LoggerFactory.getLogger(RadesAccessorProcessor.class);
    protected AccessorInjectionService javaModelService = new AccessorInjectionServiceProvider();
    protected ProcessingEnvironment processingEnvironment;

    public void setJavaModelService(AccessorInjectionService javaModelService) {
        this.javaModelService = javaModelService;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.processingEnvironment = processingEnv;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Stack<TypeElement> allAnnotations = new Stack<TypeElement>();
        annotations.stream().collect(Collectors.toList()).forEach(annotation -> allAnnotations.push((TypeElement)annotation));
        HashSet<TypeElement> processedAnnotations = new HashSet<TypeElement>();
        HashSet<Element> annotatedClasses = new HashSet<Element>();
        while (!allAnnotations.empty()) {
            TypeElement annotation2 = (TypeElement)allAnnotations.pop();
            processedAnnotations.add(annotation2);
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(annotation2);
            for (Element element2 : annotatedElements) {
                if (element2.getKind() == ElementKind.ANNOTATION_TYPE) {
                    TypeElement typeElement = (TypeElement)element2;
                    if (processedAnnotations.contains(typeElement)) continue;
                    this.logger.debug("###Annotation: " + typeElement);
                    allAnnotations.push(typeElement);
                    continue;
                }
                if (!element2.getKind().isClass()) continue;
                this.logger.debug("###Class: " + element2);
                annotatedClasses.add(element2);
            }
        }
        annotatedClasses.forEach(element -> this.createAccessorSrcFile((Element)element));
        return true;
    }

    private void createAccessorSrcFile(Element annotatedElement) {
        this.logger.debug("###WRITE ACCESSOR for: " + annotatedElement);
        TypeElement typeElement = (TypeElement)annotatedElement;
        HashMap<Name, Element> mapName2Element = new HashMap<Name, Element>();
        List<? extends Element> classMembers = annotatedElement.getEnclosedElements();
        for (Element element : classMembers) {
            Set<Modifier> fieldModifiers;
            if (!element.getKind().isField() && element.getKind() != ElementKind.METHOD || (fieldModifiers = element.getModifiers()).contains((Object)Modifier.PRIVATE)) continue;
            Name fieldName = element.getSimpleName();
            mapName2Element.put(fieldName, element);
        }
        this.writeAccessorFile(typeElement, mapName2Element);
    }

    protected void writeAccessorFile(TypeElement typeElement, Map<Name, Element> mapMemberName2Element) {
        String specifiedAccessorClassName = null;
        specifiedAccessorClassName = this.getRadesAddAccessorSimpleClassName(typeElement, specifiedAccessorClassName);
        specifiedAccessorClassName = this.getAddAccessorSimpleClassName(typeElement, specifiedAccessorClassName);
        String qualifiedClassName = typeElement.getQualifiedName().toString();
        String simpleClassName = typeElement.getSimpleName().toString();
        String packageName = JavaModelHelper.computePackageName(qualifiedClassName);
        String newInstanceName = simpleClassName.substring(0, 1).toLowerCase() + simpleClassName.substring(1);
        String accessorClassName = this.getAccessorClassName(specifiedAccessorClassName, packageName, qualifiedClassName);
        String accessorSimpleClassName = this.getAccessorSimpleClassName(specifiedAccessorClassName, simpleClassName);
        this.logger.debug("###specifiedAccessorClassName: " + specifiedAccessorClassName);
        this.logger.debug("###accessorClassName: " + accessorClassName);
        this.logger.debug("###accessorSimpleClassName: " + accessorSimpleClassName);
        Filer filer = this.processingEnv.getFiler();
        try (AccessorSrcFileCreator javaSrcFileCreator = this.javaModelService.getJavaSrcFileCreator(filer, accessorClassName);){
            javaSrcFileCreator.init();
            if (packageName != null) {
                javaSrcFileCreator.writePackage(packageName);
            }
            javaSrcFileCreator.writeImports();
            javaSrcFileCreator.writeClassAnnotations(qualifiedClassName);
            javaSrcFileCreator.writeClassDeclaration(accessorSimpleClassName);
            javaSrcFileCreator.writeFieldDefinition(simpleClassName, newInstanceName);
            javaSrcFileCreator.writeConstructors(simpleClassName, newInstanceName, accessorSimpleClassName);
            javaSrcFileCreator.writeGetOriginalObject(simpleClassName, newInstanceName);
            mapMemberName2Element.entrySet().forEach(entry -> {
                Element element = (Element)entry.getValue();
                TypeMirror memberType = element.asType();
                String memberName = ((Name)entry.getKey()).toString();
                String memberFullQualifiedTypName = this.getFullQualifiedTypeSignature(memberType);
                if (element.getKind().isField()) {
                    if (element.getAnnotation(RadesNoAccessor.class) == null && element.getAnnotation(NoAccessor.class) == null) {
                        String getterName = "get" + memberName.substring(0, 1).toUpperCase() + memberName.substring(1);
                        javaSrcFileCreator.writeGetterMethod(newInstanceName, memberName, getterName, memberFullQualifiedTypName);
                    }
                } else if (element.getKind() == ElementKind.METHOD) {
                    this.logger.debug("###Methode: " + element.toString());
                    if (element instanceof ExecutableElement) {
                        ExecutableElement executableElement = (ExecutableElement)element;
                        javaSrcFileCreator.writeGenerateMethod(newInstanceName, executableElement);
                    }
                }
            });
            javaSrcFileCreator.writeClassFinal();
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
        }
    }

    protected String getAccessorSimpleClassName(String specifiedAccessorClassName, String simpleClassName) {
        if (specifiedAccessorClassName != null) {
            return specifiedAccessorClassName;
        }
        return simpleClassName + "Accessor";
    }

    protected String getAccessorClassName(String specifiedAccessorClassName, String packageName, String className) {
        if (specifiedAccessorClassName != null) {
            return packageName + "." + specifiedAccessorClassName;
        }
        return className + "Accessor";
    }

    protected String getRadesAddAccessorSimpleClassName(TypeElement typeElement, String specifiedAccessorClassName) {
        RadesAddAccessor radesAddAccessor = typeElement.getAnnotation(RadesAddAccessor.class);
        if (specifiedAccessorClassName == null && radesAddAccessor != null) {
            String tmp = radesAddAccessor.simpleAccessorClassName().trim();
            if (tmp.length() > 0) {
                return tmp;
            }
            this.logger.debug("###1|SimpleAccessorClassName: " + specifiedAccessorClassName);
        }
        return specifiedAccessorClassName;
    }

    protected String getAddAccessorSimpleClassName(TypeElement typeElement, String specifiedAccessorClassName) {
        AddAccessor addAccessor = typeElement.getAnnotation(AddAccessor.class);
        if (specifiedAccessorClassName == null && addAccessor != null) {
            String tmp = addAccessor.simpleAccessorClassName().trim();
            if (tmp.length() > 0) {
                return tmp;
            }
            this.logger.debug("###2|SimpleAccessorClassName: " + specifiedAccessorClassName);
        }
        return specifiedAccessorClassName;
    }

    protected String getFullQualifiedClassName(TypeMirror typeMirror) {
        String typeName;
        if (typeMirror instanceof DeclaredType) {
            DeclaredType type = (DeclaredType)typeMirror;
            typeName = type.asElement().toString();
        } else {
            typeName = typeMirror.toString();
        }
        return typeName;
    }

    protected String getFullQualifiedTypeSignature(TypeMirror type) {
        StringBuffer typeSignature = new StringBuffer();
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            typeSignature.append(this.getFullQualifiedClassName(type));
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (!typeArguments.isEmpty()) {
                typeSignature.append("<");
                ListIterator<? extends TypeMirror> it = typeArguments.listIterator();
                while (it.hasNext()) {
                    typeSignature.append(this.getFullQualifiedTypeSignature(it.next()));
                    if (!it.hasNext()) continue;
                    typeSignature.append(",");
                }
                typeSignature.append(">");
            }
        } else {
            typeSignature.append(this.getFullQualifiedClassName(type));
        }
        return typeSignature.toString();
    }
}

