/*
 * Decompiled with CFR 0.152.
 */
package com.github.funthomas424242.rades.annotations.builder.model.java;

import com.github.funthomas424242.rades.annotations.builder.model.java.BuilderInjectionService;
import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;

public class BuilderSrcFileCreator
implements AutoCloseable {
    protected final BuilderInjectionService javaModelService;
    protected final Filer filer;
    protected final String className;
    protected PrintWriter writer;

    public BuilderSrcFileCreator(Filer filer, String className, BuilderInjectionService javaModelService) {
        this.filer = filer;
        this.className = className;
        this.javaModelService = javaModelService;
    }

    public void init() throws IOException {
        this.writer = new PrintWriter(this.filer.createSourceFile(this.className, new Element[0]).openWriter());
    }

    public void writeSetterMethod(String objectName, String builderSimpleClassName, String fieldName, String setterName, String argumentType) {
        this.writer.print("    public ");
        this.writer.print(builderSimpleClassName);
        this.writer.print(" ");
        this.writer.print(setterName);
        this.writer.print("( final ");
        this.writer.print(argumentType);
        this.writer.println(" " + fieldName + " ) {");
        this.writer.print("        this." + objectName + ".");
        this.writer.print(fieldName);
        this.writer.println(" = " + fieldName + ";");
        this.writer.println("        return this;");
        this.writer.println("    }");
        this.writer.println();
    }

    public void writeConstructors(String simpleClassName, String objectName, String builderSimpleClassName) {
        this.writer.print("    public " + builderSimpleClassName + "(){\n");
        this.writer.print("        this(new " + simpleClassName + "());\n");
        this.writer.print("    }\n");
        this.writer.print("\n");
        this.writer.print("    public " + builderSimpleClassName + "( final " + simpleClassName + " " + objectName + " ){\n");
        this.writer.print("        this." + objectName + " = " + objectName + ";\n");
        this.writer.print("    }\n");
        this.writer.println();
    }

    public void writeFieldDefinition(String simpleClassName, String objectName) {
        this.writer.print("    private ");
        this.writer.print(simpleClassName);
        this.writer.print(" " + objectName + ";\n\n");
    }

    public void writeClassDeclaration(String builderSimpleClassName) {
        this.writer.println("public class " + builderSimpleClassName + " {");
        this.writer.println();
    }

    public void writeBuildMethod(String simpleClassName, String objectName) {
        this.writer.print("    public ");
        this.writer.print(simpleClassName);
        this.writer.println(" build() {");
        this.writer.println("        final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();");
        this.writer.println("        final java.util.Set<ConstraintViolation<" + simpleClassName + ">> constraintViolations = validator.validate(this." + objectName + ");");
        this.writer.println();
        this.writer.println("        if (constraintViolations.size() > 0) {");
        this.writer.println("            java.util.Set<String> violationMessages = new java.util.HashSet<String>();");
        this.writer.println();
        this.writer.println("            for (ConstraintViolation<?> constraintViolation : constraintViolations) {");
        this.writer.println("                violationMessages.add(constraintViolation.getPropertyPath() + \": \" + constraintViolation.getMessage());");
        this.writer.println("            }");
        this.writer.println();
        this.writer.println("            final StringBuffer buf = new StringBuffer();");
        this.writer.println("            buf.append(\"" + simpleClassName + " is not valid:\\n\");");
        this.writer.println("            violationMessages.forEach(message -> buf.append(message + \"\\n\"));");
        this.writer.println("            throw new ValidationException(buf.toString());");
        this.writer.println("        }");
        this.writer.println("        final " + simpleClassName + " value = this." + objectName + ";");
        this.writer.println("        this." + objectName + " = null;");
        this.writer.println("        return value;");
        this.writer.println("    }");
        this.writer.println();
        this.writer.println("    public <A> A build(Class<A> accessorClass) {\n        final " + simpleClassName + " " + objectName + " = this.build();\n        this." + objectName + "=" + objectName + ";\n        try{\n            final Constructor<A> constructor=accessorClass.getDeclaredConstructor(" + simpleClassName + ".class);\n            final A accessor = constructor.newInstance(" + objectName + ");\n            this." + objectName + "=null;\n            return accessor;\n        }catch(NoSuchMethodException | IllegalAccessException|  InstantiationException|  InvocationTargetException ex){\n            throw new InvalidAccessorException(\"ung\u00fcltige Accessorklasse \u00fcbergeben\",ex);\n        }\n    }\n");
    }

    public void writeClassAnnotations(String className) {
        this.writer.print("@Generated(value=\"RadesBuilderProcessor\"\n, date=\"" + this.javaModelService.getNowAsISOString() + "\"\n, comments=\"" + className + "\")\n");
    }

    public void writePackage(String packageName) {
        this.writer.print("package ");
        this.writer.println(packageName + ";");
    }

    public void writeImports() {
        this.writer.println("import com.github.funthomas424242.rades.annotations.accessors.InvalidAccessorException;");
        this.writer.println("import javax.annotation.Generated;");
        this.writer.println("import javax.validation.ConstraintViolation;");
        this.writer.println("import javax.validation.Validation;");
        this.writer.println("import javax.validation.ValidationException;");
        this.writer.println("import javax.validation.Validator;");
        this.writer.println("import java.lang.reflect.Constructor;");
        this.writer.println("import java.lang.reflect.InvocationTargetException;");
        this.writer.println();
    }

    public void writeClassFinal() {
        this.writer.println("}");
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }
}

