/*
 * Decompiled with CFR 0.152.
 */
package com.github.funthomas424242.rades.annotations.builder.processors;

import com.github.funthomas424242.rades.annotations.builder.AddBuilder;
import com.github.funthomas424242.rades.annotations.builder.NoBuilder;
import com.github.funthomas424242.rades.annotations.builder.RadesAddBuilder;
import com.github.funthomas424242.rades.annotations.builder.RadesNoBuilder;
import com.github.funthomas424242.rades.annotations.builder.model.java.BuilderInjectionService;
import com.github.funthomas424242.rades.annotations.builder.model.java.BuilderInjectionServiceProvider;
import com.github.funthomas424242.rades.annotations.builder.model.java.BuilderSrcFileCreator;
import com.github.funthomas424242.rades.annotations.lang.java.JavaModelHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedAnnotationTypes(value={"com.github.funthomas424242.rades.annotations.builder.RadesBuilder", "com.github.funthomas424242.rades.annotations.builder.RadesAddBuilder", "com.github.funthomas424242.rades.annotations.builder.AddBuilder"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class RadesBuilderProcessor
extends AbstractProcessor {
    protected final Logger logger = LoggerFactory.getLogger(RadesBuilderProcessor.class);
    protected BuilderInjectionService javaModelService = new BuilderInjectionServiceProvider();
    protected ProcessingEnvironment processingEnvironment;

    protected void setJavaModelService(BuilderInjectionService javaModelService) {
        this.javaModelService = javaModelService;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.processingEnvironment = processingEnv;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Stack<TypeElement> allAnnotations = new Stack<TypeElement>();
        annotations.stream().collect(Collectors.toList()).forEach(annotation -> allAnnotations.push((TypeElement)annotation));
        HashSet<TypeElement> processedAnnotations = new HashSet<TypeElement>();
        HashSet<Element> annotatedClasses = new HashSet<Element>();
        while (!allAnnotations.empty()) {
            TypeElement annotation2 = (TypeElement)allAnnotations.pop();
            processedAnnotations.add(annotation2);
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(annotation2);
            for (Element element2 : annotatedElements) {
                if (element2.getKind() == ElementKind.ANNOTATION_TYPE) {
                    TypeElement typeElement = (TypeElement)element2;
                    if (processedAnnotations.contains(typeElement)) continue;
                    this.logger.debug("###Annotation: " + typeElement);
                    allAnnotations.push(typeElement);
                    continue;
                }
                if (!element2.getKind().isClass()) continue;
                this.logger.debug("###Class: " + element2);
                annotatedClasses.add(element2);
            }
        }
        annotatedClasses.forEach(element -> this.createBuilderSrcFile((Element)element));
        return true;
    }

    private void createBuilderSrcFile(Element annotatedElement) {
        this.logger.debug("###WRITE BUILDER for: " + annotatedElement);
        TypeElement typeElement = (TypeElement)annotatedElement;
        HashMap<Name, Element> mapName2Element = new HashMap<Name, Element>();
        List<? extends Element> classMembers = annotatedElement.getEnclosedElements();
        for (Element element : classMembers) {
            Set<Modifier> fieldModifiers;
            if (!element.getKind().isField() || (fieldModifiers = element.getModifiers()).contains((Object)Modifier.PRIVATE)) continue;
            Name fieldName = element.getSimpleName();
            mapName2Element.put(fieldName, element);
        }
        this.writeBuilderFile(typeElement, mapName2Element);
    }

    protected void writeBuilderFile(TypeElement typeElement, Map<Name, Element> mapFieldName2Element) {
        String specifiedBuilderClassName = null;
        specifiedBuilderClassName = this.getRadesAddBuilderSimpleClassName(typeElement, specifiedBuilderClassName);
        specifiedBuilderClassName = this.getAddBuilderSimpleClassName(typeElement, specifiedBuilderClassName);
        String qualifiedClassName = typeElement.getQualifiedName().toString();
        String simpleClassName = typeElement.getSimpleName().toString();
        String packageName = JavaModelHelper.computePackageName(qualifiedClassName);
        String newInstanceName = simpleClassName.substring(0, 1).toLowerCase() + simpleClassName.substring(1);
        String builderClassName = this.getBuilderClassName(specifiedBuilderClassName, packageName, qualifiedClassName);
        String builderSimpleClassName = this.getBuilderSimpleClassName(specifiedBuilderClassName, simpleClassName);
        this.logger.debug("###specifiedBuilderClassName: " + specifiedBuilderClassName);
        this.logger.debug("###builderClassName: " + builderClassName);
        this.logger.debug("###builderSimpleClassName: " + builderSimpleClassName);
        Filer filer = this.processingEnv.getFiler();
        try (BuilderSrcFileCreator javaSrcFileCreator = this.javaModelService.getJavaSrcFileCreator(filer, builderClassName);){
            javaSrcFileCreator.init();
            if (packageName != null) {
                javaSrcFileCreator.writePackage(packageName);
            }
            javaSrcFileCreator.writeImports();
            javaSrcFileCreator.writeClassAnnotations(qualifiedClassName);
            javaSrcFileCreator.writeClassDeclaration(builderSimpleClassName);
            javaSrcFileCreator.writeFieldDefinition(simpleClassName, newInstanceName);
            javaSrcFileCreator.writeConstructors(simpleClassName, newInstanceName, builderSimpleClassName);
            javaSrcFileCreator.writeBuildMethod(simpleClassName, newInstanceName);
            mapFieldName2Element.entrySet().forEach(entry -> {
                Element element = (Element)entry.getValue();
                if (element.getAnnotation(RadesNoBuilder.class) == null && element.getAnnotation(NoBuilder.class) == null) {
                    String fieldName = ((Name)entry.getKey()).toString();
                    String setterName = "with" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    String argumentType = this.getFullQualifiedTypeSignature(element.asType());
                    javaSrcFileCreator.writeSetterMethod(newInstanceName, builderSimpleClassName, fieldName, setterName, argumentType);
                }
            });
            javaSrcFileCreator.writeClassFinal();
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
        }
    }

    protected String getBuilderSimpleClassName(String specifiedBuilderClassName, String simpleClassName) {
        if (specifiedBuilderClassName != null) {
            return specifiedBuilderClassName;
        }
        return simpleClassName + "Builder";
    }

    protected String getBuilderClassName(String specifiedBuilderClassName, String packageName, String className) {
        if (specifiedBuilderClassName != null) {
            return packageName + "." + specifiedBuilderClassName;
        }
        return className + "Builder";
    }

    protected String getRadesAddBuilderSimpleClassName(TypeElement typeElement, String specifiedBuilderClassName) {
        RadesAddBuilder radesAddBuilder = typeElement.getAnnotation(RadesAddBuilder.class);
        if (specifiedBuilderClassName == null && radesAddBuilder != null) {
            String tmp = radesAddBuilder.simpleBuilderClassName().trim();
            if (tmp.length() > 0) {
                return tmp;
            }
            this.logger.debug("###1|SimpleBuilderClassName: " + specifiedBuilderClassName);
        }
        return specifiedBuilderClassName;
    }

    protected String getAddBuilderSimpleClassName(TypeElement typeElement, String specifiedBuilderClassName) {
        AddBuilder addBuilder = typeElement.getAnnotation(AddBuilder.class);
        if (specifiedBuilderClassName == null && addBuilder != null) {
            String tmp = addBuilder.simpleBuilderClassName().trim();
            if (tmp.length() > 0) {
                return tmp;
            }
            this.logger.debug("###2|SimpleBuilderClassName: " + specifiedBuilderClassName);
        }
        return specifiedBuilderClassName;
    }

    protected String getFullQualifiedClassName(TypeMirror typeMirror) {
        String typeName;
        if (typeMirror instanceof DeclaredType) {
            DeclaredType type = (DeclaredType)typeMirror;
            typeName = type.asElement().toString();
        } else {
            typeName = typeMirror.toString();
        }
        return typeName;
    }

    protected String getFullQualifiedTypeSignature(TypeMirror type) {
        StringBuffer typeSignature = new StringBuffer();
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            typeSignature.append(this.getFullQualifiedClassName(type));
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (!typeArguments.isEmpty()) {
                typeSignature.append("<");
                ListIterator<? extends TypeMirror> it = typeArguments.listIterator();
                while (it.hasNext()) {
                    typeSignature.append(this.getFullQualifiedTypeSignature(it.next()));
                    if (!it.hasNext()) continue;
                    typeSignature.append(",");
                }
                typeSignature.append(">");
            }
        } else {
            typeSignature.append(this.getFullQualifiedClassName(type));
        }
        return typeSignature.toString();
    }
}

