/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.exceptions.JedisNoReachableClusterNodeException;

public class JedisSlotBasedConnectionHandler
extends JedisClusterConnectionHandler {
    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int timeout) {
        this(nodes, poolConfig, timeout, timeout);
    }

    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout) {
        super(nodes, poolConfig, connectionTimeout, soTimeout);
    }

    @Override
    public Jedis getConnection() {
        List<JedisPool> pools = this.cache.getShuffledNodesPool();
        for (JedisPool pool : pools) {
            Jedis jedis = null;
            try {
                jedis = pool.getResource();
                if (jedis == null) continue;
                String result = jedis.ping();
                if (result.equalsIgnoreCase("pong")) {
                    return jedis;
                }
                jedis.close();
            }
            catch (JedisException ex) {
                if (jedis == null) continue;
                jedis.close();
            }
        }
        throw new JedisNoReachableClusterNodeException("No reachable node in cluster");
    }

    public boolean cacheTimout() {
        long currTime = System.currentTimeMillis();
        long initTime = this.cache.getInitTime();
        long cacheTimout = this.cache.getCacheTimeout();
        return Math.abs(currTime - initTime) >= cacheTimout;
    }

    public JedisPool getSlotPool(int slot) {
        Map<String, JedisPool> slavePools;
        ArrayList<JedisPool> pools = new ArrayList<JedisPool>();
        JedisPool masterPool = this.cache.getSlotPool(slot);
        if (null != masterPool) {
            pools.add(masterPool);
        }
        if ((slavePools = this.cache.getSlaveNodes(slot)).size() > 0) {
            pools.addAll(slavePools.values());
        }
        if (pools.size() > 0) {
            Random r = new Random();
            return (JedisPool)pools.get(r.nextInt(pools.size()));
        }
        return null;
    }

    @Override
    public Jedis getConnectionFromSlot(int slot) {
        JedisPool connectionPool = this.getSlotPool(slot);
        if (connectionPool != null) {
            Jedis jedis = connectionPool.getResource();
            if (!this.cacheTimout()) {
                return jedis;
            }
            this.cache.setInitTime(System.currentTimeMillis());
            int nodesNum = 0;
            String localNodes = jedis.clusterNodes();
            for (String nodeInfo : localNodes.split("\n")) {
                if (nodeInfo.contains("disconnected") || nodeInfo.contains("fail")) continue;
                ++nodesNum;
            }
            if (this.cache.getNodesNum() == nodesNum) {
                return jedis;
            }
        }
        this.renewSlotCache();
        connectionPool = this.getSlotPool(slot);
        if (connectionPool != null) {
            return connectionPool.getResource();
        }
        return this.getConnection();
    }
}

