/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi.explanation;

import com.clarkparsia.owlapi.explanation.SingleExplanationGeneratorImpl;
import com.clarkparsia.owlapi.explanation.util.DefinitionTracker;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.OpenlletOptions;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyUtils;
import openllet.core.utils.Pair;
import openllet.core.utils.SetUtils;
import openllet.owlapi.AxiomConverter;
import openllet.owlapi.OWL;
import openllet.owlapi.OpenlletReasoner;
import openllet.owlapi.OpenlletReasonerFactory;
import openllet.owlapi.PelletReasoner;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class GlassBoxExplanation
extends SingleExplanationGeneratorImpl {
    public static final Logger _logger;
    private OpenlletReasoner _altReasoner = null;
    private boolean _altReasonerEnabled = false;
    private final AxiomConverter _axiomConverter;

    public static void setup() {
        OpenlletOptions.USE_TRACING = true;
    }

    public GlassBoxExplanation(OWLOntology ontology, OpenlletReasonerFactory factory) {
        this(factory, factory.createReasoner(ontology));
    }

    public GlassBoxExplanation(OpenlletReasoner reasoner) {
        this(new OpenlletReasonerFactory(), reasoner);
    }

    public GlassBoxExplanation(OpenlletReasonerFactory factory, OpenlletReasoner reasoner) {
        super(reasoner.getRootOntology(), (OWLReasonerFactory)factory, (OWLReasoner)reasoner);
        this._axiomConverter = new AxiomConverter(reasoner);
    }

    private void setAltReasonerEnabled(boolean enabled) {
        if (enabled && this._altReasoner == null) {
            _logger.fine("Create alt reasoner");
            this._altReasoner = this.getReasonerFactory().createNonBufferingReasoner(this.getOntology());
        }
        this._altReasonerEnabled = enabled;
    }

    private OWLClass getNegation(OWLClassExpression desc) {
        if (!(desc instanceof OWLObjectComplementOf)) {
            return null;
        }
        OWLClassExpression not = ((OWLObjectComplementOf)desc).getOperand();
        if (not.isAnonymous()) {
            return null;
        }
        return (OWLClass)not;
    }

    private Pair<OWLClass, OWLClass> getSubClassAxiom(OWLClassExpression desc) {
        if (!(desc instanceof OWLObjectIntersectionOf)) {
            return null;
        }
        OWLObjectIntersectionOf conj = (OWLObjectIntersectionOf)desc;
        if (conj.operands().count() != 2L) {
            return null;
        }
        Iterator conjuncts = conj.operands().iterator();
        OWLClassExpression c1 = (OWLClassExpression)conjuncts.next();
        OWLClassExpression c2 = (OWLClassExpression)conjuncts.next();
        OWLClass sub = null;
        OWLClass sup = null;
        if (!c1.isAnonymous()) {
            sub = (OWLClass)c1;
            sup = this.getNegation(c2);
        } else if (!c2.isAnonymous()) {
            sub = (OWLClass)c2;
            sup = this.getNegation(c2);
        }
        if (sup == null) {
            return null;
        }
        return new Pair((Object)sub, (Object)sup);
    }

    private Set<OWLAxiom> getCachedExplanation(OWLClassExpression unsatClass) {
        Set exps;
        OpenlletReasoner pellet = this.getReasoner();
        if (!pellet.getKB().isClassified()) {
            return null;
        }
        Pair<OWLClass, OWLClass> pair = this.getSubClassAxiom(unsatClass);
        if (pair != null && (exps = TaxonomyUtils.getSuperExplanations((Taxonomy)pellet.getKB().getTaxonomy(), (ATermAppl)pellet.term((OWLObject)pair.first), (ATermAppl)pellet.term((OWLObject)pair.second))) != null) {
            Set<OWLAxiom> result = this.convertExplanation((Set)exps.iterator().next());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Cached explanation: " + result);
            }
            return result;
        }
        return null;
    }

    public Set<OWLAxiom> getExplanation(OWLClassExpression unsatClass) {
        Set<OWLAxiom> result = null;
        boolean firstExplanation = this.isFirstExplanation();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Explain: " + unsatClass + " First: " + firstExplanation);
        }
        if (firstExplanation) {
            this._altReasoner = null;
            result = this.getCachedExplanation(unsatClass);
            if (result == null) {
                result = this.getReasonerExplanation(unsatClass);
            }
        } else {
            this.setAltReasonerEnabled(true);
            try {
                result = this.getReasonerExplanation(unsatClass);
            }
            catch (RuntimeException e) {
                _logger.log(Level.SEVERE, "Unexpected error while trying to get explanation set", e);
                throw new OWLRuntimeException((Throwable)e);
            }
            finally {
                this.setAltReasonerEnabled(false);
            }
        }
        return result;
    }

    private Set<OWLAxiom> getReasonerExplanation(OWLClassExpression unsatClass) {
        boolean sat;
        OpenlletReasoner reasoner = this.getReasoner();
        reasoner.getKB().prepare();
        boolean bl = sat = !this.getDefinitionTracker().isDefined(unsatClass);
        if (!sat) {
            sat = this.isSatisfiable(reasoner, unsatClass, true);
        } else {
            _logger.fine(() -> "Undefined entity in " + unsatClass);
        }
        if (sat) {
            return Collections.emptySet();
        }
        Set<OWLAxiom> explanation = this.convertExplanation(reasoner.getKB().getExplanationSet());
        _logger.fine(() -> "Explanation " + explanation);
        Set<OWLAxiom> prunedExplanation = this.pruneExplanation(unsatClass, explanation, true);
        int prunedAxiomCount = explanation.size() - prunedExplanation.size();
        if (_logger.isLoggable(Level.FINE) && prunedAxiomCount > 0) {
            _logger.fine("Pruned " + prunedAxiomCount + " axioms from the explanation: " + SetUtils.difference(explanation, prunedExplanation));
            _logger.fine("New explanation " + prunedExplanation);
        }
        return prunedExplanation;
    }

    private boolean isSatisfiable(OpenlletReasoner pellet, OWLClassExpression unsatClass, boolean doExplanation) {
        pellet.getKB().setDoExplanation(doExplanation);
        boolean sat = unsatClass.isOWLThing() ? pellet.isConsistent() : pellet.isSatisfiable(unsatClass);
        pellet.getKB().setDoExplanation(false);
        return sat;
    }

    private Set<OWLAxiom> convertExplanation(Set<ATermAppl> explanation) {
        if (explanation == null || explanation.isEmpty()) {
            throw new OWLRuntimeException("No explanation computed");
        }
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (ATermAppl term : explanation) {
            OWLAxiom axiom = this._axiomConverter.convert(term);
            if (axiom == null) {
                throw new OWLRuntimeException("Cannot convert: " + term);
            }
            result.add(axiom);
        }
        return result;
    }

    private Set<OWLAxiom> pruneExplanation(OWLClassExpression unsatClass, Set<OWLAxiom> explanation, boolean incremental) {
        try {
            HashSet<OWLAxiom> prunedExplanation = new HashSet<OWLAxiom>(explanation);
            if (prunedExplanation.size() <= 1) {
                return prunedExplanation;
            }
            OWLOntology debuggingOntology = OWL.Ontology(explanation);
            DefinitionTracker defTracker = new DefinitionTracker(debuggingOntology);
            OpenlletReasoner reasoner = this.getReasonerFactory().createNonBufferingReasoner(debuggingOntology);
            if (!defTracker.isDefined(unsatClass)) {
                _logger.warning("Some of the entities in " + unsatClass + " are not defined in the explanation " + explanation);
            }
            if (this.isSatisfiable(reasoner, unsatClass, true)) {
                _logger.warning("Explanation incomplete: Concept " + unsatClass + " is satisfiable in the explanation " + explanation);
            }
            for (OWLAxiom axiom : explanation) {
                _logger.finer(() -> "Try pruning " + axiom);
                if (!incremental) {
                    reasoner.dispose();
                }
                debuggingOntology.remove(axiom);
                if (!incremental) {
                    reasoner = this.getReasonerFactory().createNonBufferingReasoner(debuggingOntology);
                }
                reasoner.getKB().prepare();
                if (defTracker.isDefined(unsatClass) && !this.isSatisfiable(reasoner, unsatClass, false)) {
                    prunedExplanation.remove(axiom);
                    _logger.finer(() -> "Pruned " + axiom);
                    continue;
                }
                debuggingOntology.add(axiom);
            }
            if (incremental) {
                reasoner.dispose();
            }
            OWL._manager.removeOntology(debuggingOntology);
            OWL._manager.removeOntologyChangeListener((OWLOntologyChangeListener)defTracker);
            return prunedExplanation;
        }
        catch (OWLOntologyChangeException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public OpenlletReasoner getReasoner() {
        return this._altReasonerEnabled ? this._altReasoner : (PelletReasoner)super.getReasoner();
    }

    public OpenlletReasonerFactory getReasonerFactory() {
        return (OpenlletReasonerFactory)super.getReasonerFactory();
    }

    public void dispose() {
        this.getOntologyManager().removeOntologyChangeListener((OWLOntologyChangeListener)this.getDefinitionTracker());
        if (this._altReasoner != null) {
            this._altReasoner.dispose();
        }
    }

    public String toString() {
        return "GlassBox";
    }

    static {
        GlassBoxExplanation.setup();
        _logger = Log.getLogger(GlassBoxExplanation.class);
    }
}

