/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi.explanation.io.manchester;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import openllet.owlapi.explanation.io.manchester.BlockWriter;
import openllet.owlapi.explanation.io.manchester.Keyword;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLQuantifiedRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLUnaryPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public class ManchesterSyntaxObjectRenderer
implements OWLObjectVisitor {
    private boolean _wrapLines = true;
    private boolean _smartIndent = true;
    protected BlockWriter _writer;

    public ManchesterSyntaxObjectRenderer(BlockWriter writer) {
        this._writer = writer;
    }

    public boolean isSmartIndent() {
        return this._smartIndent;
    }

    public boolean isWrapLines() {
        return this._wrapLines;
    }

    public void setSmartIndent(boolean smartIndent) {
        this._smartIndent = smartIndent;
    }

    public void setWrapLines(boolean wrapLines) {
        this._wrapLines = wrapLines;
    }

    protected String shortForm(IRI theIRI) {
        String fragment = XMLUtils.getNCNameSuffix((CharSequence)theIRI);
        if (fragment != null) {
            return fragment;
        }
        String str = theIRI.toString();
        int lastSlashIndex = str.lastIndexOf(47);
        if (lastSlashIndex != -1) {
            return str.substring(lastSlashIndex + 1, str.length());
        }
        return str;
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.ASYMMETRIC_PROPERTY);
    }

    public void visit(OWLClass theOWLClass) {
        this.write(theOWLClass.getIRI());
    }

    public void visit(OWLClassAssertionAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.TYPE, (OWLObject)theAxiom.getIndividual(), (OWLObject)theAxiom.getClassExpression());
    }

    public void visit(OWLAnnotation theAnnotation) {
        this.write(Keyword.ANNOTATION);
        this.writeSpace();
        this.write("(");
        this.write((OWLObject)theAnnotation.getProperty());
        this.write(" ");
        this.write((OWLObject)theAnnotation.getValue());
        this.write(")");
    }

    public void visit(OWLDataAllValuesFrom theDescription) {
        this.writeQuantifiedRestriction((OWLQuantifiedRestriction<?>)theDescription, Keyword.ONLY);
    }

    public void visit(OWLDataComplementOf theDescription) {
        this.writeKeywordPrefix(Keyword.NOT, (OWLObject)theDescription.getDataRange());
    }

    public void visit(OWLDataExactCardinality theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?>)theDescription, Keyword.EXACTLY);
    }

    public void visit(OWLDataMaxCardinality theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?>)theDescription, Keyword.MAX);
    }

    public void visit(OWLDataMinCardinality theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?>)theDescription, Keyword.MIN);
    }

    public void visit(OWLDataOneOf theDescription) {
        this.writeEnumeration(theDescription.values());
    }

    public void visit(OWLDataProperty theProperty) {
        this.write(theProperty.getIRI());
    }

    public void visit(OWLDataPropertyAssertionAxiom theAxiom) {
        this.write((OWLObject)theAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getProperty());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getObject());
    }

    public void visit(OWLDataPropertyDomainAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.DOMAIN, theAxiom.getProperty(), theAxiom.getDomain());
    }

    public void visit(OWLDataPropertyRangeAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.RANGE, theAxiom.getProperty(), theAxiom.getRange());
    }

    public void visit(OWLFacetRestriction theRestriction) {
        this.write(theRestriction.getFacet().getSymbolicForm());
        this.writeSpace();
        this.write((OWLObject)theRestriction.getFacetValue());
    }

    public void visit(OWLDatatypeRestriction theRestriction) {
        this.write((OWLObject)theRestriction.getDatatype());
        this.write("[");
        boolean first = true;
        Iterable it = theRestriction.facetRestrictions()::iterator;
        for (OWLFacetRestriction restriction : it) {
            if (first) {
                first = false;
            } else {
                this.write(",");
                this.writeSpace();
            }
            this.write((OWLObject)restriction);
        }
        this.write("]");
    }

    public void visit(OWLDataSomeValuesFrom theDescription) {
        this.writeQuantifiedRestriction((OWLQuantifiedRestriction<?>)theDescription, Keyword.SOME);
    }

    public void visit(OWLSubDataPropertyOfAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.SUB_PROPERTY_OF, (OWLObject)theAxiom.getSubProperty(), (OWLObject)theAxiom.getSuperProperty());
    }

    public void visit(OWLDatatype node) {
        this.write(node.getIRI());
    }

    public void visit(OWLDataHasValue theDescription) {
        this.writeRestriction((OWLPropertyExpression)theDescription.getProperty(), Keyword.VALUE, theDescription.getFiller());
    }

    public void visit(OWLDeclarationAxiom theAxiom) {
        this.writeKeywordPrefix(Keyword.DECLARATION, (OWLObject)theAxiom.getEntity());
    }

    public void visit(OWLDifferentIndividualsAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.individuals(), Keyword.DIFFERENT_INDIVIDUAL, Keyword.DIFFERENT_INDIVIDUALS);
    }

    public void visit(OWLDisjointClassesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.classExpressions(), Keyword.DISJOINT_CLASS, Keyword.DISJOINT_CLASSES);
    }

    public void visit(OWLDisjointDataPropertiesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.properties(), Keyword.DISJOINT_PROPERTY, Keyword.DISJOINT_PROPERTIES);
    }

    public void visit(OWLDisjointObjectPropertiesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.properties(), Keyword.DISJOINT_PROPERTY, Keyword.DISJOINT_PROPERTIES);
    }

    public void visit(OWLDisjointUnionAxiom theAxiom) {
        this.write((OWLObject)theAxiom.getOWLClass());
        this.writeSpace();
        this.write(Keyword.DISJOINT_UNION);
        this.writeSpace();
        this.writeNaryKeyword(Keyword.OR, theAxiom.classExpressions());
    }

    public void visit(OWLEquivalentClassesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.classExpressions(), Keyword.EQUIVALENT_TO, Keyword.EQUIVALENT_CLASSES);
    }

    public void visit(OWLEquivalentDataPropertiesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.properties(), Keyword.EQUIVALENT_TO, Keyword.EQUIVALENT_PROPERTIES);
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.properties(), Keyword.EQUIVALENT_TO, Keyword.EQUIVALENT_PROPERTIES);
    }

    public void visit(OWLFunctionalDataPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.FUNCTIONAL);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.FUNCTIONAL);
    }

    public void visit(OWLAnonymousIndividual theIndividual) {
        this.write(theIndividual.getID().getID());
    }

    public void visit(OWLNamedIndividual theIndividual) {
        this.write(theIndividual.getIRI());
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.INVERSE_FUNCTIONAL);
    }

    public void visit(OWLInverseObjectPropertiesAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.INVERSE_OF, (OWLObject)theAxiom.getFirstProperty(), (OWLObject)theAxiom.getSecondProperty());
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.IRREFLEXIVE);
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom theAxiom) {
        this.write(Keyword.NOT_RELATIONSHIP);
        this.writeSpace();
        this.write("(");
        this.write((OWLObject)theAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getProperty());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getObject());
        this.write(")");
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom theAxiom) {
        this.write(Keyword.NOT_RELATIONSHIP);
        this.writeSpace();
        this.write("(");
        this.write((OWLObject)theAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getProperty());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getObject());
        this.write(")");
    }

    public void visit(OWLObjectAllValuesFrom theDescription) {
        this.writeQuantifiedRestriction((OWLQuantifiedRestriction<?>)theDescription, Keyword.ONLY);
    }

    public void visit(OWLObjectComplementOf theDescription) {
        this.writeKeywordPrefix(Keyword.NOT, (OWLObject)theDescription.getOperand());
    }

    public void visit(OWLObjectExactCardinality theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?>)theDescription, Keyword.EXACTLY);
    }

    public void visit(OWLObjectIntersectionOf theDescription) {
        this.writeNaryKeyword(Keyword.AND, theDescription.operands());
    }

    public void visit(OWLObjectMaxCardinality theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?>)theDescription, Keyword.MAX);
    }

    public void visit(OWLObjectMinCardinality theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?>)theDescription, Keyword.MIN);
    }

    public void visit(OWLObjectOneOf theDescription) {
        this.writeEnumeration(theDescription.individuals());
    }

    public void visit(OWLObjectProperty theProperty) {
        this.write(theProperty.getIRI());
    }

    public void visit(OWLObjectPropertyAssertionAxiom theAxiom) {
        this.write((OWLObject)theAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getProperty());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getObject());
    }

    public void visit(OWLSubPropertyChainOfAxiom theAxiom) {
        this.writeCollection(theAxiom.getPropertyChain(), " o", false);
        this.writeSpace();
        this.write(Keyword.SUB_PROPERTY_OF);
        this.writeSpace();
        this.write((OWLObject)theAxiom.getSuperProperty());
    }

    public void visit(OWLObjectPropertyDomainAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.DOMAIN, theAxiom.getProperty(), theAxiom.getDomain());
    }

    public void visit(OWLObjectInverseOf theInverse) {
        this.writeKeywordPrefix(Keyword.INVERSE, (OWLObject)theInverse.getInverse());
    }

    public void visit(OWLObjectPropertyRangeAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.RANGE, theAxiom.getProperty(), theAxiom.getRange());
    }

    public void visit(OWLObjectHasSelf theRestriction) {
        this.writeRestriction((OWLPropertyExpression)theRestriction.getProperty(), Keyword.SELF, new Object[0]);
    }

    public void visit(OWLObjectSomeValuesFrom theDescription) {
        this.writeQuantifiedRestriction((OWLQuantifiedRestriction<?>)theDescription, Keyword.SOME);
    }

    public void visit(OWLSubObjectPropertyOfAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.SUB_PROPERTY_OF, (OWLObject)theAxiom.getSubProperty(), (OWLObject)theAxiom.getSuperProperty());
    }

    public void visit(OWLObjectUnionOf theDescription) {
        this.writeNaryKeyword(Keyword.OR, theDescription.operands());
    }

    public void visit(OWLObjectHasValue theDescription) {
        this.writeRestriction((OWLPropertyExpression)theDescription.getProperty(), Keyword.VALUE, theDescription.getFiller());
    }

    public void visit(OWLOntology ontology) {
        this.write((IRI)ontology.getOntologyID().getOntologyIRI().orElse(null));
    }

    public void visit(OWLReflexiveObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.REFLEXIVE_PROPERTY);
    }

    public void visit(OWLSameIndividualAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.individuals(), Keyword.SAME_INDIVIDUAL, Keyword.SAME_INDIVIDUALS);
    }

    public void visit(OWLSubClassOfAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.SUB_CLASS_OF, (OWLObject)theAxiom.getSubClass(), (OWLObject)theAxiom.getSuperClass());
    }

    public void visit(OWLSymmetricObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.SYMMETRIC);
    }

    public void visit(OWLTransitiveObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.TRANSITIVE);
    }

    public void visit(OWLLiteral node) {
        if (node.isRDFPlainLiteral()) {
            this.write("\"");
            this.write(node.getLiteral());
            this.write("\"");
            if (node.getLang() != null && !node.getLang().equals("")) {
                this.write("@");
                this.write(node.getLang());
            }
        } else if (node.getDatatype().getIRI().equals((Object)XSDVocabulary.INTEGER.getIRI()) || node.getDatatype().getIRI().equals((Object)XSDVocabulary.DECIMAL.getIRI())) {
            this.write(node.getLiteral());
        } else if (node.getDatatype().getIRI().equals((Object)XSDVocabulary.FLOAT.getIRI())) {
            this.write(node.getLiteral());
            this.write("f");
        } else {
            this.write("\"");
            this.write(node.getLiteral());
            this.write("\"");
            this.write("^^");
            this.write((OWLObject)node.getDatatype());
        }
    }

    public void visit(SWRLLiteralArgument node) {
        this.write((OWLObject)node.getLiteral());
    }

    public void visit(SWRLIndividualArgument node) {
        this.write((OWLObject)node.getIndividual());
    }

    public void visit(SWRLVariable node) {
        this.write("?");
        this.write(node.getIRI());
    }

    public void visit(SWRLBuiltInAtom node) {
        this.write(node.getPredicate());
        this.write("(");
        for (SWRLArgument arg : node.getArguments()) {
            this.write((OWLObject)arg);
            this.write(" ");
        }
        this.write(")");
    }

    public void visit(SWRLClassAtom node) {
        this.write((OWLObject)node.getPredicate());
        this.write("(");
        this.write((OWLObject)node.getArgument());
        this.write(")");
    }

    public void visit(SWRLDataRangeAtom node) {
        this.write((OWLObject)node.getPredicate());
        this.write("(");
        this.write((OWLObject)node.getArgument());
        this.write(")");
    }

    public void visit(SWRLDataPropertyAtom node) {
        this.write((OWLObject)node.getPredicate());
        this.write("(");
        this.write((OWLObject)node.getFirstArgument());
        this.write(", ");
        this.write((OWLObject)node.getSecondArgument());
        this.write(")");
    }

    public void visit(SWRLDifferentIndividualsAtom node) {
        this.write("differentFrom");
        this.write("(");
        this.write((OWLObject)node.getFirstArgument());
        this.write(", ");
        this.write((OWLObject)node.getSecondArgument());
        this.write(")");
    }

    public void visit(SWRLObjectPropertyAtom node) {
        this.write((OWLObject)node.getPredicate());
        this.write("(");
        this.write((OWLObject)node.getFirstArgument());
        this.write(", ");
        this.write((OWLObject)node.getSecondArgument());
        this.write(")");
    }

    public void visit(SWRLRule rule) {
        this.write("Rule");
        this.write("(");
        boolean first = true;
        Iterable it = rule.body()::iterator;
        for (SWRLAtom at : it) {
            if (first) {
                first = false;
            } else {
                this.write(", ");
            }
            this.write((OWLObject)at);
        }
        this.write(" -> ");
        first = true;
        it = rule.head()::iterator;
        for (SWRLAtom at : it) {
            if (first) {
                first = false;
            } else {
                this.write(", ");
            }
            this.write((OWLObject)at);
        }
        this.write(")");
    }

    public void visit(SWRLSameIndividualAtom node) {
        this.write("sameAs");
        this.write("(");
        this.write((OWLObject)node.getFirstArgument());
        this.write(", ");
        this.write((OWLObject)node.getSecondArgument());
        this.write(")");
    }

    protected void writeNaryKeyword(Keyword theKeyword, Stream<? extends OWLObject> theObjects) {
        Iterator aIter = theObjects.sorted().iterator();
        if (this._smartIndent) {
            this._writer.startBlock();
        }
        this.write((OWLObject)aIter.next());
        while (aIter.hasNext()) {
            if (this._wrapLines) {
                this.writeNewLine();
            } else {
                this.writeSpace();
            }
            if (theKeyword != null) {
                this.write(theKeyword);
                this.writeSpace();
            }
            this.write((OWLObject)aIter.next());
        }
        if (this._smartIndent) {
            this._writer.endBlock();
        }
    }

    protected void writeCardinalityRestriction(OWLCardinalityRestriction<?> theRestriction, Keyword theKeyword) {
        if (theRestriction.isQualified()) {
            this.writeRestriction(theRestriction.getProperty(), theKeyword, theRestriction.getCardinality(), theRestriction.getFiller());
        } else {
            this.writeRestriction(theRestriction.getProperty(), theKeyword, theRestriction.getCardinality());
        }
    }

    protected <T extends OWLObject> void writeNaryAxiom(Stream<T> objs, Keyword binary, Keyword nary) {
        List args = objs.sorted().collect(Collectors.toList());
        if (args.size() == 2) {
            this.writeKeywordInfix(binary, (OWLObject)args.get(0), (OWLObject)args.get(1));
        } else {
            this.write(nary);
            this.write("(");
            this.writeNaryKeyword(null, args.stream());
            this.write(")");
        }
    }

    protected void writeNaryAxiom(Set<? extends OWLObject> set, Keyword binary, Keyword nary) {
        this.writeNaryAxiom(set.stream(), binary, nary);
    }

    protected void writeQuantifiedRestriction(OWLQuantifiedRestriction<?> theRestriction, Keyword theKeyword) {
        this.writeRestriction(theRestriction.getProperty(), theKeyword, theRestriction.getFiller());
    }

    protected void writeRestriction(OWLPropertyExpression theProperty, Keyword theKeyword, Object ... theArgs) {
        this.write((OWLObject)theProperty);
        this.writeSpace();
        this.write(theKeyword);
        for (Object aObject : theArgs) {
            this.writeSpace();
            if (aObject instanceof OWLObject) {
                this.write((OWLObject)aObject);
                continue;
            }
            this.write(aObject.toString());
        }
    }

    protected void writeUnaryPropertyAxiom(OWLUnaryPropertyAxiom<?> theAxiom, Keyword keyword) {
        this.writeKeywordPrefix(keyword, theAxiom.getProperty());
    }

    protected void writeKeywordPrefix(Keyword keyword, OWLObject arg) {
        this.write(keyword);
        this.writeSpace();
        this.write(arg);
    }

    protected void writeKeywordPrefix(Keyword keyword, OWLObject arg1, OWLObject arg2) {
        this.write(keyword);
        this.writeSpace();
        this.write("(");
        this.write(arg1);
        this.writeSpace();
        this.write(arg2);
        this.write(")");
    }

    protected void writeKeywordInfix(Keyword keyword, OWLObject arg1, OWLObject arg2) {
        this.write(arg1);
        this.writeSpace();
        this.write(keyword);
        this.writeSpace();
        this.write(arg2);
    }

    protected void writeEnumeration(Set<? extends OWLObject> objects) {
        this.writeEnumeration(objects.stream());
    }

    protected void writeEnumeration(Stream<? extends OWLObject> objects) {
        this.write(Keyword.OPEN_BRACE);
        this.writeCollection(objects, ",", true);
        this.write(Keyword.CLOSE_BRACE);
    }

    protected <T extends OWLObject> void writeCollection(Stream<T> objects, String separator, boolean sort) {
        Stream<T> sobjs = sort ? objects.sorted() : objects;
        boolean first = true;
        Iterable it = sobjs::iterator;
        for (OWLObject ind : it) {
            if (first) {
                first = false;
            } else {
                this.write(separator);
                this.writeSpace();
            }
            this.write(ind);
        }
    }

    protected void writeCollection(Collection<? extends OWLObject> objects, String separator, boolean sort) {
        this.writeCollection(objects.stream(), separator, sort);
    }

    protected void write(OWLObject object) {
        object.accept((OWLObjectVisitor)this);
    }

    protected void write(Keyword keyword) {
        this.write(keyword.getLabel());
    }

    protected void write(String s) {
        this._writer.print(s);
    }

    protected void write(IRI iri) {
        this.write(this.shortForm(iri));
    }

    protected void writeNewLine() {
        this._writer.println();
    }

    protected void writeSpace() {
        this.write(" ");
    }

    public void visit(OWLHasKeyAxiom theAxiom) {
        this.write((OWLObject)theAxiom.getClassExpression());
        this.writeSpace();
        this.write(Keyword.HAS_KEY);
        this.writeCollection(theAxiom.objectPropertyExpressions(), "", true);
        this.writeSpace();
    }

    public void visit(OWLDatatypeDefinitionAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.EQUIVALENT_TO, (OWLObject)theAxiom.getDatatype(), (OWLObject)theAxiom.getDataRange());
    }

    public void visit(OWLAnnotationAssertionAxiom theAxiom) {
        this.write(theAxiom.getSubject());
        this.writeSpace();
        this.write(theAxiom.getProperty());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getValue());
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.SUB_PROPERTY_OF, (OWLObject)theAxiom.getSubProperty(), (OWLObject)theAxiom.getSuperProperty());
    }

    public void visit(OWLAnnotationPropertyDomainAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.DOMAIN, theAxiom.getProperty(), theAxiom.getDomain());
    }

    public void visit(OWLAnnotationPropertyRangeAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.RANGE, theAxiom.getProperty(), theAxiom.getRange());
    }

    public void visit(OWLDataIntersectionOf node) {
        this.writeNaryKeyword(Keyword.AND, node.operands());
    }

    public void visit(OWLDataUnionOf node) {
        this.writeNaryKeyword(Keyword.OR, node.operands());
    }

    public void visit(OWLAnnotationProperty property) {
        this.write(property.getIRI());
    }

    public void visit(IRI iri) {
        this.write(iri);
    }
}

