/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi.explanation.io.manchester;

import java.io.Writer;
import java.util.ArrayList;
import openllet.owlapi.explanation.io.manchester.BlockWriter;

public class TextBlockWriter
extends BlockWriter {
    private final ArrayList<Integer> _blockColumns = new ArrayList();
    private int _column = 0;

    public TextBlockWriter(Writer outWriter) {
        super(outWriter, " ");
    }

    @Override
    protected void startNewLine() {
        if (this._newLine) {
            this._newLine = false;
            if (!this._blockColumns.isEmpty()) {
                int blockStart = this._blockColumns.get(this._blockColumns.size() - 1);
                this.indent(blockStart);
                this._column = blockStart;
            } else {
                this._column = 0;
            }
        }
    }

    @Override
    public void println() {
        super.println();
        this._column = 0;
    }

    @Override
    public void printSpace() {
        super.print(" ");
    }

    public void indent(int count) {
        for (int i = 0; i < count; ++i) {
            this.print(this._pad);
        }
    }

    @Override
    public void clearBlocks() {
        this._blockColumns.clear();
    }

    @Override
    public void startBlock() {
        this._blockColumns.add(this._column);
    }

    @Override
    public void endBlock() {
        if (this._blockColumns.isEmpty()) {
            throw new IllegalStateException("No block to _end!");
        }
        this._blockColumns.remove(this._blockColumns.size() - 1);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        super.write(buf, off, len);
        this._column += len;
    }

    @Override
    public void write(int c) {
        super.write(c);
        ++this._column;
    }

    @Override
    public void write(String s, int off, int len) {
        super.write(s, off, len);
        this._column += len;
    }
}

